/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SWTUtil {
    private static final Logger log = LogManager.getLogger((String)SWTUtil.class.getName());

    public static void dispose(MenuManager aMenuManager) {
        if (aMenuManager == null) {
            return;
        }
        aMenuManager.dispose();
        aMenuManager.removeAll();
    }

    public static void dispose(Widget aWidget) {
        if (aWidget == null) {
            return;
        }
        if (!aWidget.isDisposed()) {
            aWidget.dispose();
        } else {
            log.debug("Widget already disposed: " + aWidget);
        }
    }

    public static void dumpChildren(Composite aComposite) {
        Control[] children;
        log.debug("Children of composite: " + aComposite);
        Control[] controlArray = children = aComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control aChild = controlArray[n2];
            log.debug("\tchild: " + aChild);
            ++n2;
        }
    }

    public static void monitorWidget(Widget aWidget, String name) {
        log.debug("Monitoring Widget: " + name);
        aWidget.addDisposeListener((DisposeListener)new DebugDisposeListener(aWidget));
    }

    private static class DebugDisposeListener
    implements DisposeListener {
        private Widget widgetToDebug = null;

        public DebugDisposeListener(Widget aWidget) {
            this.widgetToDebug = aWidget;
        }

        public void widgetDisposed(DisposeEvent e) {
            log.debug("Widget was disposed: " + this.widgetToDebug);
            this.widgetToDebug.removeDisposeListener((DisposeListener)this);
            this.widgetToDebug = null;
        }
    }
}

