/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import it.jrc.osint.util.ui.EditElementDialog;
import it.jrc.osint.util.ui.ListEditorComponent;
import it.jrc.osint.util.ui.Validators;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class StringListEditorComponent
extends ListEditorComponent {
    public StringListEditorComponent(Composite parent, int style, String elementName) {
        super(parent, style);
        this.elementName = elementName;
        this.performCreateControl();
    }

    private List<String> getModelAsStringList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object anObject : this.getModel()) {
            result.add(anObject.toString());
        }
        return result;
    }

    private IInputValidator getAddElementValidator() {
        return Validators.notEmpty("Please enter a non-empty string", Validators.notEqualsExistingValues(String.valueOf(this.elementName) + " already exists", this.getModelAsStringList()));
    }

    private IInputValidator getEditElementValidator(String editedValue) {
        return Validators.notEmpty("Please enter a non-empty string", Validators.notEqualsExistingValues(String.valueOf(this.elementName) + " already exists", this.getModelAsStringList(), editedValue, null));
    }

    @Override
    protected void createControl() {
    }

    @Override
    protected EditElementDialog createAddDialog(Shell parentShell) {
        return new EditStringDialog(parentShell, "Add a new " + this.elementName, String.valueOf(this.elementName) + ":", "", this.getAddElementValidator());
    }

    @Override
    protected EditElementDialog createEditDialog(Shell parentShell, Object selectedElement) {
        return new EditStringDialog(parentShell, "Edit " + this.elementName, "Edit " + this.elementName + ":", (String)selectedElement, this.getEditElementValidator((String)selectedElement));
    }

    @Override
    protected boolean hasEditDialog() {
        return true;
    }

    private class EditStringDialog
    extends InputDialog
    implements EditElementDialog {
        public EditStringDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        @Override
        public Object getDialogModel() {
            return null;
        }
    }
}

