/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPage;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageModel;
import it.jrc.osint.util.ui.wizard.WizardPageController;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SelectFileWizardPageController
extends WizardPageController {
    private static final Logger log = LogManager.getLogger((String)SelectFileWizardPageController.class.getName());
    private SelectFileWizardPageModel model = new SelectFileWizardPageModel();
    private SelectFileWizardPage view;
    private String pageFileInputLabel = "Select File:";
    private String dialogTitle = "Select File";
    private boolean isSaveDialog = false;
    private boolean pageComplete = false;

    void setView(SelectFileWizardPage view) {
        this.view = view;
    }

    @Override
    public IWizardPage getView() {
        if (this.view == null) {
            this.view = new SelectFileWizardPage("Select import file", this);
            this.view.setPageComplete(this.pageComplete);
        }
        return this.view;
    }

    void showFileDialog(Shell shell) {
        int style = 4096;
        if (this.isSaveDialog) {
            style = 8192;
        }
        FileDialog fileDialog = new FileDialog(shell, style);
        fileDialog.setText(this.dialogTitle);
        String selectedPath = fileDialog.open();
        if (this.verifyPath(selectedPath)) {
            this.view.showFilePath(selectedPath);
            this.view.setSelectionValid(true);
            this.model.setFilePath(selectedPath);
        } else {
            this.view.setSelectionValid(false);
        }
    }

    private boolean verifyPath(String filePath) {
        return filePath != null;
    }

    public boolean hasFilePath() {
        return this.model.getFilePath() != null && !"".equals(this.model.getFilePath());
    }

    public String getFilePath() {
        return this.model.getFilePath();
    }

    public void setDialogTitle(String newTitle) {
        this.dialogTitle = newTitle;
    }

    public void setPageFileInputLabel(String newLabel) {
        this.pageFileInputLabel = newLabel;
    }

    String getPageFileInputLabel() {
        return this.pageFileInputLabel;
    }

    public void setSaveDialog(boolean isSave) {
        this.isSaveDialog = isSave;
    }

    public void setPageComplete(boolean pageComplete) {
        this.pageComplete = pageComplete;
        if (this.view != null) {
            this.view.setPageComplete(pageComplete);
        }
    }
}

