/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageController;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectProjectFolderWizardPage
extends WizardPage {
    private Text filePathText;
    private boolean pageComplete;
    private SelectProjectFolderWizardPageController controller;

    protected SelectProjectFolderWizardPage(String pageName, SelectProjectFolderWizardPageController controller) {
        super(pageName);
        this.controller = controller;
        this.controller.setView(this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblSelectATarget = new Label(container, 0);
        lblSelectATarget.setText(this.controller.getPageFolderInputLabel());
        new Label(container, 0);
        this.filePathText = new Text(container, 2048);
        this.filePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.controller.hasFolder()) {
            this.filePathText.setText(this.controller.getFolder().getFullPath().toString());
            this.setSelectionValid(true);
        }
        Button browseButton = new Button(container, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectFolderWizardPage.this.controller.showSelectImportFolderDialog(SelectProjectFolderWizardPage.this.getShell());
            }
        });
        browseButton.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        browseButton.setText("Browse");
        this.setTitle(this.controller.getPageTitle());
        this.setDescription(this.controller.getPageDescription());
    }

    void showFilePath(final String selectedPath) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectProjectFolderWizardPage.this.getFilePathText().setText(selectedPath);
            }
        });
    }

    private Text getFilePathText() {
        return this.filePathText;
    }

    void setSelectionValid(boolean valid) {
        this.pageComplete = valid;
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectProjectFolderWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        return this.pageComplete;
    }
}

