/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geoutils.GeoUtils;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterData;
import it.jrc.rtn.RTNClusterInfo;
import it.jrc.rtn.RTNClusterInfoParser;
import it.jrc.rtn.RTNItem;
import it.jrc.rtn.RTNProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GeoTester {
    public static Logger logger = Logger.getLogger((String)"it.jrc.geomatcher.tester");
    private boolean annotatemode = false;
    private boolean verbosemode = false;

    public GeoTester(boolean ann, boolean vb) {
        this.annotatemode = ann;
        this.verbosemode = vb;
    }

    public TestResult testGeoCluster(File filename, ProcessRSS prss, File dirout) {
        TestResult rval = null;
        try {
            OutputStreamWriter wri;
            BufferedOutputStream bo;
            ArrayList<TestResult> reslist = new ArrayList<TestResult>(30);
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(filename));
            InputStreamReader reader = new InputStreamReader((InputStream)bi, "UTF-8");
            RTNClusterInfoParser rtnparser = new RTNClusterInfoParser();
            RTNClusterInfo[] rtnci = rtnparser.parse((Reader)reader);
            logger.debug((Object)("testGeoCluster on " + filename));
            rval = new TestResult(filename.toString(), "", rtnci[0].getLanguage());
            for (int i = 0; i < rtnci.length; ++i) {
                System.out.println(rtnci[i].getItems().size());
                System.out.println(rtnci[i].getAllItems().length);
                rtnci[i].combineItems();
                TestResult tres = new TestResult(rtnci[i]);
                logger.debug((Object)("--> " + rtnci[i].getAllItems().length));
                for (RTNItem rtnitem : rtnci[i].getItems().values()) {
                    RSSItem item = rtnitem.getItem();
                    ArrayList itemgeos = item.getElements("emm:georss");
                    logger.debug((Object)("old has : " + itemgeos + " geo items"));
                    if (itemgeos != null) {
                        for (SimpleElement elem : itemgeos) {
                            item.removeElement(elem);
                        }
                    }
                    prss.runOnRSSItem(item, false, -1, true);
                }
                ArrayList<RSSItem> list = new ArrayList<RSSItem>();
                for (RTNItem rtnItem : rtnci[i].getAllItems()) {
                    list.add(rtnItem.getItem());
                }
                ArrayList newgeos = GeoUtils.disambiguateGeoCluster(new ArrayList());
                logger.debug((Object)("After disambiguing : " + newgeos.size()));
                if (this.annotatemode) {
                    rtnci[i].setEmmGeo(newgeos);
                    continue;
                }
                for (SimpleElement elem : newgeos) {
                    tres.addNewElement(elem);
                }
                reslist.add(tres);
                tres.addTo(rval);
            }
            logger.info((Object)"Cluser New Geos");
            File fileout = new File(dirout, filename.getName() + ".out.xml");
            logger.info((Object)("Outputfile : " + fileout));
            if (this.annotatemode) {
                bo = new BufferedOutputStream(new FileOutputStream(fileout));
                wri = new OutputStreamWriter((OutputStream)bo, "UTF-8");
                RTNProcessor rtnp = new RTNProcessor(rtnci[0].getLanguage());
                rtnp.toXML((RTNClusterData[])rtnci, (Writer)wri);
                wri.flush();
                wri.close();
            } else {
                bo = new BufferedOutputStream(new FileOutputStream(fileout));
                wri = new OutputStreamWriter((OutputStream)bo, "UTF-8");
                wri.write("<clusters  xmlns:emm=\"http://emm.jrc.it\">");
                wri.write("<!--");
                rval.toString(wri);
                wri.write("-->");
                for (TestResult tr : reslist) {
                    if (this.verbosemode) {
                        tr.toVerbose(wri);
                        continue;
                    }
                    tr.toString(wri);
                }
                wri.write("</clusters>");
                wri.flush();
                wri.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return rval;
    }

    public TestResult testGeoRSS(String outdir, File dir, ProcessRSS prss) {
        TestResult rval = null;
        try {
            ArrayList<TestResult> reslist = new ArrayList<TestResult>(30);
            rval = new TestResult(dir.toString(), "", dir.getParentFile().getParentFile().getName());
            File[] todo = dir.listFiles();
            for (int dloop = 0; dloop < todo.length; ++dloop) {
                if (!todo[dloop].isFile() || !todo[dloop].getName().endsWith(".xml")) continue;
                BufferedInputStream bi = new BufferedInputStream(new FileInputStream(todo[dloop]));
                String filename = todo[dloop].getName();
                InputStreamReader reader = new InputStreamReader((InputStream)bi, "UTF-8");
                try {
                    RSSParser rtnparser = new RSSParser();
                    RSS rss = rtnparser.parse((Reader)reader);
                    TestResult tres = new TestResult(rss);
                    if (rss.getItems() != null) {
                        for (RSSItem item : rss.getItems()) {
                            ArrayList itemgeos = item.getElements("emm:georss");
                            for (SimpleElement elem : itemgeos) {
                                item.removeElement(elem);
                            }
                            GeocodeMatchResult result = new GeocodeMatchResult();
                            prss.runOnRSSItem(item, false, -1, true);
                        }
                    }
                    ArrayList newgeos = GeoUtils.disambiguateGeoItems((Collection)rss.getItems());
                    for (SimpleElement elem : newgeos) {
                        tres.addNewElement(elem);
                    }
                    reslist.add(tres);
                    tres.addTo(rval);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            logger.info((Object)"Cluser New Geos");
            BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(outdir + dir.getName() + ".out"));
            OutputStreamWriter wri = new OutputStreamWriter((OutputStream)bo, "UTF-8");
            if (this.verbosemode) {
                wri.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<clusters>");
            } else {
                rval.toString(wri);
            }
            for (TestResult tr : reslist) {
                if (this.verbosemode) {
                    tr.toVerbose(wri);
                    continue;
                }
                tr.toString(wri);
            }
            if (this.verbosemode) {
                wri.append("\n</clusters>");
            }
            wri.flush();
            wri.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return rval;
    }

    public static void main(String[] args) throws Exception {
        boolean vb = false;
        boolean an = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("a")) {
                an = true;
            }
            if (!args[i].equals("v")) continue;
            vb = true;
        }
        GeoTester t = new GeoTester(an, vb);
        if (args.length > 0) {
            String pathdir = args[0];
            System.out.println("Reading from dir : " + pathdir);
            File dir = new File(pathdir);
            File webdir = new File("WebContent");
            String fullpath = webdir.getAbsolutePath() + File.separator;
            GeocodeMatcher m = new GeocodeMatcher();
            ProcessRSS prss = m.init(fullpath, null);
            boolean tcount = false;
            boolean tbad = false;
            boolean tgood = false;
            if (args[0].equalsIgnoreCase("testcode")) {
                // empty if block
            }
            if (dir.isDirectory()) {
                File[] todo = dir.listFiles();
                new File(dir, "out").mkdir();
                logger.info((Object)(todo.length + " files need to be processed!"));
                HashMap<String, TestResult> rmap = new HashMap<String, TestResult>();
                GeoTester geoTester = t;
                geoTester.getClass();
                TestResult trglobal = geoTester.new TestResult("Global", " Aggregation of all results", "Global");
                for (int loop = 0; loop < todo.length; ++loop) {
                    TestResult subtotal;
                    TestResult trTemp;
                    if (todo[loop].isDirectory()) continue;
                    if (todo[loop].isFile() && todo[loop].getName().endsWith(".xml") && todo[loop].getName().startsWith("cluster")) {
                        logger.info((Object)("Processing file CLUSTER : " + todo[loop]));
                        trTemp = t.testGeoCluster(todo[loop], prss, new File(todo[loop].getParent() + "/out"));
                        trTemp.addTo(trglobal);
                        subtotal = (TestResult)rmap.get(trTemp.getLang());
                        if (subtotal == null) {
                            GeoTester geoTester2 = t;
                            geoTester2.getClass();
                            subtotal = geoTester2.new TestResult(trTemp.getLang(), trTemp.desc, trTemp.getLang());
                            trTemp.addTo(subtotal);
                            rmap.put(trTemp.getLang(), subtotal);
                            continue;
                        }
                        trTemp.addTo(subtotal);
                        continue;
                    }
                    if (todo[loop].isFile() && todo[loop].getName().endsWith(".rss") || todo[loop].getName().endsWith(".q.xml")) {
                        logger.info((Object)("Processing file RSS : " + todo[loop]));
                        prss.testGeoRSS(todo[loop], todo[loop].getName().startsWith("text"));
                        continue;
                    }
                    if (todo[loop].isFile() && todo[loop].getName().contains("story")) {
                        logger.info((Object)("Processing file STORY : " + todo[loop]));
                        trTemp = t.testGeoRSS(dir.getAbsolutePath() + File.separator, new File("/Volumes/Tomcat5.5-1/webapps/RTNOut/en/stories/20080601"), prss);
                        trTemp.addTo(trglobal);
                        subtotal = (TestResult)rmap.get(trTemp.getLang());
                        if (subtotal == null) {
                            GeoTester geoTester3 = t;
                            geoTester3.getClass();
                            subtotal = geoTester3.new TestResult(trTemp.getLang(), trTemp.desc, trTemp.getLang());
                            trTemp.addTo(subtotal);
                            rmap.put(trTemp.getLang(), subtotal);
                            continue;
                        }
                        trTemp.addTo(subtotal);
                        continue;
                    }
                    logger.debug((Object)("Skipping : " + todo[loop]));
                }
                String filename = dir.getAbsolutePath() + File.separator + "GlobalResult.out";
                logger.debug((Object)("Outfile : " + filename));
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename));
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)bos, "UTF-8");
                trglobal.toString(w);
                for (TestResult val : rmap.values()) {
                    val.toString(w);
                }
                w.flush();
                w.close();
            }
        } else {
            System.err.println("Please add some parameters");
            System.exit(-1);
        }
    }

    public class TestResult {
        public RTNClusterInfo rtnci;
        public RSS rs;
        public ArrayList<SimpleElement> oldelements;
        public ArrayList<SimpleElement> newelements;
        String lang = "";
        String title = "";
        String guid = "";
        String desc = "";
        int count;
        int correct;
        int falsepositive;
        int missed;
        int size;
        ArrayList<RSSItem> items;

        public TestResult(String t, String d, String l) {
            this.title = t;
            this.desc = d;
            this.lang = l;
        }

        public TestResult(RTNClusterInfo ci) {
            this.rtnci = ci;
            this.title = ci.getTitle();
            this.desc = ci.getDescription();
            this.lang = ci.getLanguage();
            this.oldelements = this.rtnci.getGeo();
            if (this.oldelements == null) {
                this.oldelements = new ArrayList(0);
            }
            this.count = this.oldelements.size();
            this.newelements = new ArrayList(this.oldelements.size());
            this.size = ci.getAllItems().length;
            this.items = new ArrayList(this.size);
            for (RTNItem item : ci.getAllItems()) {
                this.items.add(item.getItem());
            }
        }

        public TestResult(RSS rss) {
            this.rs = rss;
            this.title = "(" + rss.getGuid() + ")" + rss.getTitle();
            this.desc = rss.getDescription();
            this.lang = rss.getLanguage();
            this.oldelements = rss.getElements("emm:georss");
            if (this.oldelements == null) {
                this.oldelements = new ArrayList(0);
            }
            this.count = this.oldelements.size();
            this.newelements = new ArrayList(this.oldelements.size());
            this.size = rss.getItems().size();
            this.items = new ArrayList(this.size);
            for (RSSItem item : rss.getItems()) {
                this.items.add(item);
            }
        }

        public void addNewElement(SimpleElement elem) {
            this.newelements.add(elem);
            boolean found = false;
            String id = elem.getAttributeValue("id");
            Iterator<SimpleElement> iter = this.oldelements.iterator();
            while (iter.hasNext() && !found) {
                SimpleElement test = iter.next();
                String tstring = test.getAttributeValue("id");
                if (tstring == null || !id.equals(tstring)) continue;
                found = true;
            }
            if (found) {
                ++this.correct;
            } else if (this.oldelements.size() == 0) {
                ++this.falsepositive;
            }
            this.missed = this.oldelements.size() - this.correct;
        }

        public String getLang() {
            return this.lang;
        }

        public void addTo(TestResult total) {
            total.count += this.count;
            total.correct += this.correct;
            total.falsepositive += this.falsepositive;
            total.missed += this.missed;
        }

        public double badScore() {
            return (double)this.correct * 100.0 / (double)(this.correct + this.missed);
        }

        public double goodScore() {
            return (double)this.correct * 100.0 / (double)(this.correct + this.falsepositive);
        }

        public void toString(Writer wri) throws Exception {
            if (this.rtnci == null && this.rs == null) {
                wri.append("Title: ").append(this.title).append("\n");
                wri.append("Description: ").append(this.desc).append("\n");
                wri.append("Percent Precision ").append(Double.toString(this.goodScore())).append('\n');
                wri.append("Percent Recall ").append(Double.toString(this.badScore())).append('\n');
                wri.append("Count:").append(Integer.toString(this.count));
                wri.append(" Found:").append(Integer.toString(this.correct));
                wri.append(" FalseP:").append(Integer.toString(this.falsepositive));
                wri.append(" Missed:").append(Integer.toString(this.missed)).append('\n');
            } else if (this.count == this.correct && this.falsepositive == 0 && this.missed == 0) {
                StringBuffer locstring = new StringBuffer();
                for (SimpleElement elem : this.newelements) {
                    locstring.append(elem.getAttributeValue("name")).append(",");
                }
                locstring.append("\n");
                wri.append("\nTitle: ").append(this.title).append("");
                wri.append("  ***** OK ****** ").append(locstring.toString());
            } else {
                wri.append("\nTitle: ").append(this.title).append("\n");
                wri.append("Description: ").append(this.desc).append("\n");
                wri.append("\tOLD GEOS\n");
                for (SimpleElement elem : this.oldelements) {
                    elem.toXML(wri);
                    wri.append('\n');
                }
                wri.append("\tNew GEOS\n");
                for (SimpleElement elem : this.newelements) {
                    elem.toXML(wri);
                    wri.append('\n');
                }
            }
            wri.flush();
        }

        public void toVerbose(Writer wri) throws Exception {
            if (this.rtnci == null && this.rs == null) {
                wri.append("<title>").append(this.title).append("</title>\n");
                wri.append("\n<guid>").append(this.guid).append("</guid>\n");
                wri.append("<desc").append(this.desc).append("</desc>\n");
                wri.append("<pp>").append(Double.toString(this.goodScore())).append("</pp>\n");
                wri.append("<pr>").append(Double.toString(this.badScore())).append("</pr>\n");
                wri.append("<count>").append(Integer.toString(this.count));
                wri.append("</count><found>").append(Integer.toString(this.correct));
                wri.append("</found><falsep>").append(Integer.toString(this.falsepositive));
                wri.append("</falsep><missed>").append(Integer.toString(this.missed)).append("</missed>\n");
            } else {
                wri.append("<cluster>");
                wri.append("\n<title>").append(this.title).append("</title>\n");
                wri.append("\n<guid>").append(this.guid).append("</guid>\n");
                wri.append("<desc>").append(this.desc).append("</desc>\n");
                wri.append("<oldgeos>");
                for (SimpleElement elem : this.oldelements) {
                    elem.toXML(wri);
                    wri.append('\n');
                }
                wri.append("</oldgeos>\t<newgeos>\n");
                for (SimpleElement elem : this.newelements) {
                    elem.toXML(wri);
                    wri.append('\n');
                }
                wri.append("</newgeos>\n");
                for (RSSItem item : this.items) {
                    wri.append("<guid>").append(item.getGuid()).append("</guid>\n");
                    wri.append("<title>").append(item.getTitle()).append("</title>\n");
                    wri.append("<desc>").append(item.getDescription()).append("</desc>\n");
                    if (item.getElements("emm:georss") == null) continue;
                    for (SimpleElement elem : item.getElements("emm:georss")) {
                        elem.toXML(wri);
                        wri.append('\n');
                    }
                }
                wri.append("</cluster>");
            }
        }
    }
}

