/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.geocoder.GeoDisAmbiguate;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geoutils.GeoResource;
import it.jrc.geoutils.GeoUtils;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Job;
import it.jrc.scheduler.Scheduler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeocodeMatcher
extends HttpServlet {
    private static Logger logger = Logger.getLogger((String)"it.jrc.geocodematcher");
    private static SimpleDateFormat today = new SimpleDateFormat("dd-MM-yyyy");
    private MatchWords matchWords;
    private ProcessRSS prss;
    private RSSParser rssparser = new RSSParser();
    private static Dispatcher dispatcher;
    private static Scheduler scheduler;
    private String jobQ = null;
    private ArrayList<ProcessRSS> threadPool;
    private int nThreads = 4;
    public static boolean USE_FULL_TEXT;
    public static HashMap<Long, GeoResource> idmap;
    public static HashMap<Long, String> defPlacename;
    public static HashMap<String, Long> isomap;
    public static HashMap<String, Integer> langmap;
    private static final boolean DEBUG = false;
    private static final String VERSION = "3.0.6";

    private void initMatcher(String geoFileName, String isoFileName, String langFileName, String matcherName) {
        long initTime = System.currentTimeMillis();
        this.matchWords = MatchWords.getInstance((String)(matcherName == null ? "geocodeMatcher" : matcherName));
        logger.info((Object)"Initializing GeoMatcher version 3.0.6");
        Hashtable<String, StringBuilder> entries = new Hashtable<String, StringBuilder>();
        this.initLanguages(langFileName);
        logger.info((Object)("found " + langmap.size() + " Language Entries " + ""));
        String line = null;
        long lc = 0L;
        try {
            File file = new File(geoFileName);
            logger.info((Object)("Geonames file created : " + new SimpleDateFormat("dd/MM/yyyy").format(new Date(file.lastModified()))));
            GZIPInputStream zis = new GZIPInputStream(new FileInputStream(geoFileName));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, "utf-8"));
            line = br.readLine();
            HashMap<Long, Integer> defPlacenameLang = new HashMap<Long, Integer>();
            long problems = 0L;
            while (line != null) {
                ++lc;
                if (!line.startsWith("//")) {
                    try {
                        GeoResource gr = new GeoResource(line, ";", langmap);
                        if (gr.name != null && !gr.name.equals("")) {
                            if (gr.gid > 0L) {
                                if (gr.cls <= 0) {
                                    if (!idmap.containsKey(gr.gid)) {
                                        idmap.put(gr.gid, gr);
                                    } else {
                                        GeoResource f = idmap.get(gr.gid);
                                        if (f != null && gr.hasABetterLanguage(f)) {
                                            idmap.put(gr.gid, gr);
                                        }
                                    }
                                } else if (gr.cls <= 3) {
                                    if (defPlacename.get(gr.gid) != null) {
                                        int foundLang = (Integer)defPlacenameLang.get(gr.gid);
                                        int grLan = Integer.MAX_VALUE;
                                        for (Integer num : gr.lang) {
                                            grLan = Math.min(grLan, num);
                                        }
                                        if (grLan < foundLang) {
                                            defPlacename.put(gr.gid, gr.name.replaceAll("\\+", " "));
                                            defPlacenameLang.put(gr.gid, grLan);
                                        }
                                    } else {
                                        int grLang = Integer.MAX_VALUE;
                                        for (Integer num : gr.lang) {
                                            grLang = Math.min(grLang, num);
                                        }
                                        defPlacename.put(gr.gid, gr.name.replaceAll("\\+", " "));
                                        defPlacenameLang.put(gr.gid, grLang);
                                    }
                                }
                            }
                            String hexres = gr.toHexString();
                            if (entries.containsKey(gr.name)) {
                                StringBuilder oldString = (StringBuilder)entries.get(gr.name);
                                String test = oldString.toString();
                                int len = oldString.charAt(0);
                                oldString.setCharAt(0, (char)(++len));
                                oldString.append(hexres);
                                test = oldString.toString();
                                if (test != null) {
                                    ++len;
                                }
                            } else {
                                char iival = '\u0001';
                                char ival = iival;
                                StringBuilder sb = new StringBuilder();
                                sb.append(ival);
                                sb.append(hexres);
                                iival = sb.charAt(0);
                                entries.put(gr.name, sb);
                            }
                        }
                        entries.put("@l']", new StringBuilder(3));
                        entries.put("@d']", new StringBuilder(3));
                    }
                    catch (Exception e) {
                        ++problems;
                    }
                }
                line = br.readLine();
            }
            br.close();
            logger.debug((Object)("Problem loading " + problems + " geo entries"));
            logger.debug((Object)("idmap size : " + idmap.size()));
            logger.debug((Object)("placeNames size : " + defPlacename.size()));
            long mem = 0L;
            for (String str : defPlacename.values()) {
                mem += (long)(8 + str.toCharArray().length * 2);
            }
            defPlacenameLang.clear();
            defPlacenameLang = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(isoFileName), "utf-8"));
            line = br.readLine();
            while (line != null) {
                String[] strings = line.split(";");
                try {
                    if (!"".equals(strings[0])) {
                        isomap.put(strings[0], Long.parseLong(strings[1]));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("on : " + strings[0]), (Throwable)e);
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            logger.error((Object)("could not init geo matcher " + line), (Throwable)e);
        }
        if (!this.matchWords.isInitialized()) {
            logger.info((Object)("Initializing a NEW matchword (named : '" + (matcherName == null ? "geocodeMatcher" : matcherName) + "' )!"));
            this.matchWords.init(entries);
        } else {
            logger.info((Object)"Matchwords already initialized, REUSING IT!");
        }
        entries.clear();
        initTime = (System.currentTimeMillis() - initTime) / 1000L;
        logger.info((Object)("found " + entries.size() + " unique location names from " + lc + " geocodes. " + "Init time " + initTime + " sec"));
        logger.info((Object)("found " + isomap.size() + " Iso map names"));
    }

    String getCompleteInfo(long res, int type) {
        return GeocodeMatcher.getCompleteInfo(res, type, idmap);
    }

    public static String getCompleteInfo(long res, int type, HashMap<Long, GeoResource> mymap) {
        String name;
        GeoResource gr;
        StringBuilder sb = new StringBuilder();
        if ((type & 8) == 8) {
            // empty if block
        }
        if ((type & 4) == 4) {
            gr = mymap.get(GeoUtils.getProvinceId((long)res));
            name = gr != null ? gr.getCleanName() : "-";
            sb.append(name).append(":");
        }
        if ((type & 2) == 2) {
            gr = mymap.get(GeoUtils.getRegionId((long)res));
            name = gr != null ? gr.getCleanName() : "-";
            sb.append(name).append(":");
        }
        if ((type & 1) == 1) {
            gr = mymap.get(GeoUtils.getCountryId((long)res));
            name = gr != null ? gr.getCleanName() : "-";
            sb.append(name);
        }
        return sb.toString();
    }

    protected void initLanguages(String filename) {
        int count = 2;
        try {
            logger.info((Object)("Init languages from: " + filename));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            String line = br.readLine();
            line = br.readLine();
            langmap = new HashMap(7000);
            while (line != null) {
                String[] strings = line.split("\t");
                String id = strings[2];
                if (id == null || id.length() == 0) {
                    id = strings[1];
                }
                if (id != null && id.length() > 0) {
                    langmap.put(id, count);
                    ++count;
                }
                line = br.readLine();
            }
            langmap.put("en", 1);
            langmap.put("Eu", -1);
            langmap.put("Xl", -2);
            langmap.put("PP", -3);
        }
        catch (Exception e) {
            logger.info((Object)"Init Languages error:", (Throwable)e);
        }
        logger.info((Object)("Init found langauge count:" + langmap.size()));
    }

    public void init(ServletConfig config) throws ServletException {
        logger.info((Object)"Initializing Geomatcher!");
        super.init(config);
        String servletName = config.getServletName();
        String realPath = config.getServletContext().getRealPath("/");
        this.jobQ = config.getInitParameter("jobQ");
        this.jobQ = this.jobQ == null || this.jobQ.equals("") ? config.getServletContext().getRealPath("/jobs/") : realPath + this.jobQ;
        logger.info((Object)("jobs live in:" + this.jobQ));
        String qDef = config.getInitParameter("qDef");
        qDef = qDef == null || qDef.equals("") ? realPath + "queues.xml" : realPath + qDef;
        logger.info((Object)("queue definition file live at:" + qDef));
        String sThreads = config.getInitParameter("nThreads");
        if (sThreads != null && !sThreads.equals("")) {
            this.nThreads = new Integer(sThreads);
        }
        logger.info((Object)("the number of worker threads: " + this.nThreads));
        scheduler = new Scheduler(this.jobQ);
        dispatcher = new Dispatcher();
        try {
            dispatcher.initQs(qDef, realPath + "Qs/");
        }
        catch (Exception ex) {
            logger.error((Object)"could not init client qs", (Throwable)ex);
            throw new ServletException("could not init client qs");
        }
        this.checkLibraries();
        String geoFile = config.getInitParameter("geoFile");
        String isoFile = config.getInitParameter("isoFile");
        String langFile = config.getInitParameter("langFile");
        String outPath = config.getInitParameter("outPath");
        boolean fullgeoPar = "true".equalsIgnoreCase(config.getInitParameter("fullGeo")) || "1".equalsIgnoreCase(config.getInitParameter("fullGeo"));
        USE_FULL_TEXT = "true".equalsIgnoreCase(config.getInitParameter("fullText")) || "1".equalsIgnoreCase(config.getInitParameter("fullText"));
        logger.info((Object)("Geofile is in : " + geoFile));
        logger.info((Object)("Isofile is in : " + isoFile));
        logger.info((Object)("Langfile is in : " + langFile));
        logger.info((Object)("FullGeo is : " + fullgeoPar));
        if (USE_FULL_TEXT) {
            logger.info((Object)("I will use the FULL TEXT not only the description!" + USE_FULL_TEXT));
        }
        if (outPath == null) {
            outPath = "output";
        }
        int foundCut = 10;
        int maxThreshold = 1;
        boolean textCut = false;
        try {
            foundCut = Integer.parseInt(config.getInitParameter("foundCut"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            maxThreshold = Integer.parseInt(config.getInitParameter("maxThreshold"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initMatcher(geoFile, isoFile, langFile, config.getInitParameter("matcherName"));
        this.threadPool = new ArrayList();
        for (int nP = 0; nP < this.nThreads; ++nP) {
            GeoDisAmbiguate geodis = new GeoDisAmbiguate(servletName + ":rss:" + nP, idmap, isomap, langmap, foundCut, maxThreshold);
            ProcessRSS processRSS = new ProcessRSS(servletName + ":rss:" + nP, this.matchWords, scheduler, dispatcher, geodis, config.getInitParameter("lang"), realPath + outPath);
            ProcessRSS.FULLGEO = fullgeoPar;
            processRSS.start();
            this.threadPool.add(processRSS);
            logger.info((Object)("Started " + processRSS.getName()));
        }
        GeoDisAmbiguate geodis = new GeoDisAmbiguate(servletName + ":rssStatic:", idmap, isomap, langmap, foundCut, maxThreshold);
        ProcessRSS prss = new ProcessRSS(servletName + ":rssStatic:", this.matchWords, geodis, config.getInitParameter("lang"), realPath + outPath);
        prss.start();
        logger.info((Object)("isomap is " + isomap.size()));
        logger.info((Object)("langmap is " + langmap.size()));
        scheduler.start();
        logger.info((Object)"GeoMatcher Init succesful!");
    }

    private void checkLibraries() throws ServletException {
        try {
            new SimpleElement("pippo").setAttribute("pippo", "pappo");
        }
        catch (Error e) {
            logger.error((Object)"GeoMatcher could not be initialized.. the RssUtils library is too old... update it!", (Throwable)e);
            throw new ServletException("RssUtils library is TOO old checkout from svn teh new version");
        }
    }

    public ProcessRSS init(String fullpath) {
        return this.init(fullpath, null);
    }

    public ProcessRSS init(String fullpath, MatchWords matcher) {
        if (matcher == null) {
            this.initMatcher(fullpath + "geonames.txt.gz", fullpath + "iso2gid.txt", fullpath + "iso-languagecodes.txt", "geocodeMatcher");
        } else {
            this.matchWords = matcher;
            System.out.println("Reusing the same matcher.." + idmap.size() + " " + isomap.size() + " " + langmap.size());
        }
        GeoDisAmbiguate geodis = new GeoDisAmbiguate("test", idmap, isomap, langmap, 30, 10);
        return new ProcessRSS("Test", this.matchWords, geodis, "en", fullpath + "output");
    }

    public ProcessRSS init(String fullpath, MatchWords matcher, HashMap<Long, GeoResource> idmap, HashMap<String, Long> isomap, HashMap<String, Integer> langmap) {
        if (matcher == null) {
            this.initMatcher(fullpath + "geonames.txt.gz", fullpath + "iso2gid.txt", fullpath + "iso-languagecodes.txt", "geocodeMatcher");
        } else {
            this.matchWords = matcher;
            GeocodeMatcher.idmap = idmap;
            GeocodeMatcher.isomap = isomap;
            GeocodeMatcher.langmap = langmap;
            System.out.println("Reusing the same matcher.." + GeocodeMatcher.idmap.size() + " " + GeocodeMatcher.isomap.size() + " " + GeocodeMatcher.langmap.size());
        }
        GeoDisAmbiguate geodis = new GeoDisAmbiguate("test", GeocodeMatcher.idmap, GeocodeMatcher.isomap, GeocodeMatcher.langmap, 30, 10);
        return new ProcessRSS("Test", this.matchWords, geodis, "en", fullpath + "output");
    }

    public void match(String text, MatchResult r) {
        this.matchWords.match(text, r);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sId = null;
        String sRSS = null;
        sId = request.getParameter("id");
        sRSS = request.getParameter("xml");
        if (sId != null && !sId.equals("")) {
            logger.info((Object)("received job for " + sId));
            CachedJob job = CachedJob.makeJob((String)this.jobQ, (String)sId, (String)sRSS);
            int nJobsInQ = scheduler.schedule((Job)job);
            response.setStatus(200);
        } else if (sRSS != null) {
            try {
                logger.info((Object)("handling request:" + sRSS.substring(0, sRSS.length() > 50 ? 50 : sRSS.length() - 1)));
                ByteArrayInputStream sr = new ByteArrayInputStream(sRSS.getBytes());
                InputStreamReader rin = new InputStreamReader((InputStream)sr, "UTF-8");
                RSS rss = this.rssparser.parse((Reader)rin);
                if (request.getParameter("story") != null) {
                    this.prss.runForRSSMixed(rss);
                    ArrayList elems = GeoUtils.disambiguateGeoItems((Collection)rss.getItems());
                    for (SimpleElement elem : elems) {
                        rss.addElement(elem);
                    }
                } else {
                    this.prss.runOnRSS(rss, request.getParameter("txt") != null, 0);
                }
                rss.toXML((Writer)response.getWriter());
                response.setContentType("text/xml");
            }
            catch (Exception e) {
                response.setStatus(500);
                logger.error((Object)"POST FAIL ", (Throwable)e);
            }
        } else {
            logger.error((Object)("BAD inclumming request:" + sRSS));
            response.setStatus(400);
        }
    }

    public void destroy() {
        scheduler.destroy();
        dispatcher.destroy();
        for (int i = 0; i < this.threadPool.size(); ++i) {
            try {
                ProcessRSS p = this.threadPool.get(i);
                logger.info((Object)("stopping " + p.getName()));
                p.end();
                p = null;
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)"destroying", (Throwable)e);
            }
        }
        logger.info((Object)"GeoMatcher stopped");
    }

    public static String getCountryName(long gid) {
        if (idmap == null) {
            return null;
        }
        GeoResource res = idmap.get(GeoUtils.getCountryId((long)gid));
        return res == null ? "null" : res.getCleanName();
    }

    public static void main(String[] args) throws Exception {
        GeocodeMatcher m = new GeocodeMatcher();
        if (args.length > 0) {
            String pathdir = args[0];
            File dir = new File(pathdir);
            File webdir = new File("WebContent");
            String fullpath = webdir.getAbsolutePath() + File.separator;
            ProcessRSS prss = m.init(fullpath, null);
            boolean tcount = false;
            boolean tbad = false;
            boolean tgood = false;
            if (dir.isDirectory()) {
                File[] todo = dir.listFiles();
                for (int loop = 0; loop < todo.length; ++loop) {
                    if (todo[loop].isFile() && todo[loop].getName().endsWith(".xml") && todo[loop].getName().startsWith("cluster") || !todo[loop].isFile() || !todo[loop].getName().endsWith(".xml")) continue;
                    prss.testGeoRSS(todo[loop], todo[loop].getName().startsWith("text"));
                }
            }
        }
    }

    private void testMatcher(String geoFileName, Writer out, ProcessRSS prss) throws Exception {
        try {
            GZIPInputStream zis = new GZIPInputStream(new FileInputStream(geoFileName));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, "utf-8"));
            String line = br.readLine();
            int lc = 0;
            int ok = 0;
            int ignore = 0;
            StringBuilder sid = new StringBuilder();
            while (line != null) {
                ++lc;
                try {
                    GeoResource gr = new GeoResource(line, ";", langmap);
                    GeoResource found = prss.testMatcher(gr);
                    if (found == null) {
                        logger.error((Object)("No match for " + line));
                        out.append("No match for " + line);
                        out.write("\n");
                    } else if (found.lat != gr.lat || found.lon != gr.lon) {
                        logger.error((Object)("Coordinate missmatch " + line + " was found to have lat of  " + found.lat + " and lon of " + found.lon));
                        out.append("Coordinate missmatch " + line + " was found to have lat of  " + found.lat + " and lon of " + found.lon);
                        out.write("\n");
                    } else {
                        ++ok;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("ignoring " + line));
                    ++ignore;
                }
                line = br.readLine();
            }
            logger.info((Object)("total ok " + ok + " total nok " + (lc - ok - ignore)));
            out.append("total ok " + ok + " total nok " + (lc - ok - ignore));
        }
        catch (Exception e) {
            logger.error((Object)"failed to finish test");
        }
    }

    public void setMatchWord(MatchWords matcher) {
        this.matchWords = matcher;
    }

    public MatchWords getMatchWord() {
        return this.matchWords;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String action = request.getParameter("action");
            if ("reinitmatcher".equalsIgnoreCase(action)) {
                this.matchWords.setInitialized(false);
                logger.debug((Object)"Setting the matchword as NOT initilized... please stop all the instances");
                response.getWriter().write("Setting the matchword as NOT initilized... please stop all the instances");
                return;
            }
            String filename = this.getServletContext().getRealPath("..");
            File file = new File(filename = filename + this.getServletContext().getContextPath() + "/WEB-INF/lib/GeoMatcher.jar");
            if (file.exists()) {
                JarFile jarfile = new JarFile(filename);
                Manifest manifest = jarfile.getManifest();
                Attributes attrs = manifest.getMainAttributes();
                for (Attributes.Name name : attrs.keySet()) {
                    String attrValue = attrs.getValue(name);
                }
                if (attrs.getValue("Built-Date") != null) {
                    request.setAttribute("date", (Object)attrs.getValue("Built-Date"));
                }
            } else {
                logger.debug((Object)("File not found." + filename));
            }
            filename = this.getServletConfig().getInitParameter("geoFile");
            long time = new File(filename).lastModified();
            request.setAttribute("resources", (Object)new SimpleDateFormat("dd/MM/yyyy").format(new Date(time)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        request.setAttribute("version", (Object)VERSION);
        request.getRequestDispatcher("__info.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean debugEnabled() {
        return false;
    }

    static {
        idmap = new HashMap(41500, 0.9f);
        defPlacename = new HashMap(249600, 0.9f);
        isomap = new HashMap(300);
        langmap = new HashMap(300);
    }
}

