/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder;

import it.jrc.geocoder.GeoDisAmbiguate;
import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.Function;
import it.jrc.geocoder.test.GeoSteu;
import it.jrc.geoutils.GeoResource;
import it.jrc.geoutils.GeoUtils;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsIntGeoDis
extends GeoDisAmbiguate {
    private static final boolean _STEPS_DEBUG = true;
    Logger logger = Logger.getLogger((String)OsIntGeoDis.class.getName());

    public OsIntGeoDis(String name, HashMap<Long, GeoResource> ids, HashMap<String, Long> imap, HashMap<String, Integer> lmap, int fcut, int maxt) {
        super(name, ids, imap, lmap, fcut, maxt);
    }

    public OsIntGeoDis(GeoDisAmbiguate geodis) {
        this("OsIntGeoDis", geodis.idmap, geodis.isomap, geodis.langmap, geodis.foundCut, geodis.maxThreshold);
    }

    public ArrayList<SimpleElement> disAmbiguateResultOsInt(GeocodeMatchResult result, RSSItem item, String tomatch, int disambiguateLevel) {
        String lang = item.getLanguage();
        if (lang == null) {
            lang = "en";
        }
        this.logger.debug((Object)("Before divideByMatch " + result.getAllPlaces()));
        this.debug_displayPlaces(result.getAllPlaces(), false);
        Collection<GeoResource> unsortedPlaces = result.getAllPlaces();
        unsortedPlaces = this.removeEntities(unsortedPlaces, item.getElements("emm:entity"));
        this.logger.debug((Object)"After removeEntities ");
        this.debug_displayPlaces(unsortedPlaces, false);
        HashMap<Long, GeoResource> actualCountries = new HashMap<Long, GeoResource>();
        HashMap<Long, GeoResource> actualRegions = new HashMap<Long, GeoResource>();
        HashMap<Long, GeoResource> actualProvinces = new HashMap<Long, GeoResource>();
        this.categorizeIt(unsortedPlaces, actualProvinces, actualRegions, actualCountries);
        unsortedPlaces = this.processForLanguagesAndLevel(unsortedPlaces, (Integer)this.langmap.get(lang), disambiguateLevel, actualProvinces, actualRegions, actualCountries);
        this.logger.debug((Object)"After processForLanguagesAndLevel ");
        this.debug_displayPlaces(unsortedPlaces, true);
        HashMap<String, HashSet<GeoResource>> places = this.divideByMatch(unsortedPlaces);
        HashMap<Long, Float> countries = new HashMap<Long, Float>();
        HashMap<Long, Float> regions = new HashMap<Long, Float>();
        HashMap<Long, Float> provinces = new HashMap<Long, Float>();
        for (String placeName : places.keySet()) {
            HashSet<GeoResource> set = places.get(placeName);
            float addendum = 0.5f;
            if (set.size() == 1) {
                addendum = 1.0f;
            }
            for (GeoResource geoRes : set) {
                long gid = geoRes.gid;
                Float count = Float.valueOf(0.0f);
                long country = GeoUtils.getCountryId((long)gid);
                count = countries.get(country);
                count = count == null ? Float.valueOf(addendum) : Float.valueOf(count.floatValue() + addendum);
                countries.put(country, count);
                country = GeoUtils.getRegionId((long)gid);
                count = regions.get(country);
                count = count == null ? Float.valueOf(addendum) : Float.valueOf(count.floatValue() + addendum);
                regions.put(country, count);
                country = GeoUtils.getProvinceId((long)gid);
                count = provinces.get(country);
                count = count == null ? Float.valueOf(addendum) : Float.valueOf(count.floatValue() + addendum);
                provinces.put(country, count);
            }
        }
        this.debugArray("Country", countries, this.idmap);
        this.debugArray("Regions", regions, this.idmap);
        this.debugArray("Provinces", provinces, this.idmap);
        this.removeOnes(countries);
        this.removeOnes(regions);
        this.removeOnes(provinces);
        this.debugArray("Country", countries, this.idmap);
        this.debugArray("Regions", regions, this.idmap);
        this.debugArray("Provinces", provinces, this.idmap);
        ArrayList<GeoResource> last = this.disambiguateOnTextPosition(places, countries, regions, provinces);
        HashMap<Long, SimpleElement> retElements = this.createRetElements(last);
        return new ArrayList<SimpleElement>(retElements.values());
    }

    private void debugArray(String string, HashMap<Long, Float> countries, HashMap<Long, GeoResource> idmap) {
        String deb = string + " ";
        for (Long gid : countries.keySet()) {
            if (idmap.get(gid) == null) {
                this.logger.error((Object)("Problem with : " + gid));
                continue;
            }
            deb = deb + idmap.get(gid).getCleanName() + " " + countries.get(gid);
        }
        this.logger.debug((Object)deb);
    }

    private Collection<GeoResource> getOnly(HashMap<String, HashSet<GeoResource>> places) {
        ArrayList<GeoResource> ret = new ArrayList<GeoResource>();
        for (String match : places.keySet()) {
            HashSet<GeoResource> ress = places.get(match);
            if (ress.size() > 1) continue;
            if (ress.size() == 1) {
                ret.add(ress.iterator().next());
                continue;
            }
            throw new RuntimeException("I shouldn't be here!!!");
        }
        return ret;
    }

    private void removeOnes(HashMap<Long, Float> collections) {
        Iterator<Long> iterator = collections.keySet().iterator();
        while (iterator.hasNext()) {
            Long gid = iterator.next();
            float value = collections.get(gid).floatValue();
            if ((value -= 1.0f) <= 0.0f) {
                iterator.remove();
                continue;
            }
            collections.put(gid, Float.valueOf(value));
        }
    }

    private void debug_displayPlaces(Collection<GeoResource> unsortedPlaces, boolean newline) {
        ArrayList<GeoResource> list = new ArrayList<GeoResource>(unsortedPlaces);
        Collections.sort(list, new Comparator<GeoResource>(){

            @Override
            public int compare(GeoResource o1, GeoResource o2) {
                return o1.getCleanName().compareTo(o2.getCleanName());
            }
        });
        if (newline) {
            this.logger.debug((Object)("   " + ((Object)list).toString().replaceAll(", ", "\n\t\t\t\t\t\t")));
        } else {
            this.logger.debug((Object)("   " + list));
        }
    }

    private void categorizeIt(Collection<GeoResource> unSortedPlaces, HashMap<Long, GeoResource> realProvinces, HashMap<Long, GeoResource> realRegions, HashMap<Long, GeoResource> realCountries) {
        for (GeoResource place : unSortedPlaces) {
            if (GeoUtils.isCountry((long)place.gid)) {
                realCountries.put(place.gid, place);
                continue;
            }
            if (GeoUtils.isRegion((long)place.gid)) {
                realCountries.put(place.gid, place);
                continue;
            }
            if (!GeoUtils.isProvince((long)place.gid)) continue;
            realCountries.put(place.gid, place);
        }
    }

    private void debug_displayPlaces(HashMap<String, ArrayList<GeoResource>> places) {
        List<GeoResource> list = Arrays.asList(places.values().toArray(new GeoResource[1]));
        Collections.sort(list, new Comparator<GeoResource>(){

            @Override
            public int compare(GeoResource o1, GeoResource o2) {
                return o1.getCleanName().compareTo(o2.getCleanName());
            }
        });
        this.logger.debug((Object)("   " + list));
    }

    private HashMap<String, HashSet<GeoResource>> divideByMatch(Collection<GeoResource> allPlaces) {
        HashMap<String, HashSet<GeoResource>> ret = new HashMap<String, HashSet<GeoResource>>();
        for (GeoResource geoResource : allPlaces) {
            this.addTo(ret, geoResource);
        }
        return ret;
    }

    private void addTo(HashMap<String, HashSet<GeoResource>> ret, GeoResource geoResource) {
        HashSet<Object> list = ret.get(geoResource.match);
        if (list == null) {
            list = new HashSet();
            ret.put(geoResource.match, list);
        }
        list.add(geoResource);
    }

    private HashMap<Long, SimpleElement> createRetElements(Collection<GeoResource> places) {
        HashMap<Long, SimpleElement> ret = new HashMap<Long, SimpleElement>();
        for (GeoResource place : places) {
            ret.put(place.gid, this.createElement(place));
        }
        return ret;
    }

    private SimpleElement createElement(GeoResource place) {
        int type = 15;
        if (GeoUtils.isCountry((long)place.gid)) {
            type = 1;
        } else if (GeoUtils.isRegion((long)place.gid)) {
            type = 3;
        } else if (GeoUtils.isProvince((long)place.gid)) {
            type = 7;
        }
        return this.createElement(place, type);
    }

    private Collection<GeoResource> processForLanguagesAndLevel(Collection<GeoResource> places, int lang, int disambiguateLevel, HashMap<Long, GeoResource> actualProvinces, HashMap<Long, GeoResource> actualRegions, HashMap<Long, GeoResource> actualCountries) {
        ArrayList<GeoResource> tobeRemoved = new ArrayList<GeoResource>();
        this.logger.debug((Object)("\t\tThe cutting level is : " + (disambiguateLevel - 3)));
        for (GeoResource place : places) {
            if (!(!place.hasDefaultLang() && !place.lang.contains(lang) || place.cls > disambiguateLevel - 3 && place.gid > 65535L) && Math.abs(place.cls) <= disambiguateLevel - 3) continue;
            tobeRemoved.add(place);
        }
        this.logger.debug((Object)("\t\t Removing " + tobeRemoved.size() + "  " + tobeRemoved));
        for (GeoResource key : tobeRemoved) {
            places.remove(key);
        }
        this.logger.debug((Object)("\t\t Remaining " + places));
        return places;
    }

    private boolean isSmallButPertinent(HashMap<String, GeoResource> places, HashMap<Long, GeoResource> actualProvinces, HashMap<Long, GeoResource> actualRegions, HashMap<Long, GeoResource> actualCountries) {
        throw new RuntimeException("Method OsIntGeoDis.isSmallButPertinent not yet implemented");
    }

    private Collection<GeoResource> removeEntities(Collection<GeoResource> unsortedPlaces, ArrayList<SimpleElement> elements) {
        this.logger.debug((Object)("\tEntities are :" + elements));
        ArrayList<GeoResource> ret = new ArrayList<GeoResource>();
        for (GeoResource place : unsortedPlaces) {
            if (GeoUtils.listContains(elements, (String)place.getCleanName())) continue;
            ret.add(place);
        }
        return ret;
    }

    @Override
    public void sortFilterResultTypes(Collection<GeoResource> ids, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places, ArrayList<SimpleElement> entities, String lang) {
        Integer momVal = (Integer)this.langmap.get(lang);
        if (momVal == null) {
            momVal = (Integer)this.langmap.get("en");
        }
        int lval = momVal;
        int en = (Integer)this.langmap.get("en");
        ArrayList<String> allnames = new ArrayList<String>(ids.size());
        for (GeoResource gr : ids) {
            allnames.add(gr.getCleanName());
        }
        String discarded = "";
        for (GeoResource gr : ids) {
            if (gr.cls == -1 && GeoUtils.isCountry((long)gr.gid)) {
                if (!GeoUtils.listContains(entities, (String)gr.getCleanName())) {
                    countries.add(gr);
                    continue;
                }
                System.err.println("Skipping " + gr.getCleanName());
                continue;
            }
            if (gr.cls >= -3 && !this.isSubstring(allnames, gr.getCleanName())) {
                if (gr.lang.contains(lval) || gr.hasDefaultLang() || gr.lang.contains(en)) {
                    if (GeoUtils.isCountry((long)gr.gid)) {
                        countries.add(gr);
                        continue;
                    }
                    if (GeoUtils.listContains(entities, (String)gr.getCleanName())) continue;
                    if (GeoUtils.isRegion((long)gr.gid)) {
                        regions.add(gr);
                        continue;
                    }
                    if (GeoUtils.isProvince((long)gr.gid)) {
                        provinces.add(gr);
                        continue;
                    }
                    places.add(gr);
                    continue;
                }
                discarded = discarded + gr.getCleanName() + " a " + gr.cls + "  " + gr.gid + ", ";
                continue;
            }
            discarded = discarded + gr.getCleanName() + " b " + gr.cls + ", ";
        }
        this.logger.debug((Object)("\tDiscarded places " + discarded));
    }

    private ArrayList<GeoResource> disambiguateOnTextPosition(HashMap<String, HashSet<GeoResource>> matchedForms, HashMap<Long, Float> countries, HashMap<Long, Float> regions, HashMap<Long, Float> provinces) {
        ArrayList<GeoResource> ret = new ArrayList<GeoResource>();
        for (String matchedForm : matchedForms.keySet()) {
            this.logger.debug((Object)("   disambiguateOnTextPosition " + matchedForm + "  " + matchedForms.get(matchedForm)));
            HashSet<GeoResource> forms = matchedForms.get(matchedForm);
            if (forms.size() == 0) {
                throw new RuntimeException("Something bad happened why I can't find anything mapped in " + matchedForm);
            }
            if (forms.size() == 1) {
                this.logger.debug((Object)("                     theonlyone : " + matchedForm));
                ret.add(forms.iterator().next());
                continue;
            }
            GeoResource rightOne = null;
            for (GeoResource indecided : forms) {
                if (!this.isMaximum(GeoUtils.getProvinceId((long)indecided.gid), provinces)) continue;
                this.logger.debug((Object)("Disambiguated(province)! " + indecided.getCleanName() + " (" + GeocodeMatcher.getCountryName(indecided.gid) + ")"));
                rightOne = indecided;
                break;
            }
            if (rightOne == null) {
                for (GeoResource indecided : forms) {
                    if (!this.isMaximum(GeoUtils.getRegionId((long)indecided.gid), regions)) continue;
                    this.logger.debug((Object)("Disambiguated(region)! " + indecided.getCleanName() + " (" + GeocodeMatcher.getCountryName(indecided.gid) + ")"));
                    rightOne = indecided;
                    break;
                }
            }
            if (rightOne == null) {
                for (GeoResource indecided : forms) {
                    if (!this.isMaximum(GeoUtils.getCountryId((long)indecided.gid), countries)) continue;
                    this.logger.debug((Object)("Disambiguated(country)! " + indecided.getCleanName() + " (" + GeocodeMatcher.getCountryName(indecided.gid) + ")"));
                    rightOne = indecided;
                    break;
                }
            }
            if (rightOne == null) {
                this.logger.error((Object)("I was not able to disambiguate (returning the biggest one) : " + matchedForm));
                ret.add(this.getBiggest(forms));
                continue;
            }
            ret.add(rightOne);
        }
        this.logger.debug((Object)("disambiguateOnTextPosition  RETURNING " + ret.size() + " :" + ret));
        return ret;
    }

    private GeoResource getBiggest(HashSet<GeoResource> forms) {
        GeoResource biggest = null;
        for (GeoResource place : forms) {
            if (biggest != null && place.cls >= biggest.cls) continue;
            biggest = place;
        }
        this.logger.debug((Object)("   the biggest is : " + biggest.getCleanName()));
        return biggest;
    }

    private boolean isMaximum(long gid, HashMap<Long, Float> gidOnCount) {
        float max = this.max(gidOnCount);
        float min = -1.0f;
        if (gidOnCount.get(gid) != null) {
            float maxmom = gidOnCount.get(gid).floatValue();
            this.logger.debug((Object)("   isMax " + gid + " in " + gidOnCount + "  " + (maxmom == max) + "  " + gidOnCount.get(gid)));
            if (gidOnCount.get(gid).floatValue() != max || gidOnCount.get(gid).floatValue() == min) {
                this.logger.debug((Object)"   isMax BUT still returning false");
            }
            return gidOnCount.get(gid).floatValue() == max && gidOnCount.get(gid).floatValue() != min;
        }
        return false;
    }

    private float min(HashMap<Long, Float> gidOnCount) {
        float min = 2.1474836E9f;
        for (Float val : gidOnCount.values()) {
            min = Math.min(min, val.floatValue());
        }
        return min;
    }

    private float max(HashMap<Long, Float> gidOnCount) {
        float max = -10.0f;
        for (Float val : gidOnCount.values()) {
            max = Math.max(max, val.floatValue());
        }
        return max;
    }

    private Map<String, Set<GeoResource>> divideByForm(Collection<GeoResource> places) {
        HashMap<String, Set<GeoResource>> ret = new HashMap<String, Set<GeoResource>>();
        for (GeoResource place : places) {
            Set<GeoResource> list = ret.get(place.match);
            if (list == null) {
                list = new HashSet<GeoResource>();
                ret.put(place.match, list);
            }
            list.add(place);
        }
        return ret;
    }

    @Override
    public void processForLevel(int level, Collection<GeoResource> found, HashMap<Long, SimpleElement> retElements, ArrayList<GeoResource> countries, ArrayList<GeoResource> regions, ArrayList<GeoResource> provinces, ArrayList<GeoResource> places) {
        this.logger.debug((Object)"processForLevel");
        int pclass = level - 3;
        ArrayList<Long> processed = new ArrayList<Long>(100);
        for (GeoResource gr : found) {
            processed.add(gr.gid);
        }
        for (GeoResource gr : places) {
            if (found.contains(gr) || (gr.cls > pclass || gr.provinceFound <= 0 && gr.regionFound <= 0 || gr.countryFound <= 0) && gr.cls != 1) continue;
            retElements.put(gr.gid, this.createElement(gr, 15));
        }
        if (level >= ProcessRSS.PROVINCES) {
            for (GeoResource gr : provinces) {
                if (found.contains(gr) || processed.contains(gr.gid) || gr.regionFound <= 0 || gr.countryFound <= 0) continue;
                retElements.put(gr.gid, this.createElement(gr, 7));
            }
        }
        if (level >= ProcessRSS.REGIONS) {
            for (GeoResource gr : regions) {
                if (found.contains(gr) || processed.contains(gr.gid) || gr.countryFound <= 0) continue;
                retElements.put(gr.gid, this.createElement(gr, 3));
            }
        }
        if (level >= ProcessRSS.COUNTRIES) {
            for (GeoResource gr : countries) {
                if (found.contains(gr) || processed.contains(gr.gid)) continue;
                retElements.put(gr.gid, this.createElement(gr, 1));
            }
        }
    }

    protected ArrayList<GeoResource> removeSmallPlaces(ArrayList<GeoResource> places, ArrayList<GeoResource> provinces, ArrayList<GeoResource> regions, ArrayList<GeoResource> countries, long countryId, int level) {
        this.logger.debug((Object)("removeSmallPlaces operating on " + places.size() + " places" + GeoSteu.myClosure(places, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + " (" + par.cls + ")";
            }
        })));
        this.logger.debug((Object)("  Countries " + GeoSteu.myClosure(countries, "getCleanName")));
        this.logger.debug((Object)("  Regions " + GeoSteu.myClosure(regions, new Function<GeoResource>(){

            @Override
            public String exec(GeoResource par) {
                return par.getCleanName() + " (" + GeocodeMatcher.getCountryName(par.gid) + " " + par.count + ")";
            }
        })));
        this.logger.debug((Object)("  Provinces " + GeoSteu.myClosure(provinces, "getCleanName")));
        ArrayList<GeoResource> retval = new ArrayList<GeoResource>(places.size());
        ArrayList<Long> added = new ArrayList<Long>(places.size());
        for (GeoResource place : places) {
            GeoResource gtest;
            boolean processed = false;
            if (!added.contains(place.gid)) {
                added.add(place.gid);
            } else {
                processed = true;
            }
            Iterator<GeoResource> iter = provinces.iterator();
            boolean found = false;
            if (place.cls < 3 && place.cls > -1) {
                found = true;
                this.logger.debug((Object)("  Added by CLASS(" + place.getCleanName() + "  " + place.cls + ")"));
            }
            if (!found && place.cls > -3 && place.cls < level && GeoUtils.inCountry((long)place.gid, (long)countryId)) {
                found = true;
                this.logger.debug((Object)("  Added by INCOUNTRY (article country) (" + place.getCleanName() + ")"));
            }
            while (iter.hasNext() && !found) {
                gtest = iter.next();
                if (!GeoUtils.inProvince((long)place.gid, (long)gtest.gid) || place.match.equals(gtest.match)) continue;
                found = true;
                this.logger.debug((Object)("  Added by INPROVINCE(" + place.getCleanName() + ")"));
            }
            iter = countries.iterator();
            while (iter.hasNext() && !found) {
                gtest = iter.next();
                if (!GeoUtils.inCountry((long)place.gid, (long)gtest.gid)) continue;
                found = true;
                this.logger.debug((Object)("  Added by INCOUNTRIES(" + place.getCleanName() + ")"));
            }
            iter = regions.iterator();
            while (iter.hasNext() && !found && place.cls < level) {
                gtest = iter.next();
                if (!GeoUtils.inRegion((long)place.gid, (long)gtest.gid) || place.match.equals(gtest.match)) continue;
                found = true;
                this.logger.debug((Object)("  Added by INREGIONS(" + place.getCleanName() + ")"));
            }
            if (processed || !found) continue;
            retval.add(place);
        }
        this.logger.debug((Object)("removeSmallPlaces remaning " + retval.size() + " places" + GeoSteu.myClosure(retval, "getCleanName")));
        return retval;
    }
}

