/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.Function;
import it.jrc.geocoder.test.GeoSteu;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CSVReader {
    String fileName = "emm_false_negatives.csv";
    public static ProcessRSS prss;

    public static void main(String[] args) {
        try {
            new CSVReader().readIt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIt() throws IOException {
        this.init();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), "utf-8"));
        try {
            System.out.println(reader.readLine() + ",NEWRESULT");
            while (reader.ready()) {
                String line = reader.readLine();
                RSSItem item = this.getItem(line);
                ArrayList<SimpleElement> list = prss.runOnRSSOSIntWay(item, false, ProcessRSS.CLASS3, false, false);
                System.out.print(line + ",");
                String newres = GeoSteu.myClosure(list, new Function<SimpleElement>(){

                    @Override
                    public String exec(SimpleElement par) {
                        return par.getAttributeValue("name");
                    }
                });
                newres = "\"" + newres.substring(0, newres.length() - 1).substring(1) + "\"";
                System.out.println(newres);
            }
        }
        finally {
            reader.close();
        }
    }

    private RSSItem getItem(String line) {
        RSSItem ret = new RSSItem();
        String[] split = line.split(",");
        ret.setGuid(split[1]);
        ret.setTitle(split[2]);
        return ret;
    }

    private void init() {
        File webdir = new File("WebContent");
        String fullpath = webdir.getAbsolutePath() + File.separator;
        GeocodeMatcher m = new GeocodeMatcher();
        prss = m.init(fullpath, null);
    }
}

