/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geoutils.GeoResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugDB
extends HttpServlet {
    Logger logger = Logger.getLogger((String)DebugDB.class.getName());
    public static TreeMap<Long, MyResource> all = null;
    public static String currLang = null;
    static String GREEN_GOOD = "#82FA58";
    static String GREEN = "#ACFA58";
    static String RED = "#FE2E2E";
    static String YELLOW = "#F3F781";

    public static void main(String[] args) {
        throw new RuntimeException("Method DebugDB.main not yet implemented");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lang = req.getParameter("lang");
        if (lang == null || "".equals(lang)) {
            lang = "en";
        }
        req.setAttribute("lang", (Object)lang);
        if (!lang.equals(currLang)) {
            try {
                all = new TreeMap();
                this.load(lang);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            currLang = lang;
        }
        req.setAttribute("all", all);
        req.getRequestDispatcher("debug.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void load(String lang) throws Exception {
        File file = new File(this.getServletContext().getRealPath("geonames.txt.gz"));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), "utf-8"));
        long count = 0L;
        all = new TreeMap();
        while (reader.ready()) {
            String line;
            if (count++ % 100000L == 0L) {
                this.logger.debug((Object)("Reading " + count / 100000L + "0k"));
            }
            if ((line = reader.readLine()).startsWith("//") || line.startsWith("#")) continue;
            try {
                GeoResource gr = new GeoResource(line, ";", GeocodeMatcher.langmap);
                if (gr.gid > 511L) {
                    this.logger.debug((Object)("Stopping on : " + gr.gid));
                    break;
                }
                if (!this.isLangOk(gr, lang) || gr.gid <= 0L || gr.gid >= 511L) continue;
                MyResource res = all.get(gr.gid);
                if (res == null) {
                    res = new MyResource();
                    all.put(gr.gid, res);
                }
                res.country.add(gr);
            }
            catch (Exception e) {}
        }
        reader.close();
        this.logger.debug((Object)("Loaded! " + all.size()));
    }

    public static String getCell(ArrayList<GeoResource> ress) {
        String color = "";
        String lang = currLang;
        color = RED;
        String ret = "";
        ArrayList<GeoResource> grs = new ArrayList<GeoResource>();
        grs.addAll(DebugDB.getLang(ress, "PP"));
        grs.addAll(DebugDB.getLang(ress, "Eu"));
        grs.addAll(DebugDB.getLang(ress, currLang));
        ret = DebugDB.getLine(grs);
        color = DebugDB.containsLang(grs, "PP") ? GREEN : (DebugDB.containsLang(grs, "Eu") ? GREEN : (DebugDB.containsLang(grs, currLang) ? GREEN_GOOD : RED));
        return "<td style=\"background-color : " + color + "\">" + ret + "</td>";
    }

    static boolean containsLang(ArrayList<GeoResource> grs, String lang) {
        for (GeoResource gr : grs) {
            if (!gr.lang.contains(GeocodeMatcher.langmap.get(lang))) continue;
            return true;
        }
        return false;
    }

    static String getLine(ArrayList<GeoResource> grs) {
        return grs.toString().replaceAll(", ", "<br/>");
    }

    static ArrayList<GeoResource> getLang(ArrayList<GeoResource> ress, String lang) {
        ArrayList<GeoResource> ret = new ArrayList<GeoResource>();
        if (ress != null && ress.size() > 0) {
            for (GeoResource gr : ress) {
                if (!gr.lang.contains(GeocodeMatcher.langmap.get(lang))) continue;
                ret.add(gr);
            }
        }
        return ret;
    }

    boolean isLangOk(GeoResource gr, String lang) {
        return gr.lang.contains(-1) || gr.lang.contains(-3) || gr.lang.contains(-2) || gr.lang.contains(GeocodeMatcher.langmap.get(lang));
    }

    public class MyResource {
        public ArrayList<GeoResource> country = new ArrayList();
        public ArrayList<GeoResource> capital = new ArrayList();
    }
}

