/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.geocoder.test.debug.StoryChecker;
import it.jrc.geocoder.test.debug.xml.MyRenderer;
import it.jrc.geocoder.test.debug.xml.UpdatingThread;
import it.jrc.geocoder.test.debug.xml.XMLEditorKit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class StatsFrame
extends JFrame
implements ActionListener {
    public static SimpleAttributeSet BRACKET_ATTRIBUTES = new SimpleAttributeSet();
    public static SimpleAttributeSet TAGNAME_ATTRIBUTES = new SimpleAttributeSet();
    public static SimpleAttributeSet ATTRIBUTENAME_ATTRIBUTES = new SimpleAttributeSet();
    public static SimpleAttributeSet ATTRIBUTEVALUE_ATTRIBUTES = new SimpleAttributeSet();
    public static SimpleAttributeSet PLAIN_ATTRIBUTES = new SimpleAttributeSet();
    public static SimpleAttributeSet COMMENT_ATTRIBUTES = new SimpleAttributeSet();
    MyRenderer rend = new MyRenderer();
    private JTextField dirText;
    private JButton exportButt;
    private JList fileList;
    private JTextField fileText;
    private JButton goButt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JButton next;
    private JEditorPane textArea;
    StoryChecker debugs = null;

    public StatsFrame() {
        this.initComponents();
        this.myInit();
    }

    private void myInit() {
        this.textArea.setEditorKit(new XMLEditorKit());
        this.exportButt.addActionListener(this);
        this.goButt.addActionListener(this);
        this.next.addActionListener(this);
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StatsFrame.this.fileText.setText(StatsFrame.this.fileList.getModel().getElementAt(e.getFirstIndex()).toString());
                StatsFrame.this.loadFile(new File(StatsFrame.this.dirText.getText(), StatsFrame.this.fileText.getText()));
            }
        });
        this.dirText.setText("D:/geostats/es");
        this.fileList.setModel(new DefaultListModel());
        this.updateList();
        this.fileList.setCellRenderer(this.rend);
    }

    protected void loadFile(File file) {
        try {
            this.textArea.read((InputStream)new FileInputStream(file), (Object)"");
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e1) {
            this.textArea.setText("Can't read the file...");
            e1.printStackTrace();
        }
    }

    private void updateList() {
        String[] listFiles = new File(this.dirText.getText()).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.contains("~") && !name.contains("#");
            }
        });
        DefaultListModel model = (DefaultListModel)this.fileList.getModel();
        model.removeAllElements();
        for (String file : listFiles) {
            model.addElement(file);
        }
        if (this.rend.th != null) {
            this.rend.th.wantToStop = true;
        }
        this.rend.th = new UpdatingThread(this.dirText.getText(), listFiles, this);
        this.rend.th.start();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.jLabel1 = new JLabel();
        this.dirText = new JTextField();
        this.jLabel2 = new JLabel();
        this.fileText = new JTextField();
        this.exportButt = new JButton();
        this.goButt = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.textArea = new JEditorPane();
        this.next = new JButton();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(774, 513));
        this.fileList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.fileList);
        this.jLabel1.setText("Dir :");
        this.dirText.setText("D:/geostats/it");
        this.jLabel2.setText("file");
        this.exportButt.setText("ExportGeonames");
        this.goButt.setText("GoForIt");
        this.jScrollPane3.setHorizontalScrollBarPolicy(32);
        this.jScrollPane3.setViewportView(this.textArea);
        this.next.setText("next");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 218, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dirText, -2, 188, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileText)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.next).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exportButt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.goButt)).addComponent(this.jScrollPane3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dirText, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.fileText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goButt).addComponent(this.exportButt).addComponent(this.next))).addComponent(this.jScrollPane1, -1, 491, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new StatsFrame().setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.goButt) {
            if (this.debugs == null) {
                this.debugs = new StoryChecker();
            }
            SwingUtilities.invokeLater(new Thread(){

                public void run() {
                    StatsFrame.this.goButt.setEnabled(false);
                    try {
                        StatsFrame.this.debugs.check(true, new File(StatsFrame.this.dirText.getText(), StatsFrame.this.fileText.getText()).getPath());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    StatsFrame.this.goButt.setEnabled(true);
                }
            });
        } else {
            if (e.getSource() == this.exportButt) {
                throw new RuntimeException("Method StatsFrame.actionPerformed not yet implemented");
            }
            if (e.getSource() == this.next) {
                int selected = this.fileList.getSelectedIndex();
                if (selected < 0) {
                    selected = 0;
                }
                this.fileList.setSelectedIndex(selected + 1);
            }
        }
    }

    public void repaintList() {
        DefaultListModel mom = (DefaultListModel)this.fileList.getModel();
        this.fileList.repaint();
    }

    static {
        StyleConstants.setBold(TAGNAME_ATTRIBUTES, true);
        StyleConstants.setForeground(TAGNAME_ATTRIBUTES, Color.GREEN.darker());
        StyleConstants.setBold(ATTRIBUTENAME_ATTRIBUTES, true);
        StyleConstants.setItalic(ATTRIBUTEVALUE_ATTRIBUTES, true);
        StyleConstants.setForeground(ATTRIBUTEVALUE_ATTRIBUTES, Color.BLUE);
        StyleConstants.setFontSize(PLAIN_ATTRIBUTES, StyleConstants.getFontSize(PLAIN_ATTRIBUTES) - 1);
        StyleConstants.setForeground(PLAIN_ATTRIBUTES, Color.DARK_GRAY);
        StyleConstants.setFontSize(COMMENT_ATTRIBUTES, StyleConstants.getFontSize(COMMENT_ATTRIBUTES) - 1);
        StyleConstants.setForeground(COMMENT_ATTRIBUTES, Color.GRAY);
        StyleConstants.setItalic(COMMENT_ATTRIBUTES, true);
    }
}

