/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.Alert;
import it.jrc.alert.PatternCombination;
import it.jrc.emmutils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AlertDefParser
extends DefaultHandler {
    private static final boolean DEBUG = false;
    private static Logger logger = LogManager.getLogger((String)"it.jrc.alert.AlertDefParser");
    private SimpleDateFormat expirydf = new SimpleDateFormat("dd-MM-yyyy");
    private XMLReader xr;
    private Hashtable<String, Alert> allAlerts;
    private Hashtable<String, StringBuilder> allPatterns;
    private Hashtable<Integer, String> allPos;
    private int parseState;
    private StringBuilder elementText;
    private Alert alert;
    private int nPos;
    private String sPattern;
    private String sWeight;
    private ArrayList<PatternCombination> combinations;
    private PatternCombination combi;
    private ArrayList<String> comboElements;
    private String definitionFile = null;

    public AlertDefParser(Hashtable<String, Alert> alerts, Hashtable<String, StringBuilder> patterns, Hashtable<Integer, String> pos) {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
            this.xr.setContentHandler(this);
            this.xr.setErrorHandler(this);
            this.allAlerts = alerts;
            this.allPatterns = patterns;
            this.allPos = pos;
        }
        catch (Exception e) {
            logger.error("could not create alertDefParser ", (Throwable)e);
        }
    }

    public void parse(File xml) {
        try {
            logger.info("Reading alert definitions from " + xml.getAbsolutePath());
            this.definitionFile = xml.getName();
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(xml), "utf-8");
            this.parseState = 0;
            this.xr.parse(new InputSource(r));
        }
        catch (Exception e) {
            logger.error("error parsing " + xml.getName(), (Throwable)e);
        }
    }

    private void addPattern(String sPattern, int nWeight, int nPos) {
        StringBuilder info = this.allPatterns.get(sPattern);
        if (info == null) {
            info = new StringBuilder();
            info.append('\u0001');
            info.append((char)nPos);
            info.append((char)nWeight);
            this.allPatterns.put(sPattern, info);
        } else {
            boolean found = false;
            int nWeights = info.charAt(0);
            for (int i = 0; i < nWeights && !found; ++i) {
                char alertPos = info.charAt(i * 2 + 1);
                found = alertPos == nPos;
            }
            if (!found) {
                info.setCharAt(0, (char)(++nWeights));
                info.append((char)nPos);
                info.append((char)nWeight);
            }
        }
    }

    @Override
    public void startDocument() {
        this.elementText = new StringBuilder(4096);
    }

    @Override
    public void endDocument() {
        this.elementText = null;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        String element = qName;
        try {
            switch (this.parseState) {
                case 0: {
                    String xmlName;
                    if (!element.equals("alert")) break;
                    String rawName = atts.getValue("id");
                    if (rawName.equals(xmlName = Utils.encodeXML((String)rawName))) {
                        this.alert = new Alert();
                        this.alert.setDefinitionFile(this.definitionFile);
                        this.combinations = new ArrayList();
                        this.alert.setID(atts.getValue("id"));
                        logger.info("parsing alert definition for " + this.alert.getID());
                        this.nPos = this.allPos.size();
                        this.parseState = 1;
                        break;
                    }
                    logger.error("Alert " + rawName + " ignored. Name contains illegal characters and is not equal to " + xmlName);
                    break;
                }
                case 1: {
                    if (element.equals("definition")) {
                        this.parseState = 2;
                    }
                }
                case 2: {
                    if (element.equals("words")) {
                        this.alert.setThreshold(new Integer(atts.getValue("threshold")));
                        this.parseState = 3;
                        break;
                    }
                    if (!element.equals("combination")) break;
                    int proximity = -1;
                    try {
                        proximity = new Integer(atts.getValue("proximity"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.combi = new PatternCombination(proximity);
                    this.parseState = 4;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (element.equals("or")) {
                        this.parseState = 5;
                        this.comboElements = new ArrayList();
                        break;
                    }
                    if (!element.equals("not")) break;
                    this.parseState = 6;
                    this.comboElements = new ArrayList();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("error parsing <" + element + ">", (Throwable)e);
            this.alert = null;
            this.parseState = 0;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String element = qName;
        if (this.alert == null) {
            return;
        }
        String s = this.elementText.toString().trim();
        switch (this.parseState) {
            case 1: {
                if (element.equals("alert")) {
                    if (this.combinations.size() > 0) {
                        this.alert.setMustContain(this.combinations);
                    } else {
                        this.combinations = null;
                    }
                    this.allAlerts.put(this.alert.getID(), this.alert);
                    this.allPos.put(new Integer(this.nPos), this.alert.getID());
                    this.parseState = 0;
                    break;
                }
                if (element.equals("description")) {
                    this.alert.setDescription(s);
                    break;
                }
                if (element.equals("contact")) {
                    this.alert.setContact(s);
                    break;
                }
                if (element.equals("category")) {
                    if (s.equals("")) break;
                    this.alert.setAlertClass(s);
                    break;
                }
                if (element.equals("class")) {
                    if (s.equals("")) break;
                    this.alert.setAlertClass(s);
                    break;
                }
                if (element.equals("maxArticles")) {
                    this.alert.setMaxArticles(new Integer(s));
                    break;
                }
                if (!element.equals("expires")) break;
                boolean expired = false;
                try {
                    if (s != null && !s.equals("") && !s.toLowerCase().equals("never")) {
                        Date now = new Date();
                        Date expiryDate = this.expirydf.parse(s);
                        if (now.getTime() > expiryDate.getTime()) {
                            expired = true;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("error parsing " + s + " for " + this.alert.getID(), (Throwable)e);
                }
                if (!expired) break;
                logger.error("alert " + this.alert.getID() + " expired on " + s);
                this.alert = null;
                this.parseState = 0;
                break;
            }
            case 2: {
                if (!element.equals("definition")) break;
                this.parseState = 1;
                break;
            }
            case 3: {
                if (element.equals("words")) {
                    this.parseState = 2;
                    break;
                }
                try {
                    if (element.equals("pattern")) {
                        this.sPattern = s;
                        break;
                    }
                    if (element.equals("weight")) {
                        this.sWeight = s;
                        break;
                    }
                    if (!element.equals("word") || this.sPattern == null || this.sPattern.length() < 1) break;
                    this.addPattern(this.sPattern, new Integer(this.sWeight), this.nPos);
                }
                catch (Exception e) {
                    logger.error("error parsing word/weight" + s + " for " + this.alert.getID(), (Throwable)e);
                }
                break;
            }
            case 4: {
                if (!element.equals("combination")) break;
                if (this.combi.getCombinations().size() > 0) {
                    this.combinations.add(this.combi);
                }
                this.parseState = 2;
                break;
            }
            case 5: {
                if (element.equals("pattern")) {
                    if (s == null || s.length() < 1) break;
                    this.addPattern(s, 0, this.nPos);
                    this.comboElements.add(s);
                    break;
                }
                if (!element.equals("or")) break;
                if (this.comboElements.size() > 0) {
                    this.combi.addCombination(this.comboElements);
                } else {
                    this.comboElements = null;
                }
                this.parseState = 4;
                break;
            }
            case 6: {
                if (element.equals("pattern")) {
                    if (s == null || s.length() < 1) break;
                    this.addPattern(s, 0, this.nPos);
                    this.comboElements.add(s);
                    break;
                }
                if (!element.equals("not")) break;
                if (this.comboElements.size() > 0) {
                    this.combi.addNot(this.comboElements);
                } else {
                    this.comboElements = null;
                }
                this.parseState = 4;
                break;
            }
        }
        this.elementText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.alert != null) {
            this.elementText.append(ch, start, length);
        }
    }
}

