/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.AlertMatchResult;
import it.jrc.alert.PatternMatch;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertResult {
    private int score = 0;
    private double[] accum;
    private int nNumerator;
    private HashMap<String, Integer> matchWords;
    private HashMap<String, ArrayList<Integer>> matchPatterns;
    private HashMap<String, PatternMatch> profile;
    private static double[] multiplier = new double[]{1.0, 1.0, 0.6, 0.4, 0.4, 0.2, 0.2, 0.2};
    private static double log2 = Math.log(2.0);
    private Logger logger = LogManager.getLogger((String)"it.jrc.alert.AlertResult");

    public AlertResult(AlertMatchResult matchResult, int nPos) {
        this.profile = matchResult.getProfile(nPos);
        int nSteps = matchResult.getParts();
        this.nNumerator = matchResult.getNumerator();
        this.accum = new double[nSteps];
        for (int i = 0; i < this.accum.length; ++i) {
            this.accum[i] = 0.0;
        }
        this.matchWords = new HashMap();
        this.matchPatterns = new HashMap();
        for (String pattern : this.profile.keySet()) {
            PatternMatch match = this.profile.get(pattern);
            int weight = match.getWeight();
            ArrayList<Integer> pIndexVector = new ArrayList<Integer>();
            HashMap<String, ArrayList<Integer>> words = match.getWords();
            for (String theWord : words.keySet()) {
                ArrayList<Integer> indices = words.get(theWord);
                pIndexVector.addAll(indices);
                this.matchWords.put(theWord, indices.size());
            }
            this.matchPatterns.put(pattern, pIndexVector);
            for (int i = 0; i < pIndexVector.size() && i < multiplier.length; ++i) {
                int ind = (Integer)pIndexVector.get(i);
                int accumIndex = ind / this.nNumerator;
                if (accumIndex > this.accum.length - 1) {
                    accumIndex = this.accum.length - 1;
                }
                this.accum[accumIndex] = this.accum[accumIndex] + (double)weight * multiplier[i];
            }
        }
        for (int i = 1; i < this.accum.length; ++i) {
            this.accum[i] = this.accum[i] + this.accum[i - 1];
        }
        this.score = (int)this.accum[this.accum.length - 1];
    }

    public double[] getScore() {
        return this.accum;
    }

    public int getSimpleScore() {
        return this.score;
    }

    public int getNumerator() {
        return this.nNumerator;
    }

    public HashMap<String, Integer> getWords() {
        return this.matchWords;
    }

    public HashMap<String, ArrayList<Integer>> getPatterns() {
        return this.matchPatterns;
    }

    public HashMap<String, PatternMatch> getProfile() {
        return this.profile;
    }
}

