/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.matcher.AbstractMatcher;
import it.jrc.lt.core.component.matcher.BasicMatchItem;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureComparator;
import it.jrc.lt.regexpfs.module.CorleoneExternal;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

public class CorleoneMatcher
extends Module {
    private static final CorleoneMatcher _instance = new CorleoneMatcher();
    private AbstractMatcher matcher = AbstractMatcher.createInstance((String)"basicMatcher");
    private static final transient String _type = "patternmatch";
    private static ArrayList<String> _attributes;
    private String[] inherit;

    public static CorleoneMatcher getInstance() {
        return _instance;
    }

    protected final boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        return this.initialize(myProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize(Properties myProperties) {
        Configuration myConfig;
        String typefile = myProperties.getProperty("TypeFile");
        if (typefile == null) {
            Module.loggerMessage((String)("Missing property [TypeFile] in configuration file of the module [" + this.getComponentName() + "]"));
            return false;
        }
        if (!new File(typefile).exists()) {
            Module.loggerMessage((String)("property [TypeFile] in configuration file of the module [" + this.getComponentName() + "] refers to a file [" + typefile + "] that doesn't exist"));
            return false;
        }
        String patternfile = myProperties.getProperty("PatternFile");
        if (patternfile == null) {
            Module.loggerMessage((String)("Missing property [PatternFile] in configuration file of the module [" + this.getComponentName() + "]"));
            return false;
        }
        if (!new File(patternfile).exists()) {
            Module.loggerMessage((String)("property [PatternFile] in configuration file of the module [" + this.getComponentName() + "] refers to a file [" + patternfile + "] that doesn't exist"));
            return false;
        }
        String s = myProperties.getProperty("Inherit");
        if (s != null) {
            this.inherit = s.trim().replaceAll(" +", " ").split(" ");
        }
        if ((myConfig = Configuration.initializeFrom((Properties)myProperties)).isNull()) {
            Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (_attributes == null) {
                LinkedHashMap<String, ArrayList<String>> mta = new LinkedHashMap<String, ArrayList<String>>();
                boolean b = CorleoneExternal.loadTypesFromFile(this.getComponentName(), typefile, mta);
                if (!b) {
                    Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
                    return false;
                }
                _attributes = (ArrayList)mta.get(_type);
                if (_attributes == null) {
                    Module.loggerMessage((String)"type [patternmatch] doesn't exist in [TypeFile]");
                    return false;
                }
                if (!_attributes.contains("SURFACE")) {
                    Module.loggerMessage((String)"type [patternmatch] doesn't have mandatory attribute [SURFACE] in [TypeFile]");
                    return false;
                }
            }
        }
        if (!this.matcher.applySettings(myConfig)) {
            return false;
        }
        for (List ls : this.matcher.getAttributes().values()) {
            if (ls == null) continue;
            for (int j = 0; j < ls.size() / 2; ++j) {
                if (_attributes.indexOf(ls.get(2 * j)) != -1) continue;
                Module.loggerMessage((String)("attribute [" + (String)ls.get(2 * j) + "] is used in pattern file [" + patternfile + "] but not declared in type [" + _type + "] of typefile [" + typefile + "] for the module [" + this.getComponentName() + "]"));
                return false;
            }
        }
        return true;
    }

    public final void initialize(String configurationfile) throws Exception {
        Properties prop = new Properties();
        FileInputStream fis = new FileInputStream(configurationfile);
        prop.load(fis);
        fis.close();
        File f = new File(configurationfile);
        Iterator<Object> it = prop.keySet().iterator();
        Properties lprop = new Properties();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = prop.getProperty(key);
            String newValue = value.contains("$ROOT$") ? value.replace("$ROOT$", f.getParent()) : value;
            lprop.setProperty(key, newValue);
        }
        this.setComponentName(lprop.getProperty("MODULE.NAME"));
        boolean b = this.initialize(lprop);
        if (!b) {
            throw new Exception("cannot initialize(" + configurationfile + ") shared CorleoneMatcher");
        }
    }

    public static void term() {
        _attributes = null;
    }

    protected final ArrayList<String> getTypes() {
        return new ArrayList<String>(){
            {
                this.add(CorleoneMatcher._type);
            }
        };
    }

    protected final ArrayList<String> getAttributeNames(String type) {
        return _attributes;
    }

    protected final Object performTask(char[] inputText, ResultPool resultPool) {
        ArrayList result = this.matcher.mark(new String(inputText));
        if (CorleoneMatcher.getInstance().matcher.hasBeenInitialized()) {
            ArrayList lbmi = CorleoneMatcher.getInstance().matcher.mark(new String(inputText));
            result.addAll(lbmi);
        }
        Collections.sort(result, new Comparator<BasicMatchItem>(){

            @Override
            public int compare(BasicMatchItem o0, BasicMatchItem o1) {
                return o0.getStart() - o1.getStart();
            }
        });
        if (this.inherit != null) {
            for (int i = 0; i < result.size(); ++i) {
                BasicMatchItem bmi = (BasicMatchItem)result.get(i);
                for (String inh : this.inherit) {
                    BasicMatchItem bmin;
                    BasicMatchItem bmip;
                    String v = bmi.getAttributeValue(inh);
                    if (v == null) continue;
                    int j = i;
                    while (j > 0 && (bmip = (BasicMatchItem)result.get(--j)).getStart() >= bmi.getStart()) {
                        if (bmip.getAttributeValue(inh) != null) continue;
                        bmip.addAttribute(inh, v);
                    }
                    j = i;
                    while (j < result.size() - 1 && (bmin = (BasicMatchItem)result.get(++j)).getEnd() <= bmi.getEnd()) {
                        if (bmin.getAttributeValue(inh) != null) continue;
                        bmin.addAttribute(inh, v);
                    }
                }
            }
        }
        return result;
    }

    protected final InputFSArrayList convertResult(Object obj, char[] inputText) {
        if (obj == null) {
            return null;
        }
        ArrayList matches = (ArrayList)obj;
        InputFSArrayList result = new InputFSArrayList(matches.size());
        for (BasicMatchItem bmi : matches) {
            InputFeatureStructure ifs = new InputFeatureStructure();
            ifs.setRuleID((int)InputFeatureStructure.UNBOUND);
            ifs.setType((short)0);
            ifs.setPosition(bmi.getStart(), bmi.getEnd());
            ifs.initializeAttributes((byte)_attributes.size());
            ifs.setAttribute(_attributes.indexOf("SURFACE"), bmi.getText(inputText));
            List ls = bmi.getAttributes();
            for (int j = 0; j < ls.size() / 2; ++j) {
                ifs.setAttribute(_attributes.indexOf(ls.get(2 * j)), (String)ls.get(2 * j + 1));
            }
            result.add(ifs);
        }
        result.sort((Comparator)InputFeatureStructureComparator.getInstance());
        return result;
    }
}

