/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.controller;

import it.jrc.extract.service.VariantException;
import it.jrc.extract.service.VariantGuess;
import it.jrc.lt.regexpfs.module.CorleoneDropper;
import it.jrc.lt.regexpfs.module.CorleoneMatcher;
import it.jrc.lt.regexpfs.module.CorleoneReproducer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VariantGuessPool {
    private static final VariantGuessPool _instance = new VariantGuessPool();
    private Status _status = Status.RUNNING;
    private Object _lock = new Object();
    private int _ac = 0;
    private String _resourcespath = null;
    private Map<String, VariantGuess> _vgpool = new HashMap<String, VariantGuess>();
    private String[] _vglanguages = new String[0];
    private static final Logger LOGGER = LogManager.getLogger(VariantGuessPool.class);

    private VariantGuessPool() {
    }

    public static VariantGuessPool getInstance() {
        return _instance;
    }

    public List<String> getStatus() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("resources path: " + this._resourcespath);
        result.add("variant guess languages: " + Arrays.asList(this._vglanguages).toString() + " (#" + this._vglanguages.length + ")");
        result.add("variant guess default language: en");
        result.add("variant guess: pool of #" + this._vgpool.size());
        ArrayList<String> l = new ArrayList<String>(this._vgpool.keySet());
        Collections.sort(l);
        result.add("variant guess pool languages: " + ((Object)l).toString());
        result.add("pool status: " + (Object)((Object)this._status));
        result.add("pool access count: " + this._ac);
        return result;
    }

    public String[] getVariantGuessLanguages() {
        return this._vglanguages;
    }

    public void init(String resourcespath) throws VariantException {
        this._resourcespath = resourcespath;
        this.initVariantGuess();
    }

    public void term() throws Exception {
        LOGGER.info("receives term()");
        this.doPhaseOut();
        this.endPhaseOut(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhaseOut() throws VariantException {
        LOGGER.info("receives doPhaseOut()");
        try {
            Object object = this._lock;
            synchronized (object) {
                this._status = Status.PAUSED;
                while (this._ac > 0) {
                    this._lock.wait();
                }
            }
        }
        catch (InterruptedException iex) {
            throw new VariantException(iex);
        }
        LOGGER.info("doPhaseOut term #[" + this._vgpool.size() + "] variant guess");
        this._vgpool.clear();
        CorleoneMatcher.term();
        CorleoneReproducer.term();
        CorleoneDropper.term();
        this._vglanguages = new String[0];
    }

    public void endPhaseOut() throws VariantException {
        this.endPhaseOut(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endPhaseOut(boolean running) throws VariantException {
        LOGGER.info("receives endPhaseOut(" + running + ")");
        Status status = this._status = running ? Status.RUNNING : Status.PHASEOUT;
        if (this._status == Status.RUNNING) {
            LOGGER.info("endPhaseOut re-init variant guess");
            this.initVariantGuess();
        }
        Object object = this._lock;
        synchronized (object) {
            this._lock.notifyAll();
        }
        LOGGER.info("endPhaseOut() done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire() {
        LOGGER.debug("receives acquire");
        boolean result = false;
        try {
            Object object = this._lock;
            synchronized (object) {
                while (this._status == Status.PAUSED) {
                    this._lock.wait();
                }
                ++this._ac;
                result = this._status == Status.RUNNING;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOGGER.debug("acquire return [" + result + "]");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LOGGER.debug("receives release");
        Object object = this._lock;
        synchronized (object) {
            --this._ac;
        }
    }

    public VariantGuess getVariantGuessFor(String language) {
        String lang = language;
        if (Arrays.binarySearch(this._vglanguages, language) < 0) {
            lang = "en";
        }
        return this._vgpool.get(lang);
    }

    private void initVariantGuess() throws VariantException {
        LOGGER.info("receives initVariantGuess");
        try {
            CorleoneMatcher.getInstance().initialize(new File(this._resourcespath, "named_entities_grammars/shared/shared_matcher_configuration.cfg").getAbsolutePath());
        }
        catch (Exception ex) {
            throw new VariantException(ex);
        }
        ArrayList<String> llanguage = new ArrayList<String>();
        File[] af = new File(this._resourcespath + "named_entities_grammars/").listFiles(new FileFilter(){

            @Override
            public boolean accept(File fil) {
                return fil.isDirectory() && !fil.getName().equals("shared");
            }
        });
        for (File f : af) {
            llanguage.add(f.getName());
        }
        for (String l : llanguage) {
            LOGGER.info("receives initVariantGuess for [" + l + "]");
            String moduledirectory = new File(this._resourcespath, "named_entities_grammars/" + l).getAbsolutePath();
            VariantGuess vg = new VariantGuess(moduledirectory, false);
            this._vgpool.put(l, vg);
        }
        this._vglanguages = llanguage.toArray(new String[0]);
        Arrays.sort(this._vglanguages);
    }

    private static enum Status {
        RUNNING,
        PAUSED,
        PHASEOUT;

    }
}

