/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.data;

import it.jrc.extract.data.DatabaseException;
import it.jrc.extract.data.MatchStore;
import it.jrc.extract.model.Variant;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;

public final class VariantGzip
implements MatchStore {
    private List<Variant> _lvariant;

    public void init(String gzipfile, boolean plain) throws DatabaseException {
        this._lvariant = new ArrayList<Variant>();
        try {
            BufferedReader br = null;
            br = plain ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(gzipfile), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(gzipfile)), "UTF-8"));
            br.readLine();
            long key = 0L;
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] as = line.split("\t");
                if (!"#".equals(as[0])) {
                    throw new DatabaseException("file format not as expected");
                }
                int lc = Integer.parseInt(as[1]);
                String gid = as[2];
                ArrayList<String> ls = new ArrayList<String>();
                for (int i = 0; i < lc; ++i) {
                    ls.add(br.readLine());
                }
                LinkedHashMap<String, Variant> m = new LinkedHashMap<String, Variant>();
                for (String s : ls) {
                    Variant v;
                    as = s.split("\t");
                    String id = as[0];
                    String type = as[1];
                    String language = as[2];
                    String variant = as[3];
                    if ("u".equals(language)) {
                        if (m.get(variant) != null) {
                            throw new DatabaseException("file format not as expected");
                        }
                        v = new Variant(-1L, Integer.parseInt(gid), type.toLowerCase(), "z", variant, null);
                        m.put(variant, v);
                        if ("0".equals(id)) {
                            v.setInvalid();
                            continue;
                        }
                        v.setValid();
                        continue;
                    }
                    v = (Variant)m.get(variant);
                    if (v == null) {
                        v = new Variant(-1L, Integer.parseInt(gid), type.toLowerCase(), "z", variant, null);
                        m.put(variant, v);
                    }
                    String[] al = new String[v.getLanguagesAsArray().length + 1];
                    System.arraycopy(v.getLanguagesAsArray(), 0, al, 0, v.getLanguagesAsArray().length);
                    al[al.length - 1] = language;
                    if ("0".equals(id)) {
                        v.setInvalidIn(al);
                        continue;
                    }
                    v.setValidIn(al);
                }
                for (Variant v : m.values()) {
                    this._lvariant.add(new Variant(key++, v.getId(), v.getType(), v.getSource(), v.getVariant(), v.getLanguages()));
                }
            }
            br.close();
        }
        catch (IOException ioex) {
            throw new DatabaseException(ioex);
        }
    }

    public void term() throws DatabaseException {
        this._lvariant = null;
    }

    public int numVariants() throws DatabaseException {
        return this._lvariant.size();
    }

    public Variant getVariantByKey(long key) throws DatabaseException {
        int i = (int)key;
        if (i < 0 || i >= this._lvariant.size()) {
            return null;
        }
        Variant result = this._lvariant.get(i);
        if (result == null) {
            return null;
        }
        if (result.getKey() != key) {
            throw new AssertionError();
        }
        return result;
    }

    @Override
    public Variant getCanonicalVariantByKey(long key) throws DatabaseException {
        int i = (int)key;
        if (i < 0 || i >= this._lvariant.size()) {
            return null;
        }
        Variant variant = this._lvariant.get(i);
        if (variant == null) {
            return null;
        }
        if (variant.getKey() != key) {
            throw new AssertionError();
        }
        Variant result = variant;
        while (i > 0) {
            Variant v = this._lvariant.get(--i);
            if (variant.getId() == v.getId()) {
                result = v;
                continue;
            }
            if (0L == v.getId()) continue;
        }
        return new Variant(result.getKey(), result.getId(), result.getType(), result.getSource(), result.getVariant().replace('+', ' '), null);
    }

    public List<Variant> getVariantsByType(String type) throws DatabaseException {
        ArrayList<Variant> result = new ArrayList<Variant>();
        for (Variant v : this._lvariant) {
            if (!type.equals(v.getType())) continue;
            result.add(v);
        }
        return result;
    }
}

