/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.service;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import groovy.lang.GroovyClassLoader;
import it.jrc.extract.model.Type;
import it.jrc.extract.service.VariantException;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExpressionMatch {
    private ExpressionsObject _exprobj;
    private static final Logger LOGGER = LogManager.getLogger(ExpressionMatch.class);

    public ExpressionMatch() {
    }

    public ExpressionMatch(ExpressionNotify notify) {
        this._exprobj = new ExpressionsObject();
        if (notify != null) {
            this._exprobj._notify = notify;
        } else {
            this._exprobj._notify = new ExpressionNotify(){

                @Override
                public void info(String message) {
                    System.out.println(message);
                }

                @Override
                public void error(String message) {
                    System.err.println(message);
                }
            };
        }
    }

    public void init(String expressionfile) throws VariantException {
        this.init(expressionfile, new File(expressionfile).getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String expressionfile, String resourcespath) throws VariantException {
        ExpressionsList exprlist = null;
        XStream xstream = ExpressionMatch.getXStream();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(expressionfile), "UTF-8"));
            exprlist = (ExpressionsList)xstream.fromXML((Reader)br);
        }
        catch (XStreamException xsex) {
            throw new VariantException("init(" + expressionfile + ") cannot parse the xml", xsex);
        }
        catch (IOException ioex) {
            throw new VariantException(ioex);
        }
        exprlist.setName(new File(expressionfile).getName());
        this.init(exprlist, resourcespath);
    }

    public void init(ExpressionsList exprlist, String resourcespath) throws VariantException {
        LOGGER.info("init(" + exprlist._name + "," + resourcespath + ") to merge");
        this._exprobj.merge(exprlist, resourcespath);
        LOGGER.info("expressionmatch loaded with #[" + (exprlist._lexpression != null ? exprlist._lexpression.size() : 0) + "] expressions");
    }

    public void process(RSSItem rssi, String[] types) throws VariantException {
        LOGGER.info("receives process on item [" + rssi.getGuid() + "]");
        String stream = null;
        stream = rssi.getTitle() != null && !"".equals(rssi.getTitle()) ? rssi.getTitle() + ". " + rssi.getText() : rssi.getText();
        if (types != null) {
            Arrays.sort(types);
        }
        for (Expression expr : this._exprobj._lexpression) {
            if (types != null && expr.getType() != null && Arrays.binarySearch(types, expr.getType()) < 0) continue;
            RunAutomaton ra = new RunAutomaton(expr._regex._automaton);
            AutomatonMatcher am = ra.newMatcher((CharSequence)stream);
            while (am.find()) {
                String term = stream.substring(am.start(), am.end());
                String[] groups = null;
                if (expr._regex._p != null) {
                    Matcher m = expr._regex._p.matcher(term);
                    if (!m.matches()) {
                        throw new AssertionError((Object)("regex [" + expr._regex._definition + "] matches in brics and should match in java as well"));
                    }
                    int gc = m.groupCount();
                    groups = new String[gc + 1];
                    for (int i = 0; i < gc; ++i) {
                        groups[i + 1] = m.group(i + 1);
                    }
                }
                LOGGER.debug("item [" + rssi.getGuid() + "] matched [" + expr._regex._definition + "] on [" + term + "]");
                String name = null;
                if (expr._validate != null) {
                    Object[] obj = expr.validate(stream, term, am.start(), groups);
                    if (!((Boolean)obj[0]).booleanValue()) continue;
                    name = (String)obj[1];
                }
                SimpleElement se = new SimpleElement("emm:custom", term);
                for (Output out : expr._loutput) {
                    if (out._value != null) {
                        se.addAttribute(out._key, out._value);
                        continue;
                    }
                    if (out._key != null) {
                        se.addAttribute(out._key, (String)out.produceValue(term, groups, name));
                        continue;
                    }
                    Map mss = (Map)out.produceValue(term, groups, name);
                    for (Map.Entry msse : mss.entrySet()) {
                        se.addAttribute((String)msse.getKey(), (String)msse.getValue());
                    }
                }
                se.addAttribute("pos", String.valueOf(am.start()));
                String type = null;
                boolean hasn = false;
                for (SimpleAttribute sa : se.getAttributes()) {
                    if (!sa.name.matches("[A-Za-z][A-Za-z0-9_]*")) {
                        throw new AssertionError((Object)("SimpleElement [" + se.getValue() + "] attribute name [" + sa.name + "] not valid"));
                    }
                    if ("type".equals(sa.name)) {
                        type = sa.value;
                    }
                    if (!"name".equals(sa.name)) continue;
                    hasn = true;
                }
                if (!hasn) {
                    se.addAttribute("name", se.getValue());
                }
                boolean add = false;
                if (type == null) {
                    if (se.getAttributes().size() > 1) {
                        throw new AssertionError((Object)("SimpleElement [" + se.getValue() + "] has no attribute whose name equals to [type]"));
                    }
                    if (types == null) {
                        add = true;
                    }
                } else if (this._exprobj.getTypes().contains(new Type(type, null))) {
                    if (types == null) {
                        add = true;
                    } else if (types != null && Arrays.binarySearch(types, type) > -1) {
                        add = true;
                    }
                }
                if (!add) continue;
                rssi.addElement(se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(ExpressionsList exprlist, String expressionfile) throws IOException {
        XStream xstream = ExpressionMatch.getXStream();
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(expressionfile), "UTF-8"));
            xstream.toXML((Object)exprlist, (Writer)bw);
        }
    }

    private static XStream getXStream() {
        XStream result = new XStream((HierarchicalStreamDriver)new StaxDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out){
                    private boolean cdata;
                    {
                        this.cdata = false;
                    }

                    public void startNode(String name) {
                        this.cdata = "declaration".equals(name) || "regex".equals(name) || "validate".equals(name) || "output".equals(name);
                        super.startNode(name);
                    }

                    protected void writeText(QuickWriter writer, String text) {
                        if (this.cdata) {
                            writer.write("<![CDATA[");
                            writer.write(text);
                            writer.write("]]>");
                        } else {
                            writer.write(text);
                        }
                    }
                };
            }
        });
        result.processAnnotations(ExpressionsList.class);
        return result;
    }

    public ExpressionsObject getExpressionsObject() {
        return this._exprobj;
    }

    @XStreamAlias(value="output")
    @XStreamConverter(value=ToAttributedValueConverter.class, strings={"_produce"})
    public static final class Output {
        @XStreamAsAttribute
        @XStreamAlias(value="key")
        private String _key;
        @XStreamAsAttribute
        @XStreamAlias(value="value")
        private String _value;
        private Expression _expression;
        private String _produce;
        private Object _gproduce;
        private Method _mproduce;

        public Output() {
        }

        public Output(String key, String value, String produce) {
            this._key = key;
            this._value = value;
            this._produce = produce;
        }

        private void init(ExpressionsObject exprobj) throws VariantException {
            if (this._produce != null && "".equals(this._produce.trim())) {
                this._produce = null;
            }
            if (this._produce != null) {
                String scode = "public class Groovy {public Object global;public Map<String, Object> context;public Object console;public Object groovy(String term, String[] groups, String name) {\n" + this._produce + "}}";
                try {
                    Class clasz = new GroovyClassLoader().parseClass(scode);
                    this._gproduce = clasz.newInstance();
                    Field fglobal = clasz.getField("global");
                    fglobal.set(this._gproduce, exprobj._gglobal);
                    Field fcontext = clasz.getField("context");
                    fcontext.set(this._gproduce, exprobj._context);
                    Field fconsole = clasz.getField("console");
                    fconsole.set(this._gproduce, exprobj._notify);
                    this._mproduce = clasz.getMethod("groovy", String.class, String[].class, String.class);
                }
                catch (Throwable th) {
                    LOGGER.warn("expression [" + this._expression._name + "] output for key [" + this._key + "] cannot init() with script [" + this._produce + "]", th);
                    throw new VariantException("an error occurred while parsing script of expression [" + this._expression._name + "] output for key [" + this._key + "]", th);
                }
            }
            LOGGER.debug("expression output [" + this._key + "] init() with script [" + this._produce + "] done");
        }

        private Object produceValue(String term, String[] groups, String name) throws VariantException {
            Object result = null;
            try {
                Object oresult = this._mproduce.invoke(this._gproduce, term, groups, name);
                if (this._key != null && !(oresult instanceof String)) {
                    throw new AssertionError((Object)("expression output [" + this._key + "] produce [" + term + "] with script [" + this._produce + "] is [" + oresult.getClass().getName() + "] but must be [String]"));
                }
                if (this._key == null && !(oresult instanceof Map)) {
                    throw new AssertionError((Object)("expression output [" + this._key + "] produce [" + term + "] with script [" + this._produce + "] is [" + oresult.getClass().getName() + "] but must be [Map<String, String>]"));
                }
                result = oresult;
                LOGGER.debug("expression [" + this._expression._name + "] output for key [" + this._key + "] produce [" + term + "] with script [" + this._produce + "] return [" + result + "]");
            }
            catch (Throwable th) {
                LOGGER.warn("expression [" + this._expression._name + "] output for key [" + this._key + "] cannot produce [" + term + "] with script [" + this._produce + "]", th);
                throw new VariantException("an error occurred while producing expression [" + this._expression._name + "] output for key [" + this._key + "] on term [" + term + "]", th);
            }
            return result;
        }

        public String getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }

        public String getProduce() {
            return this._produce;
        }
    }

    @XStreamAlias(value="regex")
    @XStreamConverter(value=ToAttributedValueConverter.class, strings={"_definition"})
    public static final class Regex {
        @XStreamAsAttribute
        @XStreamAlias(value="mode")
        private String _mode;
        private String _definition;
        private Expression _expression;
        private Automaton _automaton;
        private Pattern _p;

        public Regex() {
        }

        public Regex(String mode, String definition) {
            this._mode = mode;
            this._definition = definition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(String resourcespath, ExpressionsObject exprobj) throws VariantException {
            if (null == this._mode || "basic".equals(this._mode) || "groups".equals(this._mode)) {
                try {
                    this._automaton = new RegExp(this._definition, 32).toAutomaton();
                }
                catch (IllegalArgumentException iaex) {
                    throw new VariantException("an error occurred while init expression [" + this._expression._name + "] because its regex [" + this._definition + "] syntax is not valid for brics regex", iaex);
                }
                if ("groups".equals(this._mode)) {
                    try {
                        this._p = Pattern.compile(this._definition);
                    }
                    catch (PatternSyntaxException psex) {
                        throw new VariantException("an error occurred while init expression [" + this._expression._name + "] in mode [groups] because its regex [" + this._definition + "] syntax is not valid for java regex", psex);
                    }
                }
            } else {
                if ("file".equals(this._mode) || "script".equals(this._mode)) {
                    ArrayList<String> ls;
                    block24: {
                        ls = new ArrayList<String>();
                        if ("file".equals(this._mode)) {
                            try (BufferedReader br = null;){
                                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(resourcespath, this._definition)), "UTF-8"));
                                String stream = null;
                                while ((stream = br.readLine()) != null) {
                                    if ("".equals(stream) || stream.startsWith("#")) continue;
                                    stream = stream.replaceAll("[\\(\\)\\[\\]\\{\\}\\<\\>\\.\\-\\?\\*\\+\\|]", "\\\\$0");
                                    ls.add(stream);
                                }
                                break block24;
                            }
                            catch (IOException ioex) {
                                LOGGER.warn("expression [" + this._definition + "] cannot init() with file [" + this._definition + "]", (Throwable)ioex);
                                throw new VariantException("an error occurred while init expression [" + this._expression._name + "] in mode [file]", ioex);
                            }
                        }
                        if ("script".equals(this._mode)) {
                            String scode = "public class Groovy {public Object groovy(final String resourcespath, final Object global, final Map<String, Object> context, final it.jrc.extract.service.ExpressionMatch.ExpressionNotify console) {\n" + this._definition + "}}";
                            try {
                                Class clasz = new GroovyClassLoader().parseClass(scode);
                                Object gregex = clasz.newInstance();
                                Method mregex = clasz.getMethod("groovy", String.class, Object.class, Map.class, ExpressionNotify.class);
                                Object oresult = mregex.invoke(gregex, resourcespath, exprobj._gglobal, exprobj._context, exprobj._notify);
                                if (!(oresult instanceof List)) {
                                    throw new AssertionError((Object)("expression [" + this._definition + "] init as script is [" + oresult.getClass().getName() + "] but must be [List]"));
                                }
                                LOGGER.debug("expression [" + this._definition + "] init as script return [" + oresult + "]");
                                List l = (List)oresult;
                                for (String s : l) {
                                    ls.add("(" + s + ")");
                                }
                            }
                            catch (Throwable th) {
                                LOGGER.warn("expression [" + this._definition + "] cannot init() with script [" + this._definition + "]", th);
                                throw new VariantException("an error occurred while init expression [" + this._expression._name + "] in mode [script]", th);
                            }
                        }
                    }
                    String regex = "";
                    for (String s : ls) {
                        regex = regex.concat("|").concat(s);
                    }
                    try {
                        this._automaton = new RegExp(regex.substring(1), 32).toAutomaton();
                    }
                    catch (IllegalArgumentException iaex) {
                        throw new VariantException("an error occurred while init expression [" + this._expression._name + "] in mode [" + this._mode + "] because its regex [" + regex.substring(1) + "] syntax is not valid for brics regex", iaex);
                    }
                }
                LOGGER.warn("expression [" + this._definition + "] cannot init() because mode [" + this._mode + "] is not supported");
                throw new VariantException("an error occurred while init expression [" + this._expression._name + "] because its mode [" + this._mode + "] is not supported");
            }
        }

        public String getMode() {
            return this._mode;
        }

        public String getDefinition() {
            return this._definition;
        }
    }

    @XStreamAlias(value="expression")
    public static final class Expression {
        @XStreamAlias(value="regex")
        private Regex _regex;
        @XStreamAlias(value="name")
        private String _name;
        @XStreamAlias(value="description")
        private String _description;
        @XStreamAlias(value="validate")
        private String _validate;
        private Object _gvalidate;
        private Method _mvalidate;
        @XStreamImplicit
        private List<Output> _loutput;

        public Expression() {
        }

        public Expression(Regex regex, String name, String description, String validate, Output[] aoutput) {
            this._regex = regex;
            this._name = name;
            this._description = description;
            this._validate = validate;
            this._loutput = Arrays.asList(aoutput);
        }

        private String getType() {
            String result = null;
            for (Output out : this._loutput) {
                if (!"type".equals(out._key)) continue;
                result = out._value;
                break;
            }
            return result;
        }

        private void init(String resourcespath, ExpressionsObject exprobj) throws VariantException {
            if (this._validate != null && "".equals(this._validate.trim())) {
                this._validate = null;
            }
            if (this._loutput == null) {
                this._loutput = new ArrayList<Output>();
            }
            this._regex.init(resourcespath, exprobj);
            if (this._validate != null) {
                String scode = "public class Groovy {public Object global;public Map<String, Object> context;public Object console;public Object groovy(final String stream, final String term, final Integer position, final String[] groups, final String[] name) {\n" + this._validate.replaceAll("(\\W)name(\\W)", "$1name[0]$2") + "}}";
                try {
                    Class clasz = new GroovyClassLoader().parseClass(scode);
                    this._gvalidate = clasz.newInstance();
                    Field fglobal = clasz.getField("global");
                    fglobal.set(this._gvalidate, exprobj._gglobal);
                    Field fcontext = clasz.getField("context");
                    fcontext.set(this._gvalidate, exprobj._context);
                    Field fconsole = clasz.getField("console");
                    fconsole.set(this._gvalidate, exprobj._notify);
                    this._mvalidate = clasz.getMethod("groovy", String.class, String.class, Integer.class, String[].class, String[].class);
                }
                catch (Throwable th) {
                    LOGGER.warn("expression [" + this._regex._definition + "] cannot init() with script [" + this._validate + "]", th);
                    throw new VariantException("an error occurred while parsing script of expression [" + this._name + "] validation", th);
                }
            }
            LOGGER.debug("expression [" + this._regex._definition + "] init() with script [" + this._validate + "] done");
            for (Output o : this._loutput) {
                o.init(exprobj);
            }
        }

        private Object[] validate(String stream, String term, int position, String[] groups) throws VariantException {
            Object[] result = new Object[]{false, null};
            try {
                String[] aname = new String[1];
                Object oresult = this._mvalidate.invoke(this._gvalidate, stream, term, position, groups, aname);
                if (!(oresult instanceof Boolean)) {
                    throw new AssertionError((Object)("expression [" + this._regex._definition + "] validate with script [" + this._validate + "] is [" + oresult.getClass().getName() + "] but must be [Boolean]"));
                }
                result = new Object[]{(Boolean)oresult, aname[0]};
                LOGGER.debug("expression [" + this._regex._definition + "] validate [" + term + "] with script [" + this._validate + "] return [" + result[0] + "]");
            }
            catch (Throwable th) {
                LOGGER.warn("expression [" + this._regex._definition + "] cannot validate [" + term + "] with script [" + this._validate + "]", th);
                throw new VariantException("an error occurred while doing expression [" + this._name + "] validation on term [" + term + "]", th);
            }
            return result;
        }

        public Regex getRegex() {
            return this._regex;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return this._description;
        }

        public String getValidate() {
            return this._validate;
        }

        public List<Output> getOutputs() {
            return this._loutput;
        }
    }

    @XStreamAlias(value="expressions")
    public static final class ExpressionsList {
        private String _name;
        @XStreamAlias(value="declaration")
        private String _declaration;
        @XStreamImplicit
        private List<Type> _ltype;
        @XStreamImplicit
        private List<Expression> _lexpression;

        public ExpressionsList() {
        }

        public ExpressionsList(String declaration, Type[] atype, Expression[] aexpression) {
            this._declaration = declaration;
            this._ltype = Arrays.asList(atype);
            this._lexpression = Arrays.asList(aexpression);
        }

        public void setName(String name) {
            this._name = name;
        }
    }

    public static final class ExpressionsObjectHelper {
        public static String stripeInit(String code) {
            String result = code;
            int begin = -1;
            Matcher matcher = Pattern.compile("public\\s+void\\s+init\\s*\\(\\s*\\)\\s*\\{").matcher(code);
            if (matcher.find()) {
                begin = matcher.start();
            }
            int end = -1;
            if (begin != -1) {
                int nextc;
                int last = begin;
                int count = 0;
                do {
                    int nexto = code.indexOf(123, last + 1);
                    nextc = code.indexOf(125, last + 1);
                    if (nexto != -1 && nexto < nextc) {
                        last = nexto;
                        ++count;
                        continue;
                    }
                    last = nextc;
                    --count;
                } while (count != 0);
                end = nextc;
            }
            if (begin != -1 && end != -1) {
                result = result.substring(0, begin) + result.substring(end + 1);
            }
            return result;
        }
    }

    public static final class ExpressionsObject {
        private String _gglobalcode = null;
        private Object _gglobal = null;
        private ExpressionNotify _notify = null;
        private Map<String, Object> _context = new HashMap<String, Object>();
        private List<Type> _ltype = new ArrayList<Type>();
        private List<Expression> _lexpression = new ArrayList<Expression>();

        private ExpressionsObject() {
        }

        private void merge(ExpressionsList exprlist, String resourcespath) throws VariantException {
            if (exprlist._declaration != null && !"".equals(exprlist._declaration.trim())) {
                Class clasz;
                String scode = "public class Groovy {public String resourcespath;public Map<String, Object> context;public Object console;" + exprlist._declaration + "}";
                try {
                    clasz = new GroovyClassLoader().parseClass(scode);
                    Object object = clasz.newInstance();
                    Method method = null;
                    try {
                        method = clasz.getMethod("init", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) {
                        Field fresourcespath = clasz.getField("resourcespath");
                        fresourcespath.set(object, resourcespath);
                        HashMap mso = new HashMap();
                        Field fcontext = clasz.getField("context");
                        fcontext.set(object, mso);
                        Field fconsole = clasz.getField("console");
                        fconsole.set(object, this._notify);
                        method.invoke(object, new Object[0]);
                        for (Map.Entry emso : mso.entrySet()) {
                            if (!this._context.containsKey(emso.getKey())) continue;
                            throw new VariantException("merge(" + exprlist._name + ") init function overwrites already set value in context for key [" + (String)emso.getKey() + "]");
                        }
                        this._context.putAll(mso);
                        LOGGER.debug("merge(" + exprlist._name + ") init function #[" + mso.size() + "] new context values");
                    }
                }
                catch (Throwable th) {
                    LOGGER.warn("expressionlist cannot init(" + resourcespath + ") with script [" + exprlist._declaration + "]", th);
                    throw new VariantException("an error occurred while parsing script init for init() function", th);
                }
                this._gglobalcode = this._gglobalcode == null ? ExpressionsObjectHelper.stripeInit(exprlist._declaration) : this._gglobalcode + "\n" + ExpressionsObjectHelper.stripeInit(exprlist._declaration);
                try {
                    scode = "public class Groovy {public String resourcespath;public Map<String, Object> context;public Object console;" + this._gglobalcode + "}";
                    clasz = new GroovyClassLoader().parseClass(scode);
                    this._gglobal = clasz.newInstance();
                    Field fresourcespath = clasz.getField("resourcespath");
                    fresourcespath.set(this._gglobal, resourcespath);
                    Field fcontext = clasz.getField("context");
                    fcontext.set(this._gglobal, this._context);
                    Field fconsole = clasz.getField("console");
                    fconsole.set(this._gglobal, this._notify);
                }
                catch (Throwable th) {
                    LOGGER.warn("expressionlist cannot init with script [" + scode + "]", th);
                    throw new VariantException("an error occurred while parsing script init for global functions", th);
                }
            }
            if (exprlist._ltype != null) {
                for (Type type : exprlist._ltype) {
                    if (type.getId() == null || "".equals(type.getId())) {
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because a type id is [missing or empty string]");
                    }
                    if (type.getDescription() == null || "".equals(type.getDescription())) {
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because a type description is [missing or empty string]");
                    }
                    for (Type t : this._ltype) {
                        if (!type.getId().equals(t.getId())) continue;
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because type id [" + type.getId() + "] is equal to another type id previously loaded");
                    }
                    this._ltype.add(type);
                }
                LOGGER.debug("merge(" + exprlist._name + ") #[" + exprlist._ltype.size() + "] new types");
            }
            if (exprlist._lexpression != null) {
                for (Expression expr : exprlist._lexpression) {
                    if (expr.getName() == null || "".equals(expr.getName())) {
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because an expression name is [missing or empty string]");
                    }
                    for (Expression e : this._lexpression) {
                        if (!expr.getName().equals(e.getName())) continue;
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because expression name [" + expr.getName() + "] is equal to another expression name previously loaded");
                    }
                    if (expr._regex == null || expr._regex._definition == null || "".equals(expr._regex._definition)) {
                        throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because expression [" + expr._name + "] regex is [missing or empty string]");
                    }
                    expr._regex._expression = expr;
                    expr.init(resourcespath, this);
                    for (Output o : expr._loutput) {
                        if ((o._key == null || "".equals(o._key)) && (o._produce == null || "".equals(o._produce))) {
                            throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because expression [" + expr._name + "] has an output whose key is [missing or empty string]");
                        }
                        if ((o._value == null || "".equals(o._value)) && (o._produce == null || "".equals(o._produce))) {
                            throw new VariantException("an error occurred while loading list [" + exprlist._name + "] because expression [" + expr._name + "] has an output whose value is [missing or empty string]");
                        }
                        o._expression = expr;
                    }
                    this._lexpression.add(expr);
                }
                LOGGER.debug("merge(" + exprlist._name + ") #[" + exprlist._lexpression.size() + "] new expressions");
            }
        }

        public String getGlobalCode() {
            return this._gglobalcode;
        }

        public List<Type> getTypes() {
            return this._ltype;
        }

        public List<Expression> getExpressions() {
            return this._lexpression;
        }
    }

    public static interface ExpressionNotify {
        public void info(String var1);

        public void error(String var1);
    }
}

