/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.service;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GeoMatch {
    private ProcessRSS _prss = null;
    private static final Logger LOGGER = LogManager.getLogger(GeoMatch.class);

    public GeoMatch(String geomatcherpath) {
        LOGGER.info("GeoMatch(" + geomatcherpath + ")");
        this._prss = new GeocodeMatcher().init(geomatcherpath, null);
    }

    public void process(RSSItem rssitem, boolean withtitle) {
        int begin;
        int i;
        String newListPos;
        String[] listOfPos;
        RSS rss = new RSS();
        rssitem.setDescription(rssitem.getText());
        rss.addItem(rssitem);
        this._prss.runOnRSSOSIntWay(rssitem, true, ProcessRSS.CLASS3, true, true);
        int addExtraOffset = 0;
        if (rssitem.getElements("emm:georss") != null) {
            for (SimpleElement element : rssitem.getElements("emm:georss")) {
                listOfPos = element.getAttributeValue("pos").split(",");
                newListPos = String.valueOf(Integer.parseInt(listOfPos[0]) + addExtraOffset);
                for (i = 1; i < listOfPos.length; ++i) {
                    if (listOfPos[i].equals("")) continue;
                    begin = Integer.parseInt(listOfPos[i]) + addExtraOffset;
                    newListPos = newListPos + "," + String.valueOf(begin);
                }
                element.setAttribute("pos", newListPos);
                LOGGER.debug(element.toString());
            }
        }
        if (rssitem.getElements("emm:fullgeo") != null) {
            for (SimpleElement element : rssitem.getElements("emm:fullgeo")) {
                if (element.getAttributeValue("adjective").equals("true")) {
                    rssitem.removeElement(element);
                    continue;
                }
                listOfPos = element.getAttributeValue("pos").split(",");
                newListPos = String.valueOf(Integer.parseInt(listOfPos[0]) + addExtraOffset);
                for (i = 1; i < listOfPos.length; ++i) {
                    if (listOfPos[i].equals("")) continue;
                    begin = Integer.parseInt(listOfPos[i]) + addExtraOffset;
                    newListPos = newListPos + "," + String.valueOf(begin);
                }
                element.setAttribute("pos", newListPos);
                LOGGER.warn(element.toString());
            }
        }
    }
}

