/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.service;

import it.jrc.extract.data.DatabaseException;
import it.jrc.extract.data.MatchStore;
import it.jrc.extract.model.Variant;
import it.jrc.extract.service.VariantException;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VariantMatch {
    private MatchStore _store;
    private List<MatchWords> _lmw;
    private static final Logger LOGGER = LogManager.getLogger(VariantMatch.class);

    public VariantMatch(MatchStore store) {
        this._store = store;
        this._lmw = new ArrayList<MatchWords>();
    }

    public void init(String type, byte transform) throws VariantException {
        if (transform != 0 && transform != 1 && transform != 3 && transform != 2) {
            throw new IllegalArgumentException("transform must be one of Character.UNASSIGNED Character.UPPERCASE_LETTER Character.TITLECASE_LETTER Character.LOWERCASE_LETTER");
        }
        if (transform == 3) {
            throw new UnsupportedOperationException("not yet supported not yet implemented");
        }
        Hashtable<String, StringBuilder> ht = new Hashtable<String, StringBuilder>();
        Collection<Variant> cv = null;
        try {
            cv = this._store.getVariantsByType(type);
        }
        catch (DatabaseException dbex) {
            throw new VariantException(dbex);
        }
        for (Variant v : cv) {
            if (v.getKey() < 0L) {
                throw new VariantException("can support variant with key > -1 (current key [" + v.getKey() + "])");
            }
            long l = v.getKey();
            if (l > 0xFFFFFFFFL) {
                throw new VariantException("can support variant with key up to [4294967295] (current key [" + v.getKey() + "])");
            }
            String pattern = v.getVariant();
            if (1 == transform) {
                pattern = pattern.toUpperCase();
            } else if (2 == transform) {
                pattern = pattern.toLowerCase();
            }
            if ("".equals(pattern = pattern.replaceAll(" & ", "\\+").replaceAll("[\\s!\"#\\$'\\(\\)\\*\\+,\\./:;<=>\\?@\\\\^`{\\|}~\u2019]+", "\\+").replaceFirst("^\\++", "").replaceFirst("\\++$", ""))) continue;
            StringBuilder sb = (StringBuilder)ht.get(pattern);
            if (sb == null) {
                sb = new StringBuilder(3);
                sb.append('\u0001');
                ht.put(pattern, sb);
            } else {
                char i = sb.charAt(0);
                if (i >= '\uffff') {
                    throw new VariantException("can support variant with up to [65535] facets (limit reached)");
                }
                sb.setCharAt(0, (char)(i + '\u0001'));
            }
            char c = (char)l;
            char d = (char)(l >>>= 16);
            sb.insert(1, c);
            sb.insert(1, d);
        }
        MatchWords mw = MatchWords.getObject();
        mw.init(ht);
        this._lmw.add(mw);
        LOGGER.info("matchwords [" + type + "] loaded with #[" + ht.size() + "] patterns");
        ht = null;
    }

    public void process(RSSItem rssi) throws VariantException {
        LOGGER.info("receives process on item [" + rssi.getGuid() + "]");
        String stream = null;
        stream = rssi.getTitle() != null && !"".equals(rssi.getTitle()) ? rssi.getTitle() + ". " + rssi.getText() : rssi.getText();
        ArrayList<MatchItem> lmi = new ArrayList<MatchItem>();
        for (MatchWords mw : this._lmw) {
            List<MatchItem> l = this.process(stream, mw);
            lmi.addAll(l);
        }
        Collections.sort(lmi, new Comparator<MatchItem>(){

            @Override
            public int compare(MatchItem o0, MatchItem o1) {
                int result = new Long(o0.getKey()).compareTo(new Long(o1.getKey()));
                if (result == 0) {
                    result = o0.getStart() - o1.getStart();
                }
                return result;
            }
        });
        for (int i = 0; i < lmi.size(); ++i) {
            MatchItem mi = (MatchItem)lmi.get(i);
            Variant v = null;
            try {
                v = this._store.getCanonicalVariantByKey(mi.getKey());
            }
            catch (DatabaseException dbex) {
                throw new VariantException(dbex);
            }
            String id = null;
            if (v.isInvalid()) continue;
            if (v.isValid() || v.isValidIn(rssi.getLanguage())) {
                id = String.valueOf(v.getId());
            } else {
                if (v.isInvalidIn(rssi.getLanguage())) continue;
                if (v.getLanguages().startsWith("-")) {
                    id = String.valueOf(v.getId());
                }
            }
            if (id == null) continue;
            SimpleElement se = new SimpleElement("emm:entity", stream.substring(mi.getStart(), mi.getEnd()));
            se.addAttribute("ke", String.valueOf(mi.getKey()));
            se.addAttribute("id", id);
            se.addAttribute("type", v.getType());
            se.addAttribute("source", v.getSource());
            StringBuilder sbpos = new StringBuilder(32);
            sbpos.append(mi.getStart());
            while (i + 1 < lmi.size()) {
                MatchItem mib;
                if ((mib = (MatchItem)lmi.get(++i)).getKey() != mi.getKey()) {
                    --i;
                    break;
                }
                sbpos.append(",").append(mib.getStart());
            }
            se.addAttribute("pos", sbpos.toString());
            se.addAttribute("name", v.getVariant());
            rssi.addElement(se);
        }
    }

    private List<MatchItem> process(String stream, MatchWords mw) throws VariantException {
        final ArrayList<MatchItem> result = new ArrayList<MatchItem>();
        MatchResult mr = new MatchResult(){

            public void setWordCount(int wcount) {
            }

            public void addMatch(char[] cl, int clidx, String mtext, int wnumber, int pos) {
                char patternlength = cl[clidx + 2];
                String pattern = String.valueOf(cl, clidx - patternlength + 1, patternlength);
                ArrayList<Long> lfacet = new ArrayList<Long>();
                int i = clidx + 3;
                int facetlength = cl[i++];
                for (int j = 0; j < facetlength; ++j) {
                    char d = cl[i++];
                    char c = cl[i++];
                    long ld = (long)d << 16;
                    long lc = c;
                    long facet = ld | lc;
                    lfacet.add(facet);
                }
                LOGGER.debug("found text [" + mtext + "] (at tword [" + wnumber + "] tpos [" + pos + "]) matching pattern [" + pattern + "] (length [" + patternlength + "]) with facets [" + lfacet + "]");
                Iterator iterator = lfacet.iterator();
                while (iterator.hasNext()) {
                    long facet = (Long)iterator.next();
                    result.add(new MatchItem(pos, pos + mtext.length(), facet));
                }
            }
        };
        mw.match(stream, mr);
        return result;
    }

    private static final class MatchItem {
        private int _start;
        private int _end;
        private long _key;

        private MatchItem(int start, int end, long key) {
            this._start = start;
            this._end = end;
            this._key = key;
        }

        private int getStart() {
            return this._start;
        }

        private int getEnd() {
            return this._end;
        }

        private long getKey() {
            return this._key;
        }
    }
}

