/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.service;

import it.jrc.extract.data.DatabaseException;
import it.jrc.extract.data.NormalizeStore;
import it.jrc.extract.model.Type;
import it.jrc.extract.model.Variant;
import it.jrc.extract.service.VariantException;
import it.jrc.extract.tools.SignatureHelper;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wipo.stringSim.Distance;

public final class VariantNormalize {
    private static final VariantNormalize _instance = new VariantNormalize();
    private NormalizeStore _store;
    private SelectorHelper _selhelper;
    private String[] _ntd;
    private DistanceHelper _dhelper;
    private List<String> _current = new ArrayList<String>();
    private AtomicInteger[][] _counts;
    private static final Logger LOGGER = LogManager.getLogger(VariantNormalize.class);
    private static final Logger ANALYSIS = LogManager.getLogger((String)"it.jrc.extract.service.normalize.analysis");

    private VariantNormalize() {
    }

    public static VariantNormalize getInstance() {
        return _instance;
    }

    public void setSite() {
        this._current = null;
    }

    public void init(String ponderationpath, NormalizeStore store) throws VariantException {
        int i;
        if (this._ntd != null) {
            LOGGER.info("cannot init(), call term() first");
            return;
        }
        this._store = store;
        this._selhelper = new SelectorHelper(this._store.getWildcardSingleOperator(), this._store.getWildcardMultipleOperator(), this._store.getFuzzyOperator());
        this._counts = new AtomicInteger[3 + SelectorRound.values().length][3];
        for (i = 0; i < 3; ++i) {
            this._counts[i][0] = new AtomicInteger();
        }
        for (i = 0; i < SelectorRound.values().length; ++i) {
            this._counts[3 + i][0] = new AtomicInteger();
            this._counts[3 + i][1] = new AtomicInteger();
            this._counts[3 + i][2] = new AtomicInteger();
        }
        try {
            ArrayList<String> ls = new ArrayList<String>();
            for (Type t : this._store.getTypes()) {
                if (!t.wantsDistance()) continue;
                ls.add(t.getId());
            }
            this._ntd = ls.toArray(new String[0]);
        }
        catch (DatabaseException dbex) {
            throw new VariantException(dbex);
        }
        Arrays.sort(this._ntd);
        LOGGER.info("types to be normalized through distance calculation are " + Arrays.asList(this._ntd));
        this._dhelper = new DistanceHelper(ponderationpath);
    }

    public void term() {
        if (this._ntd == null) {
            LOGGER.info("cannot term(), call init() first");
            return;
        }
        this._dhelper = null;
        this._selhelper = null;
        this._store = null;
        this._ntd = null;
        this._counts = null;
    }

    public void process(RSSItem rssi) throws VariantException {
        ArrayList lse = new ArrayList();
        ArrayList ls = rssi.getElements("emm:guess");
        if (ls != null) {
            lse.addAll(ls);
        }
        if ((ls = rssi.getElements("emm:custom")) != null) {
            lse.addAll(ls);
        }
        if (!lse.isEmpty()) {
            this._counts[0][0].incrementAndGet();
        }
        for (SimpleElement se : lse) {
            if (se.getAttribute("id") != null) continue;
            char source = '\u0000';
            if ("emm:guess".equals(se.getName())) {
                source = 'g';
            } else if ("emm:custom".equals(se.getName())) {
                source = 'e';
            }
            String name = se.getAttributeValue("name");
            String bname = se.getAttributeValue("bname");
            String iname = se.getAttributeValue("iname");
            String[] aname = null;
            char[] asource = null;
            if (bname != null && iname != null) {
                aname = new String[]{bname, name, iname};
                asource = new char[]{source, source, '\u0000'};
            } else if (bname != null) {
                aname = new String[]{bname, name};
                asource = new char[]{source, source};
            } else if (iname != null) {
                aname = new String[]{name, iname};
                asource = new char[]{source, '\u0000'};
            } else {
                aname = new String[]{name};
                asource = new char[]{source};
            }
            String type = se.getAttributeValue("type");
            NormalizeResult result = this.normalize(aname, asource, type);
            se.addAttribute("ke", String.valueOf(result.getVariant().getKey()));
            String id = null;
            if (result.getVariant().isInvalid()) {
                id = "0";
            } else if (result.getVariant().isValid() || result.getVariant().isValidIn(rssi.getLanguage())) {
                id = String.valueOf(result.getVariant().getId());
            } else if (result.getVariant().isInvalidIn(rssi.getLanguage())) {
                id = "0";
            } else if (result.getVariant().getLanguages().startsWith("-")) {
                id = String.valueOf(result.getVariant().getId());
            }
            se.addAttribute("id", id);
        }
    }

    public NormalizeResult normalize(String variant) throws VariantException {
        return this.normalize(new String[]{variant}, new char[]{'u'}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NormalizeResult normalize(String[] avariant, char[] asource, String type) throws VariantException {
        if (this._ntd == null) {
            LOGGER.info("cannot normalize(), call init() first");
            return null;
        }
        NormalizeResult result = new NormalizeResult();
        try {
            if (this._current != null) {
                List<String> list = this._current;
                synchronized (list) {
                    int j;
                    boolean allow = false;
                    while (!allow) {
                        allow = true;
                        block21: for (j = 0; j < avariant.length; ++j) {
                            for (String current : this._current) {
                                if (avariant[j].equals(current)) {
                                    allow = false;
                                    continue block21;
                                }
                                if (!this._dhelper.close(avariant[j], current)) continue;
                                allow = false;
                                continue block21;
                            }
                        }
                        if (allow) continue;
                        try {
                            this._current.wait();
                        }
                        catch (InterruptedException iex) {
                            throw new VariantException(iex);
                        }
                    }
                    for (j = 0; j < avariant.length; ++j) {
                        this._current.add(avariant[j]);
                    }
                }
            }
            for (int i = 0; i < avariant.length; ++i) {
                try {
                    Variant v = this._store.hasVariant(avariant[i], type);
                    if (v == null) continue;
                    result.setMatch(v);
                    this._counts[1][0].incrementAndGet();
                    break;
                }
                catch (DatabaseException dbex) {
                    throw new VariantException(dbex);
                }
            }
            if (result.isNone() && (type == null || Arrays.binarySearch(this._ntd, type) > -1)) {
                HashSet<Variant> svarat = new HashSet<Variant>();
                for (int i = 0; i < avariant.length; ++i) {
                    try {
                        this.normalize(avariant[i], svarat, result);
                        if (!result.isEquivalent() && !result.isApproximate()) continue;
                        break;
                    }
                    catch (DatabaseException dbex) {
                        throw new VariantException(dbex);
                    }
                }
            }
            if (result.isNone()) {
                result.setOriginal(-1L, -1);
                this._counts[2][0].incrementAndGet();
            }
            if (asource != null) {
                for (int i = 0; i < avariant.length; ++i) {
                    if (asource[i] == '\u0000') continue;
                    long id = result.getVariant().getId();
                    try {
                        long[] r = this._store.store(id, type == null ? "u" : type, Character.toString(asource[i]), avariant[i]);
                        if (!result.isOriginal() || result.getVariant().getId() != -1L) continue;
                        result.setOriginal(r[0], (int)r[1]);
                        continue;
                    }
                    catch (DatabaseException dbex) {
                        throw new VariantException(dbex);
                    }
                }
                LOGGER.info("normalize({}): return {}{} {} in {}ms", new Object[]{Arrays.asList(avariant), Character.valueOf(result.getSymbol()), result.getVariant().getId(), result.getVariant().getVariant(), result.getDuration()});
            }
        }
        finally {
            if (this._current != null) {
                List<String> list = this._current;
                synchronized (list) {
                    for (int j = 0; j < avariant.length; ++j) {
                        this._current.remove(avariant[j]);
                    }
                    this._current.notifyAll();
                }
            }
        }
        return result;
    }

    private void normalize(String variant, Set<Variant> svarat, NormalizeResult result) throws DatabaseException {
        List<String> lsignatures = this._store.getSignatures(variant);
        if (lsignatures.isEmpty()) {
            return;
        }
        for (Selector selector : this._selhelper.getSelectors(lsignatures)) {
            Object[] distance;
            this._counts[3 + selector.getRound().ordinal()][1].incrementAndGet();
            List<Variant> lv = this._store.getVariantsByVariantSignature(selector.getSignature());
            this._counts[3 + selector.getRound().ordinal()][2].addAndGet(lv.size());
            HashSet<Variant> svar = new HashSet<Variant>(lv);
            svar.removeAll(svarat);
            if (svar.isEmpty()) continue;
            List ldistance = this._dhelper.distances(variant, svar);
            Iterator iterator = ldistance.iterator();
            while (iterator.hasNext() && !(((Float)(distance = (Object[])iterator.next())[3]).floatValue() < 0.85f)) {
                ANALYSIS.info("{}\t{}\t{}\t{}\t{}", new Object[]{variant, ((Variant)distance[2]).getVariant(), (Float)distance[3], selector.getRound().getName(), distance[0]});
            }
            Object[] closest = (Object[])ldistance.get(0);
            if (((Float)closest[1]).floatValue() <= ((Float)closest[3]).floatValue()) {
                result.setSimilar((Variant)closest[2], ((Float)closest[3]).floatValue());
                this._counts[3 + selector.getRound().ordinal()][0].incrementAndGet();
                break;
            }
            svarat.addAll(svar);
        }
    }

    public List<String> getStatistics() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("variant normalize");
        result.add("- rssitem: #<b>" + this._counts[0][0].get() + "</b>");
        result.add("variant selectors");
        for (SelectorRound sr : SelectorRound.values()) {
            result.add("- <i>" + sr.getName() + "</i>: " + sr.getDescription());
        }
        result.add("hits");
        int total = 0;
        for (int i = 1; i < this._counts.length; ++i) {
            total += this._counts[i][0].get();
        }
        result.add("- match: decisive #<b>" + this._counts[1][0].get() + "</b> times, <b>" + (total == 0 ? "undefined" : String.format("%1$.6f", (double)this._counts[1][0].get() / (double)total)) + "</b>");
        for (SelectorRound sr : SelectorRound.values()) {
            result.add("- " + sr.getName() + ": decisive #<b>" + this._counts[3 + sr.ordinal()][0].get() + "</b> times, <b>" + (total == 0 ? "undefined" : String.format("%1$.6f", (double)this._counts[3 + sr.ordinal()][0].get() / (double)total)) + "</b>; used #<b>" + this._counts[3 + sr.ordinal()][1].get() + "</b> times; selected #<b>" + this._counts[3 + sr.ordinal()][2].get() + "</b> items");
        }
        result.add("- original: decisive #<b>" + this._counts[2][0].get() + "</b> times, <b>" + (total == 0 ? "undefined" : String.format("%1$.6f", (double)this._counts[2][0].get() / (double)total)) + "</b>");
        result.add("- total: <b>" + total + "</b>");
        return result;
    }

    public List<String> explain(String variant) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Explain variant normalize");
        result.add("- variant: <b>" + variant + "</b>");
        result.add("- distance calculators");
        result.add("<table>");
        for (Map.Entry e : this._dhelper._mlcalculator.entrySet()) {
            String sc = "";
            for (Calculator c : (List)e.getValue()) {
                sc = sc + c._name + " (" + c._threshold + ")<br>";
            }
            result.add("<tr><td style=\"vertical-align:top;\"><i>" + (String)e.getKey() + "</i></td><td>" + sc + "<td></tr>");
        }
        result.add("</table>");
        boolean found = false;
        Variant vm = this._store.hasVariant(variant, null);
        String s = "- match: ";
        if (vm != null) {
            result.add(s + "<b>* " + vm.getVariant() + " [" + vm.getId() + "]</b>");
            found = true;
        } else {
            result.add(s + "<i>none</i>");
        }
        List<String> ls = this._store.getSignatures(variant);
        result.add("- signature: <b>" + ls + "</b>");
        result.add("- variant selectors");
        HashSet<Variant> svarat = new HashSet<Variant>();
        for (Selector selector : this._selhelper.getSelectors(ls)) {
            List<Variant> lv = this._store.getVariantsByVariantSignature(selector.getSignature());
            HashSet<Variant> svar = new HashSet<Variant>(lv);
            svar.removeAll(svarat);
            result.add("- <i>" + selector.getRound().getName() + "</i>: [<b>" + selector.getSignature() + "</b>] selects <b>" + svar.size() + "</b> more variants (was <b>" + lv.size() + "</b>)");
            result.add("<table>");
            List ldistance = this._dhelper.distances(variant, svar);
            boolean closest = !ldistance.isEmpty() && ((Float)((Object[])ldistance.get(0))[1]).floatValue() <= ((Float)((Object[])ldistance.get(0))[3]).floatValue();
            for (Object[] distance : ldistance) {
                Variant v = (Variant)distance[2];
                boolean star = !found && closest && (Float)((Object[])ldistance.get(0))[3] == (Float)distance[3];
                result.add("<tr><td>" + (star ? "<b>*</b> " : "") + v.getVariant() + "</td><td>[" + v.getId() + "]</td><td>" + distance[3] + "</td><td>" + distance[0] + "</td></tr>");
            }
            result.add("</table>");
            if (closest) {
                found = true;
            }
            svarat.addAll(svar);
        }
        if (!found) {
            result.add("- original: <b>*</b>");
        } else {
            result.add("- original:");
        }
        return result;
    }

    public final class NormalizeResult {
        private byte _type = (byte)-1;
        private Variant _v = null;
        private long _duration = System.currentTimeMillis();

        private NormalizeResult() {
        }

        public Variant getVariant() {
            return this._v;
        }

        public long getDuration() {
            return this._duration;
        }

        private void setMatch(Variant v) {
            this._v = v;
            this._type = 1;
            this._duration = System.currentTimeMillis() - this._duration;
        }

        private void setSimilar(Variant v, float score) {
            this._v = v;
            this._type = (byte)(score == 1.0f ? 2 : 3);
            this._duration = System.currentTimeMillis() - this._duration;
        }

        private void setOriginal(long key, int id) {
            this._v = new Variant(key, id, null, null, null, null);
            this._type = (byte)4;
            if (key == -1L && id == -1) {
                this._duration = System.currentTimeMillis() - this._duration;
            }
        }

        private boolean isNone() {
            return this._type == -1;
        }

        private boolean isMatch() {
            return this._type == 1;
        }

        private boolean isEquivalent() {
            return this._type == 2;
        }

        private boolean isApproximate() {
            return this._type == 3;
        }

        private boolean isOriginal() {
            return this._type == 4;
        }

        private char getSymbol() {
            switch (this._type) {
                case 1: {
                    return '=';
                }
                case 2: {
                    return '~';
                }
                case 3: {
                    return '%';
                }
                case 4: {
                    return '+';
                }
            }
            return '?';
        }
    }

    public static final class DistanceHelper {
        private Map<String, List<Calculator>> _mlcalculator = new HashMap<String, List<Calculator>>();

        public DistanceHelper(String ponderationpath) throws VariantException {
            File fp = new File(ponderationpath, "ponderation");
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(fp));
            }
            catch (IOException ioex) {
                throw new VariantException(ioex);
            }
            HashMap<String, Distance> msd = new HashMap<String, Distance>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (!key.endsWith(".filename")) continue;
                String nkey = key.replace(".filename", "");
                String filename = val;
                float threshold = Float.parseFloat(p.getProperty(nkey + ".threshold"));
                String sources = p.getProperty(nkey + ".sources");
                String targets = p.getProperty(nkey + ".targets");
                Distance d = (Distance)msd.get(filename);
                if (d == null) {
                    d = new Distance(new File(ponderationpath, filename).getAbsolutePath());
                    msd.put(filename, d);
                }
                for (String source : sources.split(",")) {
                    for (String target : targets.split(",")) {
                        String keya = source + "\t" + target;
                        List<Calculator> lc = this._mlcalculator.get(keya);
                        if (lc == null) {
                            lc = new ArrayList<Calculator>();
                            this._mlcalculator.put(keya, lc);
                        }
                        lc.add(new Calculator(new File(ponderationpath, filename), d, false, threshold));
                        String keyb = target + "\t" + source;
                        lc = this._mlcalculator.get(keyb);
                        if (lc == null) {
                            lc = new ArrayList<Calculator>();
                            this._mlcalculator.put(keyb, lc);
                        }
                        lc.add(new Calculator(new File(ponderationpath, filename), d, true, threshold));
                    }
                }
            }
            for (List list : this._mlcalculator.values()) {
                if (list.size() <= 1) continue;
                HashSet<String> ss = new HashSet<String>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Calculator c = (Calculator)it.next();
                    String k = c._name + "\t" + c._invert + "\t" + c._threshold;
                    if (ss.contains(k)) {
                        it.remove();
                    }
                    ss.add(k);
                }
            }
            LOGGER.info("ponderation file [{}] #[{}] entries made #[{}] distance calculators", new Object[]{fp.getAbsolutePath(), p.entrySet().size(), this._mlcalculator.size()});
        }

        private List<Object[]> distances(String variant, Collection<Variant> cvariant) {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (Variant var : cvariant) {
                List<Object[]> lobj = this.distance(variant, var.getVariant());
                for (Object[] obj : lobj) {
                    obj[2] = var;
                }
                result.addAll(lobj);
            }
            Collections.sort(result, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o0, Object[] o1) {
                    Float f0 = (Float)o0[3];
                    Float f1 = (Float)o1[3];
                    boolean b0 = ((Float)o0[1]).floatValue() <= f0.floatValue();
                    boolean b1 = ((Float)o1[1]).floatValue() <= f1.floatValue();
                    int result = new Boolean(b1).compareTo(new Boolean(b0));
                    if (result == 0) {
                        result = Float.compare(f1.floatValue(), f0.floatValue());
                    }
                    return result;
                }
            });
            return result;
        }

        private List<Object[]> distance(String variant, String var) {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            float f = -1.0f;
            String ubleft = Character.UnicodeBlock.of(variant.charAt(0)).toString();
            String ubright = Character.UnicodeBlock.of(var.charAt(0)).toString();
            List<Calculator> lcal = this._mlcalculator.get(ubleft.concat("\t").concat(ubright));
            if (lcal == null) {
                lcal = this._mlcalculator.get("default\tdefault");
            }
            for (Calculator cal : lcal) {
                f = cal.calculate(variant, var);
                Object[] obj = new Object[]{cal._name, Float.valueOf(cal._threshold), var, Float.valueOf(f)};
                result.add(obj);
            }
            return result;
        }

        private boolean close(String variant, String var) {
            List<Object[]> result = this.distance(variant, var);
            for (Object[] o : result) {
                if (!(((Float)o[1]).floatValue() <= ((Float)o[3]).floatValue())) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Calculator {
        private String _name;
        private Distance _distance;
        private boolean _invert;
        private float _threshold;

        private Calculator(File matrix, Distance distance, boolean invert, float threshold) {
            this._name = matrix.getName() + "_" + invert;
            this._distance = distance;
            this._invert = invert;
            this._threshold = threshold;
        }

        private float calculate(String variant, String var) {
            if (!this._invert) {
                return this._distance.LDsimpbp(variant, var);
            }
            return this._distance.LDsimpbp(var, variant);
        }
    }

    private static final class Selector {
        private SelectorRound _round;
        private String _signature;

        private Selector(SelectorRound round, String signature) {
            this._round = round;
            this._signature = signature;
        }

        public SelectorRound getRound() {
            return this._round;
        }

        public String getSignature() {
            return this._signature;
        }
    }

    private static final class SelectorHelper {
        private String _characterwildcard;
        private String _stringwildcard;
        private String _fuzzywildcard;
        private boolean _bskipcwpall;

        private SelectorHelper(String cw, String sw, String fw) {
            this._characterwildcard = cw;
            this._stringwildcard = sw;
            this._fuzzywildcard = fw;
            this._bskipcwpall = Boolean.valueOf(System.getProperty("selector.skipcwpall"));
        }

        private Collection<Selector> getSelectors(List<String> lsignatures) {
            ArrayList<String> ls;
            int i;
            ArrayList<Selector> result = new ArrayList<Selector>();
            String signature = SignatureHelper.toPlain(lsignatures);
            result.add(new Selector(SelectorRound.ALL, signature));
            for (i = 0; i < lsignatures.size(); ++i) {
                ls = new ArrayList<String>(lsignatures);
                ls.set(i, (String)ls.get(i) + this._characterwildcard);
                result.add(new Selector(SelectorRound.CWA, SignatureHelper.toPlain(ls)));
                ls.set(i, ((String)ls.get(i)).substring(0, ((String)ls.get(i)).length() - 2) + this._characterwildcard);
                result.add(new Selector(SelectorRound.CWR, SignatureHelper.toPlain(ls)));
                if (((String)ls.get(i)).length() <= 1) continue;
                ls.set(i, ((String)ls.get(i)).substring(0, ((String)ls.get(i)).length() - 1));
                result.add(new Selector(SelectorRound.RLC, SignatureHelper.toPlain(ls)));
            }
            int n = i = this._bskipcwpall ? 1 : 0;
            while (i < lsignatures.size()) {
                ls = new ArrayList<String>(lsignatures);
                ls.set(i, this._characterwildcard + (String)ls.get(i));
                result.add(new Selector(SelectorRound.CWP, SignatureHelper.toPlain(ls)));
                ls.set(i, this._characterwildcard + ((String)ls.get(i)).substring(2));
                result.add(new Selector(SelectorRound.CWS, SignatureHelper.toPlain(ls)));
                if (((String)ls.get(i)).length() > 1) {
                    ls.set(i, ((String)ls.get(i)).substring(1));
                    result.add(new Selector(SelectorRound.RFC, SignatureHelper.toPlain(ls)));
                }
                ++i;
            }
            if (lsignatures.size() > 2) {
                for (i = 0; i < lsignatures.size(); ++i) {
                    ls = new ArrayList<String>(lsignatures);
                    ls.remove(i);
                    result.add(new Selector(SelectorRound.SOM, SignatureHelper.toPlain(ls)));
                }
            }
            if (this._fuzzywildcard != null) {
                result.add(new Selector(SelectorRound.FUZ, signature + this._fuzzywildcard));
            }
            if (lsignatures.size() > 2) {
                ArrayList<String> ls2 = new ArrayList<String>();
                ls2.add(lsignatures.get(0));
                ls2.add(lsignatures.get(1));
                ls2.add(this._stringwildcard);
                result.add(new Selector(SelectorRound.SWE, SignatureHelper.toPlain(ls2)));
            }
            if (lsignatures.size() > 1) {
                ArrayList<String> ls3 = new ArrayList<String>();
                ls3.add(lsignatures.get(0));
                ls3.add(this._stringwildcard);
                ls3.add(lsignatures.get(lsignatures.size() - 1));
                result.add(new Selector(SelectorRound.SWM, SignatureHelper.toPlain(ls3)));
            }
            return result;
        }
    }

    private static enum SelectorRound {
        ALL("all signatures", "match all signatures; example: krl thdr frhr z gtnbrg"),
        CWA("char wildcard appended after last char", "1 selector per each signature; example: krl_ thdr frhr z gtnbrg"),
        CWR("char wildcard replacing last char", "1 selector per each signature; example: kr_ thdr frhr z gtnbrg"),
        RLC("remove last char", "1 selector per each signature with length() > 1; example: kr thdr frhr z gtnbrg"),
        CWP("char wildcard prepended before first char", "1 selector per each signature - starting with the 2nd signature; example: krl _thdr frhr z gtnbrg"),
        CWS("char wildcard substituting first char", "1 selector per each signature - starting with the 2nd signature; example: krl _hdr frhr z gtnbrg"),
        RFC("remove first char", "1 selector per each signature with length() > 1 - starting with the 2nd signature; example: krl hdr frhr z gtnbrg"),
        SOM("some signatures", "if at least 2 signatures, each selector removes a signature; example: kr thdr frhr z"),
        FUZ("fuzzy wildcard", "1 selector for all signatures; example: krl thdr frhr z gtnbrg~"),
        SWE("string wildcard at the end", "1 selector after the first 2 of at least 3 signatures; example: krl thdr %"),
        SWM("string wildcard in the middle", "1 selector between the first and last of at least 2 signatures; example: krl % gtnbrg");

        private final String _name;
        private final String _description;

        private SelectorRound(String name, String description) {
            this._name = name;
            this._description = description;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return this._description;
        }
    }
}

