/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.stringSim;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Ponderation {
    public HashMap<String, Float> distC = new HashMap();
    public HashMap<String, int[][]> lookAt = new HashMap();
    public int[][] defaultLookAt = new int[][]{{1, 1}, {0, 1}, {1, 0}};
    public int countComparisons = 0;
    boolean allLowerCase = false;
    private int debug = 0;
    public int verbose = 0;
    private final Logger LOGGER = LogManager.getLogger(this.getClass());

    public Ponderation() {
    }

    public Ponderation(String ponderationFile) {
        if (!ponderationFile.endsWith(".data")) {
            this.readFromTextFile(ponderationFile);
        } else {
            this.readFromDataFile(ponderationFile);
        }
    }

    public void setDistance(String source, String target, float score) {
        this.distC.put(source + "|" + target, Float.valueOf(score));
    }

    public void saveToDataFile(String outputFileName) {
        try {
            FileOutputStream fout = new FileOutputStream(outputFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(this.distC);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToTextFile(String outputFileName) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), "UTF8"));
            Object[] keys = this.distC.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String k = (String)keys[i];
                Float v = this.distC.get((String)keys[i]);
                out.write(keys[i] + "\t" + v + "\n");
            }
            out.close();
            System.out.println("Written matrix in '" + outputFileName + "' Completed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readFromDataFile(String inputFileName) {
        if (this.verbose != 0) {
            System.err.println("STS: read matrix from data file '" + inputFileName + "'");
        }
        try {
            if (this.verbose != 0) {
                System.err.println("Ssim.Distance: Read from resource '" + inputFileName + "'");
            }
            InputStream fin = this.getClass().getResourceAsStream(inputFileName);
            ObjectInputStream ois = new ObjectInputStream(fin);
            this.distC = (HashMap)ois.readObject();
            if (this.distC.containsKey("#caseinsensitive|#caseinsensitive")) {
                this.allLowerCase = true;
                this.distC.remove("#caseinsensitive|#caseinsensitive");
            }
            if (this.verbose > 0) {
                System.err.println("CASE=" + this.allLowerCase);
            }
            ois.close();
            this.buildLookAt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.debug > 0) {
            System.out.println("from " + inputFileName + "dists:" + this.distC.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromInputStream(InputStream inputStream) {
        BufferedReader input = null;
        boolean bijective = false;
        float defaultDistance = 0.0f;
        try {
            input = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String line = null;
            Pattern p = Pattern.compile("^([^\t]+)(?:\t(([+-]?[0-9]+)([.0-9E-]+)?))?.*");
            while ((line = input.readLine()) != null) {
                Matcher m;
                if (line.startsWith("#")) {
                    if (line.startsWith("#CASEINSENSITIVE")) {
                        this.allLowerCase = true;
                        line = "#CASEINSENSITIVE|#CASEINSENSITIVE\t1";
                    } else {
                        if (line.startsWith("#BIJECTIVE")) {
                            bijective = true;
                            continue;
                        }
                        if (!line.startsWith("#DEFAULTDISTANCE=")) continue;
                        defaultDistance = Float.parseFloat(line.substring("#DEFAULTDISTANCE=".length()));
                        continue;
                    }
                }
                if ((m = p.matcher(line)).matches()) {
                    String s = m.group(1);
                    Float d = Float.valueOf(m.group(2) != null ? new Float(m.group(2)).floatValue() : defaultDistance);
                    String key = s.charAt(0) + "|" + s.charAt(1);
                    if (s.contains("|")) {
                        key = s.replaceAll("_", " ");
                    }
                    if (this.allLowerCase) {
                        key = key.toLowerCase();
                    }
                    if (!this.distC.containsKey(key) || d.floatValue() < this.distC.get(key).floatValue()) {
                        this.distC.put(key, d);
                    }
                    if (!bijective || this.distC.containsKey(key = key.replaceAll("^([^\\|]+)\\|([^\\|]+)$", "$2|$1")) && !(d.floatValue() < this.distC.get(key).floatValue())) continue;
                    this.distC.put(key, d);
                    continue;
                }
                if (line.isEmpty()) continue;
                if (line.contains("<>")) {
                    input.close();
                    this.readDictFromInput(input);
                }
                System.err.println("ssim.Distance: line does not match:" + line);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.buildLookAt();
        this.LOGGER.info(" Read from inputstream, case=" + this.allLowerCase + " defaultDist=" + defaultDistance);
        return 1;
    }

    private void readDictFromInput(BufferedReader input) throws IOException {
        String line = null;
        boolean bijective = false;
        float defaultDistance = 0.0f;
        Pattern p = Pattern.compile("^([^\t]+) *<> *([^\t]+)");
        while ((line = input.readLine()) != null) {
            Matcher m;
            if (line.startsWith("#")) {
                if (line.startsWith("#CASEINSENSITIVE")) {
                    this.allLowerCase = true;
                    line = "#CASEINSENSITIVE <> #CASEINSENSITIVE\t1";
                } else {
                    if (line.startsWith("#BIJECTIVE")) {
                        bijective = true;
                        continue;
                    }
                    if (!line.startsWith("#DEFAULTDISTANCE=")) continue;
                    defaultDistance = Float.parseFloat(line.substring("#DEFAULTDISTANCE=".length()));
                    continue;
                }
            }
            if ((m = p.matcher(line)).matches()) {
                String src = m.group(1);
                String dst = m.group(2);
                String key = src + "|" + dst;
                if (this.allLowerCase) {
                    key = key.toLowerCase();
                }
                if (this.distC.containsKey(key) && !(defaultDistance < this.distC.get(key).floatValue())) continue;
                this.distC.put(key, Float.valueOf(defaultDistance));
                continue;
            }
            if (line.isEmpty()) continue;
            System.err.println("ssim.Distance from dict: line does not match:" + line);
        }
    }

    public int readFromTextFile(String textFileName) {
        try {
            if (textFileName.startsWith("./") || textFileName.startsWith("/") || textFileName.matches("^[a-zA-Z]\\:.*")) {
                this.LOGGER.info("Ssim.Distance: Read from file '" + textFileName + "'");
                return this.readFromInputStream(new FileInputStream(textFileName));
            }
            System.err.println("Ssim.Distance: Read from resource '" + textFileName + "'");
            return this.readFromInputStream(this.getClass().getResourceAsStream(textFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int[][] getLookAt(char param_s, char param_d) {
        char s = this.allLowerCase ? Character.toLowerCase(param_s) : param_s;
        char d = this.allLowerCase ? Character.toLowerCase(param_d) : param_d;
        String k = "" + s + "|" + d;
        int[][] tsd = null;
        int[][] ts = null;
        int[][] td = null;
        int ntsd = 0;
        int nts = 0;
        int ntd = 0;
        if (this.lookAt.containsKey(k)) {
            tsd = this.lookAt.get(k);
            ntsd = tsd.length;
        }
        if (this.lookAt.containsKey("$|" + d)) {
            ts = this.lookAt.get("$|" + d);
            nts = ts.length;
        }
        if (this.lookAt.containsKey("" + s + "|$")) {
            td = this.lookAt.get("" + s + "|$");
            ntd = td.length;
        }
        if (ntsd > 0 && nts == 0 && ntd == 0) {
            return tsd;
        }
        int[][] res = new int[(ntsd > 0 ? ntsd : this.defaultLookAt.length) + nts + ntd][];
        int i = 0;
        if (ntsd > 0) {
            for (int[] line : tsd) {
                res[i++] = line;
            }
        } else {
            for (int[] line : this.defaultLookAt) {
                res[i++] = line;
            }
        }
        if (nts > 0) {
            for (int[] line : ts) {
                res[i++] = line;
            }
        }
        if (ntd > 0) {
            for (int[] line : td) {
                res[i++] = line;
            }
        }
        return res;
    }

    private void buildLookAt() {
        HashMap<String, ArrayList> la = new HashMap<String, ArrayList>();
        for (String k : this.distC.keySet()) {
            ArrayList myAlignment;
            String align;
            String cs = k.substring(0, k.indexOf("|"));
            String cd = k.substring(k.indexOf("|") + 1);
            int csl = cs.length();
            if (cs.equals("$")) {
                csl = 0;
            }
            int cdl = cd.length();
            if (cd.equals("$")) {
                cdl = 0;
            }
            if ((align = csl + "-" + cdl).equals("1-1")) continue;
            String key = "" + cs.charAt(cs.length() - 1) + "|" + cd.charAt(cd.length() - 1);
            if (la.containsKey(key)) {
                myAlignment = (ArrayList)la.get(key);
                if (myAlignment.contains(align)) continue;
                myAlignment.add(align);
                continue;
            }
            myAlignment = new ArrayList();
            myAlignment.add(align);
            la.put(key, myAlignment);
        }
        Iterator<String> iterator = la.keySet().iterator();
        while (iterator.hasNext()) {
            String pair;
            String paira = pair = iterator.next();
            ArrayList l = (ArrayList)la.get(paira);
            int[][] lookAtArray = new int[l.size() + 3][2];
            int n = 0;
            lookAtArray[0][0] = 1;
            lookAtArray[0][1] = 1;
            lookAtArray[1][0] = 1;
            lookAtArray[1][1] = 0;
            lookAtArray[2][0] = 0;
            lookAtArray[2][1] = 1;
            n = 3;
            for (int i = 0; i < l.size(); ++i) {
                String[] ali = new String[2];
                String alignment = (String)l.get(i);
                int g = alignment.indexOf("-");
                if (g < 0) continue;
                ali[0] = alignment.substring(0, g);
                ali[1] = alignment.substring(g + 1);
                lookAtArray[n][0] = Integer.parseInt(ali[0]);
                lookAtArray[n][1] = Integer.parseInt(ali[1]);
                ++n;
            }
            this.lookAt.put(pair, lookAtArray);
        }
    }

    public float distTwoChars(char sc, char dc) {
        String key = "" + sc + "|" + dc;
        if (this.allLowerCase) {
            key = key.toLowerCase();
        }
        if (this.distC.containsKey(key)) {
            return this.distC.get(key).floatValue();
        }
        return 1.0f;
    }

    public float Max(float a, float b) {
        if (b > a) {
            return b;
        }
        return a;
    }

    public float distTwoStrings(String sc, String dc) {
        ++this.countComparisons;
        String key = sc + "|" + dc;
        if (this.allLowerCase) {
            key = key.toLowerCase();
        }
        if (this.distC.containsKey(key)) {
            return this.distC.get(key).floatValue();
        }
        return this.Max(sc.length(), dc.length());
    }

    public float costDelete(char c) {
        String key = "" + c + "|$";
        if (this.allLowerCase) {
            key = key.toLowerCase();
        }
        if (this.distC.containsKey(key)) {
            System.out.println("cost delete'" + c + "'=" + this.distC.get("" + c).floatValue());
            return this.distC.get(key).floatValue();
        }
        return 1.0f;
    }
}

