/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.stringSim;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wipo.stringSim.Ponderation;

public final class TransTable {
    private Ponderation _pond;
    private Map<String, String> _bestmatch;
    private Map<Character, Set<Integer>> _lookup;

    public TransTable(String file) throws IOException {
        this._pond = new Ponderation(file);
        this._bestmatch = new HashMap<String, String>();
        this._lookup = new HashMap<Character, Set<Integer>>();
        HashMap<String, Float> value = new HashMap<String, Float>();
        for (String e : this._pond.distC.keySet()) {
            float v = this._pond.distC.get(e).floatValue();
            String left = e.substring(0, e.indexOf(124));
            String right = e.substring(e.indexOf(124) + 1);
            if (right.equalsIgnoreCase("$")) {
                right = "";
            }
            if (value.containsKey(left)) {
                float oldvalue = ((Float)value.get(left)).floatValue();
                if (!(oldvalue > v)) continue;
                value.put(left, Float.valueOf(v));
                this._bestmatch.put(left, right);
                continue;
            }
            value.put(left, Float.valueOf(v));
            this._bestmatch.put(left, right);
        }
        this.buildLookup();
    }

    private void buildLookup() {
        Set<String> k = this._bestmatch.keySet();
        for (String e : k) {
            Character c = Character.valueOf(e.charAt(0));
            if (!this._lookup.containsKey(c)) {
                this._lookup.put(c, new HashSet());
            }
            Set<Integer> s = this._lookup.get(c);
            s.add(e.length());
        }
    }

    public Set<Integer> lookup(char c) {
        if (this._lookup.containsKey(Character.valueOf(c))) {
            Set<Integer> s = this._lookup.get(Character.valueOf(c));
            return s;
        }
        return null;
    }

    public String bestMatch(char c) {
        return this.bestMatch(String.valueOf(c));
    }

    public String bestMatch(String s) {
        if (this._bestmatch.containsKey(s)) {
            return this._bestmatch.get(s);
        }
        return null;
    }
}

