/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import org.apache.log4j.BasicConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComponentCompilerTest {
    public static boolean compile(String componentName, String configurationFile) {
        Component.loggerMessage("Create an instance of: " + componentName);
        Component component = Component.getInstance(componentName);
        if (component.isNullComponent()) {
            return false;
        }
        Component.loggerMessage("Read configuration from file: " + configurationFile);
        Configuration configuration = Configuration.initializeFrom(configurationFile);
        if (configuration.isNull()) {
            return false;
        }
        Component.loggerMessage("Compile resources");
        boolean status = component.compile(configuration);
        if (!status) {
            return false;
        }
        Component.loggerMessage("Write compiled resources to file: " + configuration.getFeature("OutputFile"));
        String fileName = configuration.getFeature("OutputFile");
        status = component.saveToFile(fileName);
        if (!status) {
            return false;
        }
        if (!component.hasBeenInitialized()) {
            Component.loggerMessage("Compilation aborted.");
            return false;
        }
        Component.loggerMessage("Compilation successfull.");
        return true;
    }

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testCompilation() {
        Component.loggerMessage("TEST: compiling basic tokenizer");
        Assert.assertTrue((String)"Compiling basic tokenizer failed.", (boolean)ComponentCompilerTest.compile("basicTokenizer", "data/tokenizer/EN/BasicTokenizer_EN.cfg"));
        Component.loggerMessage("TEST: compiling basic scanner");
        Assert.assertTrue((String)"Compiling basic scanner failed.", (boolean)ComponentCompilerTest.compile("basicScanner", "data/scanner/EN/BasicScanner_EN.cfg"));
        Component.loggerMessage("TEST: compiling classifying tokenizer");
        Assert.assertTrue((String)"Compiling classifying tokenizer failed.", (boolean)ComponentCompilerTest.compile("classifyingTokenizer", "data/tokenizer/EN/ClassifyingTokenizer_EN.cfg"));
        Component.loggerMessage("TEST: compiling multext morphology");
        Assert.assertTrue((String)"Compiling multext morpholoy failed.", (boolean)ComponentCompilerTest.compile("multextMorphology", "data/morphology/EN/Multext_Morphology_EN.cfg"));
        Component.loggerMessage("TEST: compiling multext morphology 2");
        Assert.assertTrue((String)"Compiling multext morphology 2 failed.", (boolean)ComponentCompilerTest.compile("multextMorphology2", "data/morphology/EN/Multext_Morphology2_EN.cfg"));
        Component.loggerMessage("TEST: compiling basic gazetteer");
        Assert.assertTrue((String)"Compiling basic gazetteer failed.", (boolean)ComponentCompilerTest.compile("basicGazetteer", "data/gazetteer/LT-World/lt_world_sample.cfg"));
        Component.loggerMessage("TEST: compiling sentence splitter");
        Assert.assertTrue((String)"Compiling sentence splitter failed.", (boolean)ComponentCompilerTest.compile("sentenceSplitter", "data/sentenceSplitter/EN/Sentence_Splitter_EN.cfg"));
    }

    static {
        BasicConfigurator.configure();
    }
}

