/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.BasicFlatPatternMatcherApp;
import it.jrc.lt.core.component.application.BasicGazetteerApp;
import it.jrc.lt.core.component.application.BasicScannerApp;
import it.jrc.lt.core.component.application.BasicTokenizerApp;
import it.jrc.lt.core.component.application.ClassifyingTokenizerApp;
import it.jrc.lt.core.component.application.MultextMorphology2App;
import it.jrc.lt.core.component.application.MultextMorphologyApp;
import it.jrc.lt.core.component.application.SimpleSentenceSplitterApp;

public abstract class AbstractComponentApplication {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final AbstractComponentApplication nullApplication = new AbstractComponentApplication(){

        @Override
        public boolean initialize(Configuration configuration) {
            return false;
        }

        @Override
        public StringBuffer process(String inputText) {
            return new StringBuffer("*");
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };

    public abstract boolean initialize(Configuration var1);

    public abstract StringBuffer process(String var1);

    public static AbstractComponentApplication createApplication(String name) {
        if (name.compareTo("sentenceSplitter") == 0) {
            return new SimpleSentenceSplitterApp();
        }
        if (name.compareTo("basicTokenizer") == 0) {
            return new BasicTokenizerApp();
        }
        if (name.compareTo("basicScanner") == 0) {
            return new BasicScannerApp();
        }
        if (name.compareTo("basicFlatPatternMatcher") == 0) {
            return new BasicFlatPatternMatcherApp();
        }
        if (name.compareTo("classifyingTokenizer") == 0) {
            return new ClassifyingTokenizerApp();
        }
        if (name.compareTo("basicGazetteer") == 0) {
            return new BasicGazetteerApp();
        }
        if (name.compareTo("multextMorphology") == 0) {
            return new MultextMorphologyApp();
        }
        if (name.compareTo("multextMorphology2") == 0) {
            return new MultextMorphology2App();
        }
        return nullApplication;
    }

    public boolean isNull() {
        return false;
    }
}

