/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import it.jrc.lt.core.component.sentencesplitter.AbstractSentenceItem;
import it.jrc.lt.core.component.sentencesplitter.AbstractSentenceSplitter;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;

public class SimpleSentenceSplitterApp
extends AbstractComponentApplication {
    private static final String RESOURCE_FILE = "ResourceFile";
    private AbstractSentenceSplitter splitter;
    private AbstractTokenizer tokenizer = AbstractTokenizer.createInstance("basicTokenizer");

    @Override
    public boolean initialize(Configuration configuration) {
        this.splitter = AbstractSentenceSplitter.createInstance("sentenceSplitter");
        boolean status = this.splitter.readFromFile(configuration.getFeature(RESOURCE_FILE, ""));
        this.splitter.applySettings(configuration);
        return status && !this.splitter.isNullComponent() && this.splitter.hasBeenInitialized();
    }

    @Override
    public StringBuffer process(String inputText) {
        ArrayList<AbstractTokenItem> tokens = this.tokenizer.tokenize(inputText);
        ArrayList<AbstractSentenceItem> sentenceItems = this.splitter.segment(inputText, tokens);
        StringBuffer result = new StringBuffer();
        boolean tokenPositions = this.splitter.returnsTokenPositions();
        for (AbstractSentenceItem i : sentenceItems) {
            int start = tokenPositions ? tokens.get(i.getStart()).getStart() : i.getStart();
            int end = tokenPositions ? tokens.get(i.getEnd()).getEnd() : i.getEnd();
            result.append(i.toString() + " | " + inputText.substring(start, end + 1) + LINE_SEPARATOR);
            result.append("----------------------------------");
            result.append(LINE_SEPARATOR);
        }
        return result;
    }
}

