/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import it.jrc.lt.core.component.gazetteer.Attribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class Attributes {
    private Attribute[] myAttributes;

    private Attributes() {
        this.myAttributes = null;
    }

    private Attributes(ArrayList<Attribute> attributes) {
        int len = attributes.size();
        this.myAttributes = new Attribute[len];
        int i = 0;
        for (Attribute a : attributes) {
            this.myAttributes[i++] = a;
        }
    }

    private Attributes(Attribute[] attributes) {
        int len = attributes.length;
        this.myAttributes = new Attribute[len];
        System.arraycopy(attributes, 0, this.myAttributes, 0, len);
    }

    private Attributes(Attributes attributes) {
        int len = attributes.getNumberAttributes();
        this.myAttributes = new Attribute[len];
        for (int i = 0; i < len; ++i) {
            this.myAttributes[i] = attributes.getAttribute(i);
        }
    }

    public boolean isOpenClassAttribute(int i) {
        if (i >= 0 && i < this.myAttributes.length) {
            return this.myAttributes[i].isOpenClassAttribute();
        }
        return false;
    }

    public static Attributes createInstance(ArrayList<Attribute> attributes) {
        return new Attributes(attributes);
    }

    public static Attributes createInstance(Attribute[] attributes) {
        return new Attributes(attributes);
    }

    public static Attributes createInstance(Attributes attributes) {
        return new Attributes(attributes);
    }

    public Attribute getAttribute(int i) {
        if (i >= 0 && i < this.myAttributes.length) {
            return this.myAttributes[i];
        }
        return null;
    }

    public int getNumberAttributes() {
        return this.myAttributes.length;
    }

    public int getNumberOpenClassAttributes() {
        int count = 0;
        for (Attribute a : this.myAttributes) {
            if (!a.isOpenClassAttribute()) continue;
            ++count;
        }
        return count;
    }

    public boolean containsAttribute(String name) {
        for (Attribute attr : this.myAttributes) {
            if (attr.getName().compareTo(name) != 0) continue;
            return true;
        }
        return false;
    }

    public void writeToStream(DataOutputStream d) throws IOException {
        int len = this.myAttributes.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.myAttributes[i].writeToStream(d);
        }
    }

    public static Attributes readFromStream(DataInputStream d) throws IOException {
        int len = d.readInt();
        Attribute[] attributes = new Attribute[len];
        for (int i = 0; i < len; ++i) {
            attributes[i] = Attribute.readFromStream(d);
        }
        return Attributes.createInstance(attributes);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Attribute a : this.myAttributes) {
            result.append(a.toString());
            result.append('\n');
        }
        return result.toString();
    }
}

