/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import piskorski.util.functions.Files;

public class BasicGazetteerTest {
    private AbstractGazetteer myInstance;
    private String[] myEntries;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.myInstance = AbstractGazetteer.createInstance("basicGazetteer");
        this.myInstance.readFromFile("data/gazetteer/LT-World/lt_world_sample.gaz");
        this.myInstance.caseSensitiveModeActive();
        this.myEntries = Files.FileToStringArray("data/gazetteer/LT-World/lt_world_sample.txt", '#', "UTF-8");
        if (this.myEntries != null) {
            for (int i = 0; i < this.myEntries.length; ++i) {
                int where = this.myEntries[i].indexOf("|");
                this.myEntries[i] = this.myEntries[i].substring(0, where).trim();
            }
        }
    }

    @Test
    public void testLookUpString() {
        Assert.assertTrue((String)"Could not instantiate the  gazetteer.", (!this.myInstance.isNullComponent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Could not read gazetteer resources from file.", (boolean)this.myInstance.hasBeenInitialized());
        Assert.assertTrue((String)"Could not read entries. ", (this.myEntries != null ? 1 : 0) != 0);
        for (int i = 0; i < this.myEntries.length; ++i) {
            Assert.assertTrue((String)("Look-up for: " + this.myEntries[i] + " has failed."), (this.myInstance.lookUp(this.myEntries[i]) != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Found: 1234567890 in gazetteer.", (this.myInstance.lookUp("1234567890") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found: ---1234567890 in gazetteer.", (this.myInstance.lookUp("---1234567890") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found: **** in gazetteer.", (this.myInstance.lookUp("****") == null ? 1 : 0) != 0);
    }
}

