/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.ComponentException;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.gazetteer.AbstractDisjunctionOfGazetteerItems;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteerItem;
import it.jrc.lt.core.component.gazetteer.Attribute;
import it.jrc.lt.core.component.gazetteer.AttributeValuePair;
import it.jrc.lt.core.component.gazetteer.Attributes;
import it.jrc.lt.core.component.gazetteer.GazetteerException;
import it.jrc.lt.core.component.gazetteer.SearchStrategy;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSATraversing;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedTravFSAInterface;
import piskorski.fs.letterfs.fsa.FiniteStateAlgorithms;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Files;
import piskorski.util.strings.StringFunctions;

final class ExtendedGazetteer
extends AbstractGazetteer {
    Attributes myAttributes = null;
    private int numberOfAttributes;
    private static final int MAX_VAL_FOR_CLOSED_CLASS_ATTRIBUTES = 512;
    private static final int DEFAULT_MEMORY_BLOCK_SIZE = 20000;
    private static final char specialSeparator = ' ';
    DictionaryLetterFSA gazetteerAutomaton = null;
    private char boundaryMarker;
    private static final char comment = '#';
    private static final transient String className = "[" + ExtendedGazetteer.class.getSimpleName() + "] ";

    @Override
    public void writeToStream(DataOutputStream d) throws IOException {
        this.myAttributes.writeToStream(d);
        this.gazetteerAutomaton.writeToDataOutputStream(d);
        d.writeChar(this.boundaryMarker);
    }

    @Override
    public void readFromStream(DataInputStream d) throws IOException {
        this.myAttributes = Attributes.readFromStream(d);
        this.gazetteerAutomaton = DictionaryLetterFSA.getInstance("BASIC");
        this.gazetteerAutomaton.readFromDataInputStream(d);
        this.initTempComponents();
        this.boundaryMarker = d.readChar();
    }

    @Override
    public boolean hasBeenInitialized() {
        if (this.myAttributes == null) {
            return false;
        }
        return this.gazetteerAutomaton != null;
    }

    @Override
    public Attributes getAttributes() {
        return this.myAttributes;
    }

    @Override
    protected List<ConfigurationFeature> getCompilationFeatures() {
        return Collections.unmodifiableList(Arrays.asList(CompilationFeatures.FEATURES));
    }

    @Override
    protected List<ConfigurationFeature> getDeploymentFeatures() {
        return Collections.unmodifiableList(Arrays.asList(DeploymentFeatures.FEATURES));
    }

    @Override
    protected void applySpecificSettings(Configuration configuration) {
        SearchStrategy[] myStrategies;
        if (configuration.getFeature(DeploymentFeatures.CASE_SENSITIVE.getName()).compareTo("false") == 0) {
            this.caseInsensitiveModeActive();
        }
        if (configuration.getFeature(DeploymentFeatures.OUTPUT_TOKEN_POSITIONS.getName()).compareTo("true") == 0) {
            this.returnTokenPositions();
        }
        String strategy = configuration.getFeature(DeploymentFeatures.SEARCH_STRATEGY.getName());
        for (SearchStrategy s : myStrategies = SearchStrategy.values()) {
            if (s.getName().compareTo(strategy) != 0) continue;
            this.setSearchStrategy(s);
        }
    }

    private String[] analyzeEntries(CompilationVariables comp, String[] data) throws ComponentException {
        Component.loggerMessage("Trimming entries started");
        comp.numberEntries = data.length;
        for (int i = 0; i < data.length; ++i) {
            int lastKeywordIndex;
            int sepIndex = data[i].indexOf(comp.inputSeparator);
            if (sepIndex == -1) {
                Component.loggerMessageAndExit("Syntax error [Separator missing] at Line: " + data[i]);
            }
            for (lastKeywordIndex = sepIndex - 1; lastKeywordIndex > 0 && data[i].charAt(lastKeywordIndex) == ' '; --lastKeywordIndex) {
            }
            if (comp.downcaseEntries) {
                data[i] = data[i].substring(0, lastKeywordIndex + 1).toLowerCase() + data[i].substring(sepIndex);
                continue;
            }
            if (sepIndex - lastKeywordIndex <= 1) continue;
            data[i] = data[i].substring(0, lastKeywordIndex + 1) + data[i].substring(sepIndex);
        }
        return data;
    }

    private void analyzeAttributes(CompilationVariables comp, String[] attributes, String[] data) throws ComponentException {
        int j;
        Component.loggerMessage("Analyze attributes and create mappings");
        comp.attributeMapping = new HashMap();
        comp.numberOfAttributes = attributes.length;
        comp.attributeNames = new String[comp.numberOfAttributes];
        comp.StringValuedAttribute = new boolean[comp.numberOfAttributes];
        comp.applyFormationPattern = new boolean[comp.numberOfAttributes];
        Arrays.fill(comp.applyFormationPattern, true);
        for (int i = 0; i < comp.numberOfAttributes; ++i) {
            boolean isOpenClassAttribute = false;
            int where = 0;
            if (attributes[i].charAt(0) == '*') {
                isOpenClassAttribute = true;
                ++where;
                if (attributes[i].charAt(1) == '*') {
                    ++where;
                    comp.applyFormationPattern[i] = false;
                }
            }
            comp.attributeMapping.put(attributes[i].substring(where).trim(), new Integer(i));
            comp.attributeNames[i] = attributes[i].substring(where).trim();
            comp.StringValuedAttribute[i] = isOpenClassAttribute;
        }
        Component.loggerMessage("Create mapping: Number -> Attribute value");
        comp.attributeValueMapping = new HashMap[comp.numberOfAttributes];
        HashMap[] valueIDMapping = new HashMap[comp.numberOfAttributes];
        int[] valueCounters = new int[comp.numberOfAttributes];
        for (int i = 0; i < comp.numberOfAttributes; ++i) {
            comp.attributeValueMapping[i] = new HashMap();
            valueIDMapping[i] = new HashMap();
            valueCounters[i] = !comp.StringValuedAttribute[i] ? 0 : -1;
        }
        int firstNotStringValued = -1;
        for (int i = 0; i < comp.numberOfAttributes; ++i) {
            if (comp.StringValuedAttribute[i]) continue;
            firstNotStringValued = i;
            break;
        }
        StringBuffer sep = new StringBuffer();
        sep.append(this.boundaryMarker);
        sep.append(comp.inputSeparator);
        sep.append('\n');
        sep.append('\r');
        comp.inputSeparators = sep.toString();
        int lenData = comp.numberEntries;
        comp.averageLineLength = 0;
        for (int i = 0; i < lenData; ++i) {
            String line = data[i].trim();
            if (line.charAt(0) == '#') continue;
            comp.averageLineLength += line.length();
            StringTokenizer sTok = new StringTokenizer(line, comp.inputSeparators);
            String NextEntry = null;
            if (line.indexOf(comp.inputSeparator) == -1 || !sTok.hasMoreTokens()) {
                Component.loggerMessageAndExit("Syntax error [Separator missing] at Line: " + line);
            }
            NextEntry = sTok.nextToken().trim();
            while (sTok.hasMoreTokens()) {
                int NextValueInt;
                Integer ValueCode;
                int CCode;
                String NextAttr = null;
                String NextValue = null;
                try {
                    NextAttr = sTok.nextToken().trim();
                    if (NextAttr.length() == 0) {
                        Component.loggerMessageAndExit("Syntax error [Missing attribute name] at line: " + line);
                    }
                    if ((NextValue = sTok.nextToken().trim()).length() == 0) {
                        Component.loggerMessageAndExit("Syntax error [Missing attribute value] at line: " + line);
                    }
                }
                catch (NoSuchElementException e) {
                    Component.loggerMessageAndExit("Syntax error [Unknown] at line: " + line);
                }
                Integer Code = comp.attributeMapping.get(NextAttr);
                if (Code == null) {
                    Component.loggerMessageAndExit("Syntax error [Attribute Name <" + NextAttr + "> unknown] at line: " + line);
                }
                if (comp.StringValuedAttribute[CCode = Code.intValue()] || (ValueCode = (Integer)comp.attributeValueMapping[CCode].get(NextValue)) != null) continue;
                int n = CCode;
                valueCounters[n] = valueCounters[n] + 1;
                if (NextValueInt > 512) {
                    Component.loggerMessageAndExit("The attribute " + NextAttr + " has been defined as closed-class attribute, but has more than " + 512 + " values which is not allowed. Check gazetteer configuration file !");
                }
                comp.attributeValueMapping[CCode].put(NextValue, new Integer(NextValueInt));
                valueIDMapping[CCode].put(new Integer(NextValueInt), NextValue);
            }
        }
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (int i = 0; i < comp.numberOfAttributes; ++i) {
            int size = comp.StringValuedAttribute[i] ? 0 : valueCounters[i];
            String[] values = new String[size];
            for (j = 0; j < size; ++j) {
                values[j] = (String)valueIDMapping[i].get(new Integer(j));
            }
            newAttributes.add(Attribute.createInstance(comp.attributeNames[i], comp.StringValuedAttribute[i], values));
        }
        this.myAttributes = Attributes.createInstance(newAttributes);
        this.numberOfAttributes = this.myAttributes.getNumberAttributes();
        comp.numberOfOpenClassAttributes = this.numberOfAttributes - this.myAttributes.getNumberOpenClassAttributes();
        comp.orderOfCodingAttributes = new int[comp.numberOfOpenClassAttributes];
        if (firstNotStringValued != -1) {
            int i;
            int[] valueCountersCopy = new int[valueCounters.length];
            for (i = 0; i < valueCountersCopy.length; ++i) {
                valueCountersCopy[i] = valueCounters[i];
            }
            for (i = 0; i < comp.numberOfOpenClassAttributes; ++i) {
                int max = firstNotStringValued;
                for (j = 0; j < valueCountersCopy.length; ++j) {
                    if (valueCountersCopy[j] <= valueCountersCopy[max]) continue;
                    max = j;
                }
                comp.orderOfCodingAttributes[i] = max;
                valueCountersCopy[max] = -1;
            }
        }
    }

    private String[] compress(String[] entries, CompilationVariables comp) throws ComponentException {
        int[] CurrAttrVal = new int[comp.numberOfAttributes];
        for (int i = 0; i < comp.numberOfAttributes; ++i) {
            CurrAttrVal[i] = -1;
        }
        comp.patternYes = 0;
        comp.patternNo = 0;
        Component.logger.info((Object)"Create new representation for Gazetteer entries.");
        StringArrayList ConvertedData = new StringArrayList(entries.length);
        String LastEntry = new String();
        int currentIndex = 0;
        StringBuffer Next = new StringBuffer();
        String Pattern = null;
        for (int i = 0; i < comp.numberEntries; ++i) {
            int j;
            String line = entries[i].trim();
            if (line.charAt(0) == '#') continue;
            StringTokenizer sTok = new StringTokenizer(line, comp.inputSeparators);
            String NextEntry = sTok.nextToken().trim();
            if (LastEntry.compareTo(NextEntry) == 0) {
                ++currentIndex;
            } else {
                LastEntry = NextEntry;
                currentIndex = 0;
            }
            while (sTok.hasMoreTokens()) {
                String NextAttr = null;
                String NextValue = null;
                try {
                    NextAttr = sTok.nextToken().trim();
                    NextValue = sTok.nextToken().trim();
                }
                catch (NoSuchElementException e) {
                    Component.loggerMessageAndExit("Syntax error [Unidentified] at some line with the entry: " + NextEntry);
                }
                Integer Code = comp.attributeMapping.get(NextAttr);
                int CCode = Code;
                if (CurrAttrVal[CCode] != -1) {
                    Component.loggerMessageAndExit("Syntax error [Double occurence of attribute <" + NextAttr + "> for the entry " + NextEntry + " ] at some line");
                }
                if (comp.StringValuedAttribute[CCode]) {
                    CurrAttrVal[CCode] = 1;
                    Pattern = comp.applyFormationPattern[CCode] ? StringFunctions.FormingPattern(NextEntry, NextValue) : null;
                    if (Pattern == null) {
                        ConvertedData.add(NextEntry + this.boundaryMarker + (char)currentIndex + (char)CCode + NextValue);
                        ++comp.patternNo;
                        continue;
                    }
                    ++comp.patternYes;
                    ConvertedData.add(NextEntry + this.boundaryMarker + (char)currentIndex + (char)CCode + Pattern);
                    continue;
                }
                CurrAttrVal[CCode] = (Integer)comp.attributeValueMapping[CCode].get(NextValue);
            }
            Next.setLength(0);
            Next.append(NextEntry);
            Next.append(this.boundaryMarker);
            Next.append((char)currentIndex);
            boolean any = false;
            for (j = 0; j < comp.numberOfOpenClassAttributes; ++j) {
                if (CurrAttrVal[comp.orderOfCodingAttributes[j]] == -1) continue;
                Next.append((char)comp.orderOfCodingAttributes[j]);
                Next.append((char)CurrAttrVal[comp.orderOfCodingAttributes[j]]);
                any = true;
            }
            for (j = 0; j < comp.numberOfAttributes; ++j) {
                CurrAttrVal[j] = -1;
            }
            if (!any) continue;
            ConvertedData.add(Next.toString());
        }
        int lenDataNew = ConvertedData.size();
        String[] newEntries = new String[lenDataNew];
        for (int i = 0; i < lenDataNew; ++i) {
            newEntries[i] = ConvertedData.get(i);
        }
        ConvertedData = null;
        return newEntries;
    }

    private DictionaryLetterFSA constructAutomaton(String[] entries, CompilationVariables comp) {
        Component.loggerMessage("Gazetteer automaton construction");
        DynamicLetterMarkedTravFSAInterface tempAutomaton = FiniteStateAlgorithms.MinDetAutomatonFromListOfWordsX(entries, false, 10, 3, false);
        Component.loggerMessage("Gazetteer automaton compression");
        DictionaryLetterFSA compressedAutomaton = DictionaryLetterFSA.getInstance("BASIC");
        compressedAutomaton.initializeFrom(tempAutomaton);
        return compressedAutomaton;
    }

    @Override
    protected boolean initialize(Configuration configuration) {
        Component.loggerMessage("Read gazetteer resources from file");
        CompilationVariables comp = new CompilationVariables(configuration);
        try {
            Component.loggerMessage("Reading entries from: " + comp.entriesFile);
            String[] entries = Files.FileToStringArray(comp.entriesFile, '#', comp.characterSet);
            Component.loggerMessage("Building the gazetteer");
            entries = null;
        }
        catch (Exception e) {
            Component.loggerMessage(className + e.toString() + e.getMessage());
            return false;
        }
        comp = null;
        return true;
    }

    @Override
    public boolean createFrom(String[] attributes, String[] entryList, Configuration configuration) throws GazetteerException {
        Component.loggerMessage("Constructing the gazetteer");
        configuration.checkConfiguration(this.getCompilationFeatures());
        CompilationVariables comp = new CompilationVariables(configuration);
        try {
            Component.loggerMessage("Analyzing the entries");
            this.analyzeEntries(comp, entryList);
            Component.loggerMessage("Sort the entries");
            Arrays.sort(entryList);
            this.boundaryMarker = comp.attributeValueSeparator;
            Component.loggerMessage("Analyzing ans setting the attributes");
            this.analyzeAttributes(comp, attributes, entryList);
            Component.loggerMessage("Compressing the entries");
            String[] compressedEntries = this.compress(entryList, comp);
            Component.loggerMessage("Constructing the automaton");
            this.gazetteerAutomaton = this.constructAutomaton(compressedEntries, comp);
            compressedEntries = null;
            Component.loggerMessage("Some Initializations");
            this.initTempComponents();
            Component.loggerMessage("Gazetteer Information");
            Component.loggerMessage("Number of Entries: " + comp.numberEntries);
            Component.loggerMessage("Number of Attributes: " + comp.numberOfAttributes);
            Component.loggerMessage("Average Line length in gazetteer sources: " + comp.averageLineLength / comp.numberEntries);
            Component.loggerMessage("Formation pattern applicability: " + (double)comp.patternYes / (double)(comp.patternNo + comp.patternYes));
            Component.loggerMessage("#String-valued Attributes: " + comp.numberOfOpenClassAttributes);
        }
        catch (Exception e) {
            Component.loggerMessage(className + e.getMessage());
            return false;
        }
        comp = null;
        return true;
    }

    private void initTempComponents() {
        this.numberOfAttributes = this.myAttributes.getNumberAttributes();
    }

    @Override
    public AbstractDisjunctionOfGazetteerItems lookUp(char[] word) {
        DictionaryLetterFSA.State currentState = null;
        int wordLength = word.length;
        char[] temp = new char[wordLength + 1];
        System.arraycopy(word, 0, temp, 0, wordLength);
        temp[wordLength++] = this.boundaryMarker;
        currentState = DictionaryLetterFSATraversing.delta(this.gazetteerAutomaton, temp);
        if (currentState == null) {
            DictionaryLetterFSATraversing.deltaDowncased(this.gazetteerAutomaton, temp);
        }
        StringArrayList labels = currentState != null ? DictionaryLetterFSATraversing.getPathLabels(currentState) : null;
        return labels != null ? this.getGazetteerInterpretations(0, wordLength - 1, word, labels) : null;
    }

    @Override
    public AbstractDisjunctionOfGazetteerItems lookUpLongestPrefix(char[] word) {
        StringArrayList labels;
        DictionaryLetterFSA.State currentState = null;
        int wordLength = word.length;
        char[] temp = new char[wordLength];
        System.arraycopy(word, 0, temp, 0, wordLength);
        int lenPrefix = 0;
        lenPrefix = DictionaryLetterFSATraversing.longestPrefix(this.gazetteerAutomaton, temp);
        if (lenPrefix == 0) {
            DictionaryLetterFSATraversing.longestPrefixDowncased(this.gazetteerAutomaton, temp);
        }
        if (lenPrefix == 0) {
            return null;
        }
        wordLength = lenPrefix + 1;
        temp = new char[wordLength];
        System.arraycopy(word, 0, temp, 0, wordLength);
        temp[wordLength++] = this.boundaryMarker;
        currentState = DictionaryLetterFSATraversing.delta(this.gazetteerAutomaton, temp);
        if (currentState == null) {
            DictionaryLetterFSATraversing.deltaDowncased(this.gazetteerAutomaton, temp);
        }
        StringArrayList stringArrayList = labels = currentState != null ? DictionaryLetterFSATraversing.getPathLabels(currentState) : null;
        if (labels == null) {
            return null;
        }
        char[] finalWord = new char[lenPrefix];
        System.arraycopy(word, 0, finalWord, 0, lenPrefix);
        return this.getGazetteerInterpretations(0, lenPrefix - 1, finalWord, labels);
    }

    private String getAttributeValue(int attributeIndex, int valueIndex) {
        Attribute a = this.myAttributes.getAttribute(attributeIndex);
        return a != null ? a.getValue(valueIndex) : null;
    }

    private AbstractDisjunctionOfGazetteerItems getGazetteerInterpretations(int start, int end, char[] word, StringArrayList labels) {
        ArrayList<ExtendedGazetteerItem> gazetteerTemporaryResults = new ArrayList<ExtendedGazetteerItem>();
        this.addGazetteerInterpretations(start, end, word, labels, gazetteerTemporaryResults);
        return new DisjunctionOfExtendedGazetteerItems(gazetteerTemporaryResults);
    }

    private void addGazetteerInterpretations(int start, int end, char[] word, StringArrayList labels, ArrayList<ExtendedGazetteerItem> gazetteerTemporaryResults) {
        IntArrayList[] labelsToProcess = new IntArrayList[]{new IntArrayList(), new IntArrayList()};
        IntArrayList foundForCurrentReading = new IntArrayList();
        for (int i = 0; i < labels.size(); ++i) {
            labelsToProcess[0].add(i);
        }
        int currentList = 0;
        int currentReading = 0;
        int[] tempAttrID = new int[this.numberOfAttributes];
        String[] tempAttrValues = new String[this.numberOfAttributes];
        while (labelsToProcess[currentList].size() > 0) {
            foundForCurrentReading.clear();
            for (int i = 0; i < labelsToProcess[currentList].size(); ++i) {
                int next = labelsToProcess[currentList].get(i);
                if (labels.get(next).charAt(0) == currentReading) {
                    foundForCurrentReading.add(next);
                    continue;
                }
                labelsToProcess[1 - currentList].add(next);
            }
            int currentAttributeListLength = 0;
            int len = foundForCurrentReading.size();
            for (int i = 0; i < len; ++i) {
                String currentVal = labels.get(foundForCurrentReading.get(i));
                char attributeIndex = currentVal.charAt(1);
                if (!this.myAttributes.isOpenClassAttribute(attributeIndex)) {
                    int howMany = currentVal.length();
                    int tempNext = 1;
                    while (tempNext < howMany) {
                        tempAttrID[currentAttributeListLength] = currentVal.charAt(tempNext++);
                        tempAttrValues[currentAttributeListLength] = this.getAttributeValue(tempAttrID[currentAttributeListLength], currentVal.charAt(tempNext++));
                        ++currentAttributeListLength;
                    }
                    continue;
                }
                tempAttrID[currentAttributeListLength] = attributeIndex;
                tempAttrValues[currentAttributeListLength] = currentVal.charAt(2) == '+' ? StringFunctions.reconstructWord(currentVal.substring(2), new String(word)) : currentVal.substring(2);
                ++currentAttributeListLength;
            }
            ExtendedGazetteerItem newItem = new ExtendedGazetteerItem(start, end, tempAttrID, tempAttrValues, currentAttributeListLength);
            gazetteerTemporaryResults.add(newItem);
            labelsToProcess[currentList].clear();
            currentList = 1 - currentList;
            ++currentReading;
        }
    }

    protected ExtendedGazetteer() {
    }

    @Override
    public ArrayList<AbstractDisjunctionOfGazetteerItems> findMatch(ArrayList<AbstractTokenItem> tokens, char[] inputText) {
        ArrayList<AbstractDisjunctionOfGazetteerItems> result = new ArrayList<AbstractDisjunctionOfGazetteerItems>(tokens.size() / 20);
        int numTokens = tokens.size();
        int startPos = 0;
        boolean longestMatch = this.getSearchStrategy().equals(SearchStrategy.LONGEST_MATCH);
        Counter lastToken = new Counter();
        while (startPos < numTokens) {
            AbstractDisjunctionOfGazetteerItems singleResult;
            lastToken.setCounter(startPos);
            if (longestMatch) {
                singleResult = this.findLongestMatchAtGivenPosition(inputText, tokens, lastToken, startPos, false);
                if (singleResult == null) {
                    ++startPos;
                    continue;
                }
                result.add(singleResult);
                startPos = lastToken.getVal() + 1;
                continue;
            }
            singleResult = this.findAllMatchesAtGivenPosition(inputText, tokens, startPos, false);
            if (singleResult != null) {
                result.add(singleResult);
            }
            ++startPos;
        }
        return result;
    }

    private AbstractDisjunctionOfGazetteerItems findAllMatchesAtGivenPosition(char[] myText, ArrayList<AbstractTokenItem> tokens, int startPos, boolean enforceWhitespaceAfter) {
        DictionaryLetterFSA.State nextState;
        if (myText.length == 0) {
            return null;
        }
        DictionaryLetterFSA.State currentState = this.gazetteerAutomaton.getInitialState();
        int maxToken = tokens.size();
        ArrayList<ExtendedGazetteerItem> gazetteerTemporaryResults = new ArrayList<ExtendedGazetteerItem>();
        DictionaryLetterFSA.Transition currentTransition = null;
        for (int currentToken = startPos; currentToken < maxToken && (nextState = this.consumeToken(myText, tokens, currentState, currentToken)) != null; ++currentToken) {
            if (nextState.getTransitionLabelledWith(this.boundaryMarker) != null) {
                DictionaryLetterFSA.Transition tempTransition;
                DictionaryLetterFSA.State tempState;
                StringArrayList labels;
                boolean toBeMarked = true;
                if (enforceWhitespaceAfter && currentToken < maxToken - 1 && tokens.get(currentToken).getEnd() + 1 == tokens.get(currentToken + 1).getStart()) {
                    toBeMarked = false;
                }
                if (toBeMarked && (labels = DictionaryLetterFSATraversing.getPathLabels(tempState = (tempTransition = nextState.getTransitionLabelledWith(this.boundaryMarker)).getTargetState())) != null) {
                    char[] word = this.getMatchAsCharArray(myText, tokens, startPos, currentToken);
                    if (this.producesTokenPositions()) {
                        this.addGazetteerInterpretations(startPos, currentToken, word, labels, gazetteerTemporaryResults);
                    } else {
                        this.addGazetteerInterpretations(tokens.get(startPos).getStart(), tokens.get(currentToken).getEnd(), word, labels, gazetteerTemporaryResults);
                    }
                }
            }
            if (currentToken < maxToken - 1 && tokens.get(currentToken).getEnd() + 1 != tokens.get(currentToken + 1).getStart()) {
                currentTransition = nextState.getTransitionLabelledWith(' ');
                if (currentTransition == null) break;
                nextState = currentTransition.getTargetState();
            }
            currentState = nextState;
        }
        return gazetteerTemporaryResults.size() == 0 ? null : new DisjunctionOfExtendedGazetteerItems(gazetteerTemporaryResults);
    }

    private char[] getMatchAsCharArray(char[] myText, ArrayList<AbstractTokenItem> tokens, int startPos, int endPos) {
        StringBuffer tempWord = new StringBuffer();
        char[] next = StringFunctions.getCharArray(tokens.get(startPos).getStart(), tokens.get(startPos).getEnd(), myText);
        tempWord.append(next);
        for (int currentToken = startPos + 1; currentToken <= endPos; ++currentToken) {
            if (tokens.get(currentToken - 1).getEnd() + 1 != tokens.get(currentToken).getStart()) {
                tempWord.append(' ');
            }
            next = StringFunctions.getCharArray(tokens.get(currentToken).getStart(), tokens.get(currentToken).getEnd(), myText);
            tempWord.append(next);
        }
        return StringFunctions.stringBufferToArray(tempWord);
    }

    private DictionaryLetterFSA.State consumeToken(char[] myText, ArrayList<AbstractTokenItem> tokens, DictionaryLetterFSA.State startState, int tokenIndex) {
        int i;
        DictionaryLetterFSA.State currentState = startState;
        DictionaryLetterFSA.Transition currentTransition = null;
        int len = tokens.get(tokenIndex).getEnd();
        for (i = tokens.get(tokenIndex).getStart(); i <= len; ++i) {
            if (myText[i] == this.boundaryMarker) {
                return null;
            }
            char nextSymbol = this.isCaseSensitive() ? myText[i] : Character.toLowerCase(myText[i]);
            currentTransition = currentState.getTransitionLabelledWith(nextSymbol);
            if (currentTransition == null) {
                return null;
            }
            currentState = currentTransition.getTargetState();
        }
        return i == len + 1 ? currentState : null;
    }

    private AbstractDisjunctionOfGazetteerItems findLongestMatchAtGivenPosition(char[] myText, ArrayList<AbstractTokenItem> tokens, Counter lastToken, int startPos, boolean enforceWhitespaceAfter) {
        StringArrayList labels;
        DictionaryLetterFSA.State nextState;
        DictionaryLetterFSA.Transition currentTransition = null;
        DictionaryLetterFSA.State currentState = this.gazetteerAutomaton.getInitialState();
        DictionaryLetterFSA.State LastFinalState = null;
        if (myText.length == 0) {
            return null;
        }
        lastToken.setCounter(startPos);
        int maxToken = tokens.size();
        for (int currentToken = startPos; currentToken < maxToken && (nextState = this.consumeToken(myText, tokens, currentState, currentToken)) != null; ++currentToken) {
            if (nextState.getTransitionLabelledWith(this.boundaryMarker) != null) {
                boolean toBeMarked = true;
                if (enforceWhitespaceAfter && currentToken < maxToken - 1 && tokens.get(currentToken).getEnd() + 1 == tokens.get(currentToken + 1).getStart()) {
                    toBeMarked = false;
                }
                if (toBeMarked) {
                    LastFinalState = nextState;
                    lastToken.setCounter(currentToken);
                }
            }
            if (currentToken < maxToken - 1 && tokens.get(currentToken).getEnd() + 1 != tokens.get(currentToken + 1).getStart()) {
                currentTransition = nextState.getTransitionLabelledWith(' ');
                if (currentTransition == null) break;
                nextState = currentTransition.getTargetState();
            }
            currentState = nextState;
        }
        if (LastFinalState != null && (labels = DictionaryLetterFSATraversing.getPathLabels(currentState = (currentTransition = LastFinalState.getTransitionLabelledWith(this.boundaryMarker)).getTargetState())) != null) {
            char[] word = this.getMatchAsCharArray(myText, tokens, startPos, lastToken.getVal());
            if (this.producesTokenPositions()) {
                return this.getGazetteerInterpretations(startPos, lastToken.getVal(), word, labels);
            }
            return this.getGazetteerInterpretations(tokens.get(startPos).getStart(), tokens.get(lastToken.getVal()).getEnd(), word, labels);
        }
        return null;
    }

    @Override
    public AbstractDisjunctionOfGazetteerItems findMatchAtGivenPosition(ArrayList<AbstractTokenItem> tokens, char[] inputText, int startPosition, boolean enforceWhitespaceAfter) {
        Counter lastToken = new Counter();
        if (this.getSearchStrategy().equals(SearchStrategy.LONGEST_MATCH)) {
            return this.findLongestMatchAtGivenPosition(inputText, tokens, lastToken, startPosition, enforceWhitespaceAfter);
        }
        return this.findAllMatchesAtGivenPosition(inputText, tokens, startPosition, enforceWhitespaceAfter);
    }

    private final class Counter {
        int counter;

        private Counter() {
        }

        private void initCounter() {
            this.counter = 0;
        }

        void setCounter(int val) {
            this.counter = val;
        }

        int getVal() {
            return this.counter;
        }
    }

    private class CompilationVariables {
        String characterSet;
        char inputSeparator;
        char attributeValueSeparator;
        String entriesFile;
        String TypesFile;
        boolean downcaseEntries;
        int externalMemoryBlock;
        boolean useExternalMemory;
        String name;
        HashMap<String, Integer> attributeMapping;
        int numberOfAttributes;
        int numberEntries;
        int numberOfOpenClassAttributes;
        String[] attributeNames;
        boolean[] StringValuedAttribute;
        boolean[] applyFormationPattern;
        int[] orderOfCodingAttributes;
        String inputSeparators;
        HashMap[] attributeValueMapping;
        int patternYes;
        int patternNo;
        int averageLineLength;

        CompilationVariables(Configuration configuration) {
            this.characterSet = configuration.getFeature(CompilationFeatures.CHARACTERSET.getName());
            this.inputSeparator = configuration.getFeature(CompilationFeatures.INPUT_SEPARATOR.getName()).charAt(0);
            this.attributeValueSeparator = configuration.getFeature(CompilationFeatures.ATTRIBUTE_VALUE_SEPARATOR.getName()).charAt(0);
            this.entriesFile = configuration.getFeature(CompilationFeatures.ENTRY_FILE.getName());
            this.TypesFile = configuration.getFeature(CompilationFeatures.TYPE_FILE.getName());
            this.downcaseEntries = configuration.getFeature(CompilationFeatures.DOWNCASE_ENTRIES.getName()).compareTo("true") == 0;
            this.useExternalMemory = configuration.getFeature(CompilationFeatures.USE_EXTERNAL_MEMORY.getName()).compareTo("true") == 0;
            this.name = configuration.getFeature(CompilationFeatures.NAME.getName());
            String memBlock = configuration.getFeature(CompilationFeatures.EXTERNAL_MEMORY_BLOCK.getName());
            try {
                this.externalMemoryBlock = new Integer(memBlock.trim());
            }
            catch (Exception e) {
                ExtendedGazetteer.loggerMessage("Invalid format of the " + CompilationFeatures.EXTERNAL_MEMORY_BLOCK.getName() + " feature. Default settings will be used");
                this.externalMemoryBlock = 20000;
            }
        }
    }

    private final class DisjunctionOfExtendedGazetteerItems
    extends AbstractDisjunctionOfGazetteerItems {
        private final ExtendedGazetteerItem[] myItems;

        @Override
        public int getNumberOfItems() {
            return this.myItems.length;
        }

        @Override
        public AbstractGazetteerItem getItem(int i) {
            return i >= 0 && i < this.myItems.length ? this.myItems[i] : null;
        }

        private DisjunctionOfExtendedGazetteerItems() {
            this.myItems = null;
        }

        DisjunctionOfExtendedGazetteerItems(ArrayList<ExtendedGazetteerItem> items) {
            int len = items.size();
            this.myItems = new ExtendedGazetteerItem[len];
            int i = 0;
            for (ExtendedGazetteerItem it : items) {
                this.myItems[i++] = it;
            }
        }

        DisjunctionOfExtendedGazetteerItems(ExtendedGazetteerItem[] items) {
            int len = items.length;
            this.myItems = new ExtendedGazetteerItem[len];
            for (int i = 0; i < len; ++i) {
                this.myItems[i] = items[i];
            }
        }
    }

    private class ExtendedGazetteerItem
    extends AbstractGazetteerItem {
        private int[] attribute;
        private String[] value;

        private ExtendedGazetteerItem() {
            this.attribute = null;
            this.value = null;
        }

        ExtendedGazetteerItem(int start, int end, int[] attributeID, String[] values, int size) {
            this.setStart(start);
            this.setEnd(end);
            this.setSize(size);
            this.attribute = new int[size];
            this.value = new String[size];
            System.arraycopy(attributeID, 0, this.attribute, 0, size);
            System.arraycopy(values, 0, this.value, 0, size);
        }

        @Override
        public String getAttributeName(int i) {
            if (i >= 0 && i < this.getSize()) {
                return ExtendedGazetteer.this.myAttributes.getAttribute(this.attribute[i]).getName();
            }
            return null;
        }

        @Override
        public Attribute getAttribute(int i) {
            if (i >= 0 && i < this.getSize()) {
                return ExtendedGazetteer.this.myAttributes.getAttribute(this.attribute[i]);
            }
            return null;
        }

        @Override
        public String getValue(int i) {
            if (i >= 0 && i < this.getSize()) {
                return this.value[i];
            }
            return null;
        }

        @Override
        public AttributeValuePair getAVPair(int i) {
            if (i >= 0 && i < this.getSize()) {
                return AttributeValuePair.createInstance(ExtendedGazetteer.this.myAttributes.getAttribute(this.attribute[i]), this.value[i]);
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("[START: ");
            result.append(this.getStart());
            result.append(", END: ");
            result.append(this.getEnd());
            int len = this.getSize();
            for (int i = 0; i < len; ++i) {
                result.append(", ");
                result.append(this.getAttributeName(i));
                result.append(": ");
                result.append(this.value[i]);
            }
            result.append("]");
            return result.toString();
        }
    }

    private static final class DeploymentFeatures {
        static final ConfigurationFeature CHARACTER_SET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature SEARCH_STRATEGY = ConfigurationFeature.createFeature("SearchStrategy", false, "longest-match");
        static final ConfigurationFeature CASE_SENSITIVE = ConfigurationFeature.createFeature("CaseSensitive", false, "true");
        static final ConfigurationFeature OUTPUT_TOKEN_POSITIONS = ConfigurationFeature.createFeature("OutputTokenPositions", false, "false");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{CHARACTER_SET, SEARCH_STRATEGY, CASE_SENSITIVE, OUTPUT_TOKEN_POSITIONS};

        private DeploymentFeatures() {
        }
    }

    private static final class CompilationFeatures {
        static final ConfigurationFeature NAME = ConfigurationFeature.createFeature("Name", true, "");
        static final ConfigurationFeature TYPE_FILE = ConfigurationFeature.createFeature("TypeFile", true, "");
        static final ConfigurationFeature ENTRY_FILE = ConfigurationFeature.createFeature("EntryFile", true, "");
        static final ConfigurationFeature DOWNCASE_ENTRIES = ConfigurationFeature.createFeature("DownCaseEntries", false, "false");
        static final ConfigurationFeature CHARACTERSET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature INPUT_SEPARATOR = ConfigurationFeature.createFeature("InputSeparator", true, "");
        static final ConfigurationFeature ATTRIBUTE_VALUE_SEPARATOR = ConfigurationFeature.createFeature("AttributeValueSeparator", true, "");
        static final ConfigurationFeature USE_EXTERNAL_MEMORY = ConfigurationFeature.createFeature("UseExternalMemory", false, "false");
        static final ConfigurationFeature EXTERNAL_MEMORY_BLOCK = ConfigurationFeature.createFeature("ExternalMemoryBlock", false, "20000");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{NAME, TYPE_FILE, ENTRY_FILE, DOWNCASE_ENTRIES, CHARACTERSET, INPUT_SEPARATOR, ATTRIBUTE_VALUE_SEPARATOR, USE_EXTERNAL_MEMORY, EXTERNAL_MEMORY_BLOCK};

        private CompilationFeatures() {
        }
    }
}

