/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.gazetteer;

import it.jrc.lt.core.component.gazetteer.Attributes;

public class Type {
    private final String name;
    private final String[] attributes;

    public String getName() {
        return this.name;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    private Type() {
        this.name = null;
        this.attributes = null;
    }

    private Type(String name, String[] attributes) {
        this.name = name;
        int size = attributes.length;
        this.attributes = new String[size];
        for (int i = 0; i < size; ++i) {
            this.attributes[i] = attributes[i];
        }
    }

    private Type(String name, Attributes attributes) {
        this.name = name;
        int size = attributes.getNumberAttributes();
        this.attributes = new String[size];
        for (int i = 0; i < size; ++i) {
            this.attributes[i] = attributes.getAttribute(i).getName();
        }
    }

    private Type(Type type) {
        this.name = type.name;
        int size = type.attributes.length;
        this.attributes = new String[size];
        for (int i = 0; i < size; ++i) {
            this.attributes[i] = type.attributes[i];
        }
    }

    public boolean containsAttribute(String name) {
        if (name == null) {
            return false;
        }
        for (String attr : this.attributes) {
            if (attr.compareTo(name) != 0) continue;
            return true;
        }
        return false;
    }

    public static Type createInstance(String name, String[] attributes) {
        return new Type(name, attributes);
    }

    public static Type createInstance(String name, Attributes attributes) {
        return new Type(name, attributes);
    }

    public static Type createInstance(Type type) {
        return new Type(type);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Type: ");
        result.append(this.getName());
        result.append('\n');
        result.append(" Attributes: ");
        int size = this.attributes.length;
        for (int i = 0; i < size; ++i) {
            result.append(this.attributes[i]);
            result.append(" ");
        }
        return result.toString();
    }
}

