/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.morphology.AbstractMorphologyItem;
import it.jrc.lt.core.component.morphology.MultextPartOfSpeech;

final class MultextMorphologyItem
extends AbstractMorphologyItem {
    private char[] attrValList;
    private char[] lemma;

    @Override
    public char[] getLemma() {
        return this.lemma;
    }

    protected void setLemma(String lemma) {
        if (lemma == null) {
            return;
        }
        this.lemma = lemma.toCharArray();
    }

    protected void setLemma(char[] lemma) {
        if (lemma == null) {
            return;
        }
        int len = lemma.length;
        this.lemma = new char[len];
        System.arraycopy(lemma, 0, this.lemma, 0, len);
    }

    @Override
    public char getTag(int index) {
        return index < 0 || index >= this.attrValList.length ? (char)'-' : this.attrValList[index];
    }

    @Override
    public String getTagName(int index) {
        return MultextPartOfSpeech.getTagName(this.getPos(), index);
    }

    @Override
    public char getTag(String tagName) {
        MultextPartOfSpeech p = MultextPartOfSpeech.getPartOfSpeech(this.getPos());
        int index = p.getTagIndex(tagName);
        return index != -1 ? this.attrValList[index] : (char)'-';
    }

    @Override
    public char[] getTags() {
        return this.attrValList;
    }

    @Override
    public int getNumberTags() {
        return this.attrValList != null ? this.attrValList.length : 0;
    }

    protected void setAttributeValueList(String attrValList) {
        this.attrValList = attrValList.toCharArray();
    }

    protected void setAttributeValueList(char[] attrValList) {
        int len = attrValList.length;
        this.attrValList = new char[len];
        System.arraycopy(attrValList, 0, this.attrValList, 0, len);
    }

    MultextMorphologyItem(int start, int end, char pos, String lemma, String attrValList) {
        this.setStart(start);
        this.setEnd(end);
        this.setPos(pos);
        this.setLemma(lemma);
        this.attrValList = attrValList.toCharArray();
        this.setAttributeValueList(attrValList);
    }

    MultextMorphologyItem(int start, int end, char pos, char[] lemma, char[] attrValList) {
        this.setStart(start);
        this.setEnd(end);
        this.setPos(pos);
        this.setLemma(lemma);
        this.setAttributeValueList(attrValList);
    }
}

