/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.morphology.MultextAttributes;
import java.util.HashMap;

public enum MultextPartOfSpeech {
    NOUN('N', MultextAttributes.nounTagNames),
    VERB('V', MultextAttributes.verbTagNames),
    ADJECTIVE('A', MultextAttributes.adjectiveTagNames),
    PRONOUN('P', MultextAttributes.pronounTagNames),
    DETERMINER('D', MultextAttributes.determinerTagNames),
    ARTICLE('T', MultextAttributes.articleTagNames),
    ADVERB('R', MultextAttributes.adverbTagNames),
    ADPOSITION('S', MultextAttributes.adpositionTagNames),
    CONJUNCTION('C', MultextAttributes.conjunctionTagNames),
    NUMERAL('M', MultextAttributes.numeralTagNames),
    INTERJECTION('I', MultextAttributes.interjectionTagNames),
    RESIDUAL('X', MultextAttributes.residualTagNames),
    ABBREVIATION('Y', MultextAttributes.abbreviationTagNames),
    PARTICLE('Q', MultextAttributes.particleTagNames),
    UNKNOWN('U', MultextAttributes.unknownTagNames);

    public static final int UNKNOWN_INDEX = -1;
    private final char partOfSpeech;
    private final String[] attribute;
    private final HashMap<String, Integer> mapTagNameToId;
    private static final HashMap<Character, MultextPartOfSpeech> mapCodeToPartOfSpeech;
    private static final char[] myPartOfSpeechCodes;

    private MultextPartOfSpeech(char pos, String[] attribute) {
        this.partOfSpeech = pos;
        this.attribute = attribute;
        this.mapTagNameToId = new HashMap();
        int count = 0;
        for (String tagName : this.attribute) {
            this.mapTagNameToId.put(tagName, count++);
        }
    }

    public int getTagIndex(String s) {
        Integer index = this.mapTagNameToId.get(s);
        return index != -1 ? index : -1;
    }

    public char getCode() {
        return this.partOfSpeech;
    }

    public int getNumAttributes() {
        return this.attribute.length;
    }

    public static MultextPartOfSpeech getPartOfSpeech(char code) {
        return mapCodeToPartOfSpeech.get(Character.valueOf(code));
    }

    public static String getTagName(char partOfSpeech, int index) {
        String[] tagNames;
        MultextPartOfSpeech pos = mapCodeToPartOfSpeech.get(Character.valueOf(partOfSpeech));
        String[] stringArray = tagNames = pos != null ? pos.attribute : null;
        return tagNames != null ? (index < 0 || index >= tagNames.length ? null : tagNames[index]) : null;
    }

    public static char[] getPosCodes() {
        return myPartOfSpeechCodes;
    }

    static {
        mapCodeToPartOfSpeech = new HashMap();
        for (MultextPartOfSpeech p : MultextPartOfSpeech.values()) {
            mapCodeToPartOfSpeech.put(Character.valueOf(p.partOfSpeech), p);
        }
        MultextPartOfSpeech[] myValues = MultextPartOfSpeech.values();
        myPartOfSpeechCodes = new char[myValues.length];
        int count = 0;
        for (MultextPartOfSpeech p : myValues) {
            MultextPartOfSpeech.myPartOfSpeechCodes[count++] = p.getCode();
        }
    }
}

