/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.scanner;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.scanner.AbstractScanner;
import it.jrc.lt.core.component.scanner.AbstractScannerItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import piskorski.util.functions.DataStream;

public class BasicScanner
extends AbstractScanner {
    private byte[] charType = new byte[65536];
    private byte[] charSubType = new byte[65536];
    private String[] subtypes;
    private static final String defaultSubtypes = "uppercase_latin:ABCDEFGHIJKLMNOPRQSTUVWYXZ,lowercase_latin:abcdefghijklmnopqrstuwvyxz,opening_bracket:[{(,closing_bracket:]}),q_mark:\",e_mark:!,at:@,hash:#,";
    private static final byte NO_SUBTYPE_CODE = 0;
    private static final String NO_SUBTYPE_NAME = "none";
    private static final transient String className = "[" + BasicScanner.class.getSimpleName() + "] ";
    private static final transient int MAX_CHAR = 65536;

    protected BasicScanner() {
        this.initCharTypeArray();
        this.initCharSubTypeArray(defaultSubtypes);
    }

    private void initCharTypeArray() {
        int len = 65536;
        for (int i = 0; i < len; ++i) {
            char c = (char)i;
            this.charType[i] = this.assignCharType(c);
        }
    }

    private HashMap<String, String> computeDefs(String subtypeDefs) {
        HashMap<String, String> myDefs = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(subtypeDefs, ",");
        int numDefs = st.countTokens();
        for (int i = 0; i < numDefs; ++i) {
            String def = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(def, ":");
            if (st2.countTokens() != 2) {
                Component.loggerMessage(className + "Syntax error encountered while processing the definition of Character Subtypes in: " + def);
            }
            myDefs.put(st2.nextToken(), st2.nextToken());
        }
        return myDefs;
    }

    private void initCharSubTypeArray(String subtypeDefs) {
        Arrays.fill(this.charSubType, (byte)0);
        HashMap<String, String> defs = this.computeDefs(subtypeDefs);
        int numSubTypes = defs.size();
        this.subtypes = new String[numSubTypes + 1];
        this.subtypes[0] = NO_SUBTYPE_NAME;
        Iterator<String> it = defs.keySet().iterator();
        int count = 1;
        while (it.hasNext()) {
            String subtype;
            this.subtypes[count] = subtype = it.next();
            String myClass = defs.get(subtype);
            int len = myClass.length();
            for (int i = 0; i < len; ++i) {
                this.charSubType[myClass.charAt((int)i)] = count;
            }
            count = (byte)(count + 1);
        }
    }

    private byte assignCharType(char c) {
        if (Character.isLetter(c) && Character.isLowerCase(c)) {
            return CharType.LOWERCASE_LETTER.getCode();
        }
        if (Character.isLetter(c) && Character.isUpperCase(c)) {
            return CharType.UPPERCASE_LETTER.getCode();
        }
        if (Character.isLetter(c) && Character.isTitleCase(c)) {
            return CharType.TITLECASE_LETTER.getCode();
        }
        if (Character.isLetter(c)) {
            return CharType.OTHER_LETTER.getCode();
        }
        if (Character.isDigit(c)) {
            if (c >= '0' && c <= '9') {
                return CharType.LATIN_DIGIT.getCode();
            }
            return CharType.OTHER_DIGIT.getCode();
        }
        if (Character.getType(c) == 11 || Character.getType(c) == 10) {
            return CharType.NUMBER.getCode();
        }
        if (Character.getType(c) == 26) {
            return CharType.CURRENCY_SYMBOL.getCode();
        }
        if (Character.getType(c) == 25) {
            return CharType.MATH_SYMBOL.getCode();
        }
        if (Character.getType(c) == 27) {
            return CharType.MODIFIER_SYMBOL.getCode();
        }
        if (Character.getType(c) == 28) {
            return CharType.OTHER_SYMBOL.getCode();
        }
        if (Character.getType(c) == 23) {
            return CharType.CONNECTOR_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 20) {
            return CharType.DASH_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 22) {
            return CharType.CLOSE_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 21) {
            return CharType.OPEN_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 29) {
            return CharType.INITIAL_QUOTE_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 30) {
            return CharType.FINAL_QUOTE_PUNCTUATION.getCode();
        }
        if (Character.getType(c) == 24) {
            return CharType.OTHER_PUNCTUATION.getCode();
        }
        if (Character.isWhitespace(c)) {
            if (Character.isSpaceChar(c)) {
                return CharType.SPACE_SEPARATOR.getCode();
            }
            return CharType.OTHER_SEPARATOR.getCode();
        }
        return CharType.OTHER.getCode();
    }

    @Override
    public void writeToStream(DataOutputStream d) throws IOException {
        DataStream.writeByteArray(d, this.charType);
        DataStream.writeByteArray(d, this.charSubType);
        DataStream.writeStringArray(d, this.subtypes);
        DataStream.writeString(d, this.getName());
    }

    @Override
    public void readFromStream(DataInputStream d) throws IOException {
        this.charType = DataStream.readByteArray(d);
        this.charSubType = DataStream.readByteArray(d);
        this.subtypes = DataStream.readStringArray(d);
        this.setName(DataStream.readString(d));
    }

    @Override
    public ArrayList<AbstractScannerItem> scan(char[] inputText) {
        int len = inputText.length;
        ArrayList<AbstractScannerItem> chars = new ArrayList<AbstractScannerItem>(len);
        for (int i = 0; i < len; ++i) {
            char c = inputText[i];
            chars.add(new BasicScannerItem(i, i, c, this.charType[c], this.charSubType[c]));
        }
        return chars;
    }

    @Override
    public boolean hasBeenInitialized() {
        if (this.charType == null) {
            return false;
        }
        if (this.charSubType == null) {
            return false;
        }
        if (this.subtypes == null) {
            return false;
        }
        return this.getName() != null;
    }

    @Override
    protected List<ConfigurationFeature> getCompilationFeatures() {
        return Collections.unmodifiableList(Arrays.asList(CompilationFeatures.FEATURES));
    }

    @Override
    protected List<ConfigurationFeature> getDeploymentFeatures() {
        return Collections.unmodifiableList(Arrays.asList(DeploymentFeatures.FEATURES));
    }

    @Override
    protected void applySpecificSettings(Configuration configuration) {
    }

    @Override
    protected boolean initialize(Configuration configuration) {
        try {
            String charSubTypes = configuration.getFeature(CompilationFeatures.CHARACTER_SUBTYPES.getName(), "");
            if (charSubTypes.length() == 0) {
                charSubTypes = defaultSubtypes;
                Component.loggerMessage(className + "Missing or invalid value of the feature: " + CompilationFeatures.CHARACTER_SUBTYPES.getName() + ". Default settings will be used.");
            }
            this.initCharSubTypeArray(charSubTypes);
            String name = configuration.getFeature(CompilationFeatures.NAME.getName(), "");
            if (name.length() == 0) {
                Component.loggerMessage(className + "Missing feature: " + CompilationFeatures.NAME.getName());
                return false;
            }
            this.setName(name);
        }
        catch (Exception e) {
            Component.loggerMessage(className + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Map<Byte, String> getTypeNames() {
        return Collections.unmodifiableMap(CharType.types);
    }

    @Override
    public Map<Byte, String> getSubTypeNames() {
        HashMap<Byte, String> subTypes = new HashMap<Byte, String>();
        for (int i = 0; i < this.subtypes.length; ++i) {
            subTypes.put((byte)i, this.subtypes[i]);
        }
        return subTypes;
    }

    private static final class DeploymentFeatures {
        static final ConfigurationFeature CHARACTER_SET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{CHARACTER_SET};

        private DeploymentFeatures() {
        }
    }

    private static final class CompilationFeatures {
        static final ConfigurationFeature CHARACTER_SUBTYPES = ConfigurationFeature.createFeature("CharacterSubtypes", false, "");
        static final ConfigurationFeature NAME = ConfigurationFeature.createFeature("Name", true, "");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{CHARACTER_SUBTYPES, NAME};

        private CompilationFeatures() {
        }
    }

    private final class BasicScannerItem
    extends AbstractScannerItem {
        @Override
        protected String getType(byte type) {
            return CharType.types.get(type);
        }

        @Override
        protected String getSubType(byte subtype) {
            if (subtype >= 0 && subtype < BasicScanner.this.subtypes.length) {
                return BasicScanner.this.subtypes[subtype];
            }
            return BasicScanner.NO_SUBTYPE_NAME;
        }

        BasicScannerItem(int start, int end, char myChar, byte type, byte subtype) {
            super(start, end, myChar, type, subtype);
        }

        @Override
        public String toString() {
            return "[" + this.getStart() + "," + this.getEnd() + "," + this.getChar() + "," + this.getTypeAsString() + "," + this.getSubTypeAsString() + "]";
        }
    }

    public static final class CharType
    extends Enum<CharType> {
        public static final /* enum */ CharType UPPERCASE_LETTER;
        public static final /* enum */ CharType LOWERCASE_LETTER;
        public static final /* enum */ CharType TITLECASE_LETTER;
        public static final /* enum */ CharType OTHER_LETTER;
        public static final /* enum */ CharType LATIN_DIGIT;
        public static final /* enum */ CharType OTHER_DIGIT;
        public static final /* enum */ CharType NUMBER;
        public static final /* enum */ CharType CURRENCY_SYMBOL;
        public static final /* enum */ CharType MATH_SYMBOL;
        public static final /* enum */ CharType MODIFIER_SYMBOL;
        public static final /* enum */ CharType OTHER_SYMBOL;
        public static final /* enum */ CharType CONNECTOR_PUNCTUATION;
        public static final /* enum */ CharType DASH_PUNCTUATION;
        public static final /* enum */ CharType CLOSE_PUNCTUATION;
        public static final /* enum */ CharType OPEN_PUNCTUATION;
        public static final /* enum */ CharType INITIAL_QUOTE_PUNCTUATION;
        public static final /* enum */ CharType FINAL_QUOTE_PUNCTUATION;
        public static final /* enum */ CharType OTHER_PUNCTUATION;
        public static final /* enum */ CharType SPACE_SEPARATOR;
        public static final /* enum */ CharType OTHER_SEPARATOR;
        public static final /* enum */ CharType OTHER;
        private final byte code;
        private final String description;
        static final HashMap<Byte, String> types;
        private static final /* synthetic */ CharType[] $VALUES;

        public static CharType[] values() {
            return (CharType[])$VALUES.clone();
        }

        public static CharType valueOf(String name) {
            return Enum.valueOf(CharType.class, name);
        }

        private CharType(byte code, String description) {
            this.code = code;
            this.description = description;
        }

        public byte getCode() {
            return this.code;
        }

        String getDescription() {
            return this.description;
        }

        static {
            CharType[] myTypes;
            UPPERCASE_LETTER = new CharType(0, "uppercase_letter");
            LOWERCASE_LETTER = new CharType(1, "lowercase_letter");
            TITLECASE_LETTER = new CharType(2, "titlecase_letter");
            OTHER_LETTER = new CharType(3, "other_letter");
            LATIN_DIGIT = new CharType(4, "latin_digit");
            OTHER_DIGIT = new CharType(5, "other_digit");
            NUMBER = new CharType(6, "number");
            CURRENCY_SYMBOL = new CharType(7, "currency");
            MATH_SYMBOL = new CharType(8, "math");
            MODIFIER_SYMBOL = new CharType(9, "modifier");
            OTHER_SYMBOL = new CharType(10, "other_sym");
            CONNECTOR_PUNCTUATION = new CharType(11, "connector_punct");
            DASH_PUNCTUATION = new CharType(12, "dash_punct");
            CLOSE_PUNCTUATION = new CharType(13, "close_punct");
            OPEN_PUNCTUATION = new CharType(14, "open_punct");
            INITIAL_QUOTE_PUNCTUATION = new CharType(15, "init_quote_punct");
            FINAL_QUOTE_PUNCTUATION = new CharType(16, "final_quote_punct");
            OTHER_PUNCTUATION = new CharType(17, "other_punct");
            SPACE_SEPARATOR = new CharType(18, "space");
            OTHER_SEPARATOR = new CharType(19, "other_whitespace");
            OTHER = new CharType(20, "other");
            $VALUES = new CharType[]{UPPERCASE_LETTER, LOWERCASE_LETTER, TITLECASE_LETTER, OTHER_LETTER, LATIN_DIGIT, OTHER_DIGIT, NUMBER, CURRENCY_SYMBOL, MATH_SYMBOL, MODIFIER_SYMBOL, OTHER_SYMBOL, CONNECTOR_PUNCTUATION, DASH_PUNCTUATION, CLOSE_PUNCTUATION, OPEN_PUNCTUATION, INITIAL_QUOTE_PUNCTUATION, FINAL_QUOTE_PUNCTUATION, OTHER_PUNCTUATION, SPACE_SEPARATOR, OTHER_SEPARATOR, OTHER};
            types = new HashMap();
            for (CharType t : myTypes = CharType.values()) {
                types.put(t.getCode(), t.getDescription());
            }
        }
    }
}

