/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.tokenizer;

import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClassifyingTokenizerTest {
    private AbstractTokenizer myInstance;
    private String myText = "123 . , / \\ - : ; ' \" ! % ? $ { ) #  EU commission  Ispra aBB GmbH Siemens-Sun well-oiled O'Neil don't jakub.piskorski@jrc.it http://www.onet.pl 2MB 200kg Windows2000 mk2";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.myInstance = AbstractTokenizer.createInstance("classifyingTokenizer");
        this.myInstance.readFromFile("data/tokenizer/EN/ClassifyingTokenizer_EN.tok");
    }

    @Test
    public void testClassifyingTokens() {
        Assert.assertTrue((String)"Could not instantiate the tokenizer.", (!this.myInstance.isNullComponent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Could not read tokenizer resources from file.", (boolean)this.myInstance.hasBeenInitialized());
        ArrayList<AbstractTokenItem> result = this.myInstance.tokenize(this.myText);
        Assert.assertTrue((String)"Could not tokenize.", (result != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Number of tokens is wrong (32):" + result.size()), (result != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)result.get(0).getTypeAsString(), (Object)"any_natural_number");
        Assert.assertEquals((Object)result.get(1).getTypeAsString(), (Object)"dot");
        Assert.assertEquals((Object)result.get(2).getTypeAsString(), (Object)"comma");
        Assert.assertEquals((Object)result.get(3).getTypeAsString(), (Object)"slash");
        Assert.assertEquals((Object)result.get(4).getTypeAsString(), (Object)"back_slash");
        Assert.assertEquals((Object)result.get(5).getTypeAsString(), (Object)"hyphen");
        Assert.assertEquals((Object)result.get(6).getTypeAsString(), (Object)"colon");
        Assert.assertEquals((Object)result.get(7).getTypeAsString(), (Object)"semicolon");
        Assert.assertEquals((Object)result.get(8).getTypeAsString(), (Object)"apostrophe");
        Assert.assertEquals((Object)result.get(9).getTypeAsString(), (Object)"quotation");
        Assert.assertEquals((Object)result.get(10).getTypeAsString(), (Object)"exclamation");
        Assert.assertEquals((Object)result.get(11).getTypeAsString(), (Object)"percentage");
        Assert.assertEquals((Object)result.get(12).getTypeAsString(), (Object)"question_mark");
        Assert.assertEquals((Object)result.get(13).getTypeAsString(), (Object)"currency_sign");
        Assert.assertEquals((Object)result.get(14).getTypeAsString(), (Object)"opening_bracket");
        Assert.assertEquals((Object)result.get(15).getTypeAsString(), (Object)"closing_bracket");
        Assert.assertEquals((Object)result.get(16).getTypeAsString(), (Object)"other_symbol");
        Assert.assertEquals((Object)result.get(17).getTypeAsString(), (Object)"all_capital_word");
        Assert.assertEquals((Object)result.get(18).getTypeAsString(), (Object)"lower_case_word");
        Assert.assertEquals((Object)result.get(19).getTypeAsString(), (Object)"first_capital_word");
        Assert.assertEquals((Object)result.get(20).getTypeAsString(), (Object)"mixed_word_first_lower");
        Assert.assertEquals((Object)result.get(21).getTypeAsString(), (Object)"mixed_word_first_capital");
        Assert.assertEquals((Object)result.get(22).getTypeAsString(), (Object)"word_with_hyphen_first_capital");
        Assert.assertEquals((Object)result.get(23).getTypeAsString(), (Object)"word_with_hyphen_first_lower");
        Assert.assertEquals((Object)result.get(24).getTypeAsString(), (Object)"word_with_apostrophe_first_capital");
        Assert.assertEquals((Object)result.get(25).getTypeAsString(), (Object)"word_with_apostrophe_first_lower");
        Assert.assertEquals((Object)result.get(26).getTypeAsString(), (Object)"email_address");
        Assert.assertEquals((Object)result.get(27).getTypeAsString(), (Object)"url_address");
        Assert.assertEquals((Object)result.get(28).getTypeAsString(), (Object)"number_word_first_capital");
        Assert.assertEquals((Object)result.get(29).getTypeAsString(), (Object)"number_word_first_lower");
        Assert.assertEquals((Object)result.get(30).getTypeAsString(), (Object)"word_number_first_capital");
        Assert.assertEquals((Object)result.get(31).getTypeAsString(), (Object)"word_number_first_lower");
    }
}

