/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.arraylist;

public final class CharacterArrayList {
    private transient char[] elementData;
    private int size;
    private int minCapacity;

    public CharacterArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new char[initialCapacity];
    }

    public CharacterArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public char get(int index) {
        return this.elementData[index];
    }

    public void set(int index, char value) {
        this.elementData[index] = value;
    }

    public boolean add(char o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            char[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public char removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public char remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        char temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }
}

