/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.fileoperations;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Files;

public class generatePlurals {
    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.out.println("Usage: AddAttributes InputFile OutputFile PluralPatterns Encoding");
            System.exit(0);
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        String pluralPatternsFileName = args[2];
        String encoding = args[3];
        HashMap<String, String> suffixMapping = new HashMap<String, String>();
        String[] Input = Files.FileToStringArray(pluralPatternsFileName, encoding);
        int len = Input.length;
        for (int i = 0; i < len; ++i) {
            StringTokenizer sT = new StringTokenizer(Input[i], "\t");
            String f = sT.nextToken();
            String l = sT.nextToken();
            suffixMapping.put(f, l);
        }
        Input = Files.FileToStringArray(inputFileName, encoding);
        len = Input.length;
        String endOfLine = System.getProperty("line.separator");
        HashSet<String> entries = new HashSet<String>();
        StringArrayList suffixes = new StringArrayList();
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int k = 0;
            String nextEntry = Input[i];
            int length = nextEntry.length();
            while (nextEntry.charAt(k) != '|' && nextEntry.charAt(k) != '\t' && ++k != length) {
            }
            String entry = nextEntry.substring(0, k).trim();
            int lenEntry = entry.length();
            boolean contPunct = false;
            for (k = 0; k < lenEntry; ++k) {
                if (entry.charAt(k) != '.') continue;
                contPunct = true;
                break;
            }
            if (contPunct || lenEntry < 4) {
                System.out.println(entry);
                continue;
            }
            suffixes.clear();
            for (k = 1; k < 5; ++k) {
                suffixes.add(entry.substring(lenEntry - k));
            }
            boolean found = false;
            for (int j = suffixes.size() - 1; j >= 0; --j) {
                if (suffixMapping.get(suffixes.get(j)) == null) continue;
                entries.add(entry.substring(0, lenEntry - j - 1) + (String)suffixMapping.get(suffixes.get(j)));
                found = true;
                break;
            }
            if (found) continue;
            System.out.println(entry);
        }
        for (String next : entries) {
            output.append(next);
            output.append(" | ");
            output.append("GTYPE:person_position");
            output.append(" | ");
            output.append("GNUMBER:pl");
            output.append(" | ");
            output.append("SURFACE:");
            output.append(next);
            output.append(endOfLine);
        }
        Files.StringBufferToFile(outputFileName, output, "UTF-8");
    }
}

