/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.mapping;

import java.util.Arrays;

public final class StaticCharToIntMap {
    public static int UNDEFINED = -1;
    private static int SIZE = 256;
    private char[] myChars;
    private int[] myInts;
    private int[] myPosition;
    private int charListSize;

    private void initialize(char[] charList, int size) {
        this.myChars = new char[size];
        this.myInts = new int[size];
        this.myPosition = new int[SIZE];
        this.charListSize = size;
        Arrays.fill(this.myPosition, 0);
        Arrays.fill(this.myInts, UNDEFINED);
    }

    private void computeMyPosition(char[] charList, int size) {
        for (int i = 0; i < size; ++i) {
            int n = charList[i] % SIZE;
            this.myPosition[n] = this.myPosition[n] + 1;
        }
        int neededByPrev = this.myPosition[0];
        this.myPosition[0] = 0;
        for (int i = 1; i < SIZE; ++i) {
            int temp = this.myPosition[i];
            this.myPosition[i] = this.myPosition[i - 1] + neededByPrev;
            neededByPrev = temp;
        }
    }

    private StaticCharToIntMap(char[] charList, int[] intList) {
        int size = charList.length;
        this.initialize(charList, size);
        this.computeMyPosition(charList, size);
        boolean[] charIsSet = new boolean[size];
        Arrays.fill(charIsSet, false);
        block0: for (int i = 0; i < size; ++i) {
            int end;
            char myC = charList[i];
            int lot = myC % SIZE;
            int n = end = lot + 1 < SIZE ? this.myPosition[lot + 1] : size;
            for (int start = this.myPosition[lot]; start < end; ++start) {
                if (charIsSet[start]) continue;
                this.myChars[start] = myC;
                this.myInts[start] = intList == null ? i : intList[i];
                charIsSet[start] = true;
                continue block0;
            }
        }
        charIsSet = null;
    }

    public int getInt(char c) {
        int end;
        short lot = (short)(c % SIZE);
        int n = end = lot + 1 < SIZE ? this.myPosition[lot + 1] : this.charListSize;
        for (int start = this.myPosition[lot]; start < end; ++start) {
            if (c != this.myChars[start]) continue;
            return this.myInts[start];
        }
        return UNDEFINED;
    }

    public static StaticCharToIntMap createInstance(char[] charList) {
        return charList == null ? null : new StaticCharToIntMap(charList, null);
    }

    public static StaticCharToIntMap createrInstance(char[] charList, int[] intList) {
        if (charList == null) {
            return null;
        }
        if (intList == null) {
            return null;
        }
        if (charList.length != intList.length) {
            return null;
        }
        return new StaticCharToIntMap(charList, intList);
    }
}

