/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;
import piskorski.util.strings.distmetrics.AbstractSubstitutionCost;
import piskorski.util.strings.distmetrics.DefaultBasicCost;

public class NeedlemanWunsch
extends AbstractDistanceMetric {
    private float gapCost = 2.0f;
    private AbstractSubstitutionCost subCostFunc = new DefaultBasicCost();

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": GAPCOST:" + this.gapCost + " SUBSTCOSTFUNCTION:" + this.subCostFunc.getName();
    }

    private float getNeedlemanWunschScore(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                float cost = this.subCostFunc.getCost(s, i - 1, t, j - 1);
                d[i][j] = Math.min(Math.min(d[i - 1][j] + this.gapCost, d[i][j - 1] + this.gapCost), d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    @Override
    public float getDistance(String s1, String s2) {
        float maxValue;
        float needlemanWunschScore = this.getNeedlemanWunschScore(s1, s2);
        float minValue = maxValue = (float)Math.max(s1.length(), s2.length());
        maxValue = this.subCostFunc.getMaxCost() > this.gapCost ? (maxValue *= this.subCostFunc.getMaxCost()) : (maxValue *= this.gapCost);
        minValue = this.subCostFunc.getMinCost() < this.gapCost ? (minValue *= this.subCostFunc.getMinCost()) : (minValue *= this.gapCost);
        if (minValue < 0.0f) {
            maxValue -= minValue;
            needlemanWunschScore -= minValue;
        }
        return maxValue == 0.0f ? 0.0f : needlemanWunschScore / maxValue;
    }

    @Override
    public String getName() {
        return "NeedlemanWunsh";
    }

    @Override
    public void setProperties(Properties props) {
        String gapCost = props.getProperty("GAPCOST");
        String substCostFunction = props.getProperty("SUBSTCOSTFUNCTION");
        if (gapCost != null) {
            try {
                this.gapCost = Float.parseFloat(gapCost);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (substCostFunction != null) {
            try {
                AbstractSubstitutionCost newSubstCost = AbstractSubstitutionCost.getInstance(substCostFunction);
                if (newSubstCost != null) {
                    this.subCostFunc = newSubstCost;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

