/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import java.util.StringTokenizer;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.math.PermutationGenerator;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class PermutedTokensDistance
extends AbstractDistanceMetric {
    private AbstractDistanceMetric distanceMetric = AbstractDistanceMetric.getInstance("JaroWinkler");

    @Override
    public float getDistance(String s1, String s2) {
        int[] indices;
        StringTokenizer sT1 = new StringTokenizer(s1, " \t", false);
        StringTokenizer sT2 = new StringTokenizer(s2, " \t", false);
        int lenST1 = sT1.countTokens();
        int lenST2 = sT2.countTokens();
        String[] tokensS1 = new String[lenST1];
        String[] tokensS2 = new String[lenST2];
        int i = 0;
        while (sT1.hasMoreTokens()) {
            tokensS1[i++] = sT1.nextToken();
        }
        i = 0;
        while (sT2.hasMoreTokens()) {
            tokensS2[i++] = sT2.nextToken();
        }
        PermutationGenerator x = new PermutationGenerator(lenST1);
        int numPerm1 = x.getTotal().intValue();
        StringArrayList permS1 = new StringArrayList(numPerm1);
        StringBuffer newPermutation = new StringBuffer();
        while (x.hasMore()) {
            indices = x.getNext();
            newPermutation.setLength(0);
            for (i = 0; i < indices.length - 1; ++i) {
                newPermutation.append(tokensS1[indices[i]]);
                newPermutation.append(" ");
            }
            newPermutation.append(tokensS1[indices[i]]);
            permS1.add(newPermutation.toString());
        }
        x = new PermutationGenerator(lenST2);
        int numPerm2 = x.getTotal().intValue();
        StringArrayList permS2 = new StringArrayList(numPerm2);
        while (x.hasMore()) {
            indices = x.getNext();
            newPermutation.setLength(0);
            for (i = 0; i < indices.length - 1; ++i) {
                newPermutation.append(tokensS2[indices[i]]);
                newPermutation.append(" ");
            }
            newPermutation.append(tokensS2[indices[i]]);
            permS2.add(newPermutation.toString());
        }
        float min = 1.0f;
        for (i = 0; i < numPerm1; ++i) {
            for (int j = 0; j < numPerm2; ++j) {
                float currentVal = this.distanceMetric.getDistance(permS1.get(i), permS2.get(j));
                if (currentVal < min) {
                    min = currentVal;
                }
                if (min != 0.0f) continue;
                return min;
            }
        }
        return min;
    }

    @Override
    public String getName() {
        return "PermutedTokens";
    }

    @Override
    public void setProperties(Properties props) {
        String metric = props.getProperty("METRIC");
        if (metric != null) {
            try {
                AbstractDistanceMetric newDistanceMetric = AbstractDistanceMetric.getInstance(metric);
                if (newDistanceMetric != null) {
                    this.distanceMetric = newDistanceMetric;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.distanceMetric.setProperties(props);
    }

    @Override
    public String getConfiguration() {
        String metricName = this.distanceMetric.getClass().getName();
        return this.getClass().getName() + ": INTERNAL_METRIC:" + metricName + " CONF:" + this.distanceMetric.getConfiguration();
    }
}

