/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class Qgrams
extends AbstractDistanceMetric {
    private int q = 3;
    private char STARTPADDING = (char)35;
    private char ENDPADDING = (char)36;

    private String[] getQGRAMS(String input) {
        int i;
        int lenInput = input.length();
        int aStringLen = lenInput + 2 * (this.q - 1);
        int QgramLen = lenInput + this.q - 1;
        String[] Qgrams2 = new String[QgramLen];
        char[] aString = new char[aStringLen];
        for (i = 0; i < this.q - 1; ++i) {
            aString[i] = this.STARTPADDING;
        }
        for (i = 0; i < lenInput; ++i) {
            aString[this.q - 1 + i] = input.charAt(i);
        }
        for (i = this.q - 1 + lenInput; i < aStringLen; ++i) {
            aString[i] = this.ENDPADDING;
        }
        for (int curPos = 0; curPos < QgramLen; ++curPos) {
            Qgrams2[curPos] = new String(aString, curPos, this.q);
        }
        return Qgrams2;
    }

    @Override
    public float getDistance(String s1, String s2) {
        String[] Qgrams1 = this.getQGRAMS(s1);
        String[] Qgrams2 = this.getQGRAMS(s2);
        int lenQgrams1 = Qgrams1.length;
        int lenQgrams2 = Qgrams2.length;
        boolean[] matched = new boolean[lenQgrams2];
        Arrays.fill(matched, false);
        int inCommon = 0;
        block0: for (int i = 0; i < lenQgrams1; ++i) {
            String current = Qgrams1[i];
            for (int j = 0; j < lenQgrams2; ++j) {
                String comparedWith;
                if (matched[j] || current.compareTo(comparedWith = Qgrams2[j]) != 0) continue;
                matched[j] = true;
                ++inCommon;
                continue block0;
            }
        }
        int maxNumQgrams = Math.max(lenQgrams1, lenQgrams2);
        return 1.0f - (float)inCommon / (float)maxNumQgrams;
    }

    @Override
    public String getName() {
        return "Qgrams";
    }

    @Override
    public void setProperties(Properties props) {
        String q = props.getProperty("Q");
        String startpadding = props.getProperty("STARTPADDING");
        String endpadding = props.getProperty("ENDPADDING");
        if (q != null) {
            try {
                int qVal = Integer.parseInt(q);
                if (qVal > 0) {
                    this.q = qVal;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (startpadding != null && startpadding.length() == 1) {
            this.STARTPADDING = startpadding.charAt(0);
        }
        if (endpadding != null && endpadding.length() == 1) {
            this.ENDPADDING = endpadding.charAt(0);
        }
    }

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": Q:" + this.q + " STARTPADDING:" + this.STARTPADDING + " ENDPADDING:" + this.ENDPADDING;
    }
}

