/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint;

import it.jrc.osint.ContentType;
import java.util.HashMap;
import java.util.Map;

public class ContentTypes {
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String APPLICATION_OSINT_META_FILE = "application/x-osint-meta";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String APPLICATION_EXCEL = "application/vnd.ms-excel";
    public static final String APPLICATION_POWERPOINT = "application/vnd.ms-powerpoint";
    public static final String APPLICATION_OFFICE_OPEN_XML_DOC = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String APPLICATION_OFFICE_OPEN_XML_EXCEL = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String APPLICATION_OFFICE_OPEN_XML_POWERPOINT = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String APPLICATION_OPEN_DOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
    public static final String APPLICATION_OPEN_DOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String APPLICATION_OPEN_DOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
    public static final ContentType TEXT = new ContentType("text/plain", new String[]{"txt"}, false);
    public static final ContentType HTML = new ContentType("text/html", new String[]{"html", "htm"}, false);
    public static final ContentType PDF = new ContentType("application/pdf", new String[]{"pdf"}, true);
    public static final ContentType OSINT_META_FILE = new ContentType("application/x-osint-meta", new String[]{"osd"}, false);
    public static final ContentType XML = new ContentType("application/xml", new String[]{"xml"}, false);
    public static final ContentType MSWORD = new ContentType("application/msword", new String[]{"doc", "dot"}, true);
    public static final ContentType EXCEL = new ContentType("application/vnd.ms-excel", new String[]{"xls", "xlm", "xla", "xlc", "xlt", "xlw", "xll", "xld"}, true);
    public static final ContentType POWERPOINT = new ContentType("application/vnd.ms-powerpoint", new String[]{"ppt", "ppz", "pps", "pot", "ppa"}, true);
    public static final ContentType OFFICE_OPEN_XML_DOC = new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document", new String[]{"docx"}, true);
    public static final ContentType OFFICE_OPEN_XML_EXCEL = new ContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", new String[]{"xlsx"}, true);
    public static final ContentType OFFICE_OPEN_XML_POWERPOINT = new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation", new String[]{"pptx", "thmx"}, true);
    public static final ContentType OPEN_DOCUMENT_TEXT = new ContentType("application/vnd.oasis.opendocument.text", new String[]{"odt"}, true);
    public static final ContentType OPEN_DOCUMENT_SPREADSHEET = new ContentType("application/vnd.oasis.opendocument.spreadsheet", new String[]{"ods"}, true);
    public static final ContentType OPEN_DOCUMENT_PRESENTATION = new ContentType("application/vnd.oasis.opendocument.presentation", new String[]{"odp"}, true);
    private static Map<String, ContentType> extensionMap = new HashMap<String, ContentType>();
    private static Map<String, ContentType> mimeMap = new HashMap<String, ContentType>();

    static {
        ContentTypes.register(TEXT);
        ContentTypes.register(HTML);
        ContentTypes.register(PDF);
        ContentTypes.register(XML);
        ContentTypes.register(OSINT_META_FILE);
        ContentTypes.register(MSWORD);
        ContentTypes.register(EXCEL);
        ContentTypes.register(POWERPOINT);
        ContentTypes.register(OFFICE_OPEN_XML_DOC);
        ContentTypes.register(OFFICE_OPEN_XML_EXCEL);
        ContentTypes.register(OFFICE_OPEN_XML_POWERPOINT);
        ContentTypes.register(OPEN_DOCUMENT_TEXT);
        ContentTypes.register(OPEN_DOCUMENT_SPREADSHEET);
        ContentTypes.register(OPEN_DOCUMENT_PRESENTATION);
    }

    private static void register(ContentType aType) {
        String[] extensions;
        String[] stringArray = extensions = aType.getFileExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensionMap.put(ext, aType);
            ++n2;
        }
        mimeMap.put(aType.getMimeType(), aType);
    }

    public static boolean containsFileExtension(String fileExtension) {
        return extensionMap.containsKey(fileExtension);
    }

    public static ContentType getContentTypeByFileExtension(String fileExtension) {
        return extensionMap.get(fileExtension);
    }

    public static ContentType getContentTypeByMimeType(String mimeType) {
        return mimeMap.get(mimeType);
    }
}

