/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.operations;

import it.jrc.osint.operations.ErrorCondition;
import java.util.HashMap;
import java.util.Map;

public class ErrorConditionCatalog {
    private Map<String, ErrorConditionTemplate> errorConditionTemplates = new HashMap<String, ErrorConditionTemplate>();
    private int baseErrorCode;
    private static final String CONTACT_SUPPORT = "Please use Help > Report Bug or Enhancement to contact support.";

    public ErrorConditionCatalog(int baseErrorCode) {
        this.baseErrorCode = baseErrorCode;
    }

    protected void register(String key, int errorCode, String errorMessage, String errorSolution) {
        ErrorConditionTemplate newTemplate = new ErrorConditionTemplate();
        newTemplate.errorCode = errorCode;
        newTemplate.errorMessage = errorMessage;
        newTemplate.solution = errorSolution;
        this.errorConditionTemplates.put(key, newTemplate);
    }

    protected void registerErrorCondition(String key, String errorMessage) {
        this.register(key, this.baseErrorCode++, errorMessage, CONTACT_SUPPORT);
    }

    protected void registerErrorCondition(String key, String errorMessage, String errorSolution) {
        this.register(key, this.baseErrorCode++, errorMessage, errorSolution);
    }

    public ErrorCondition getErrorCondition(String key) {
        ErrorConditionTemplate template = this.errorConditionTemplates.get(key);
        ErrorCondition newCondition = new ErrorCondition(template.errorCode, template.errorMessage, template.solution);
        return newCondition;
    }

    public ErrorCondition getErrorCondition(String key, Throwable t) {
        ErrorConditionTemplate template = this.errorConditionTemplates.get(key);
        ErrorCondition newCondition = new ErrorCondition(template.errorCode, template.errorMessage, template.solution, t);
        return newCondition;
    }

    private static class ErrorConditionTemplate {
        int errorCode;
        String errorMessage;
        String solution;

        private ErrorConditionTemplate() {
        }
    }
}

