/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.rcp;

import it.jrc.osint.logging.LoggingPlugin;
import it.jrc.osint.rcp.PickWorkspaceDialog;
import it.jrc.osint.ui.ApplicationWorkbenchAdvisor;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class OSINTApplication
implements IApplication {
    public Object start(IApplicationContext context) {
        Display display = null;
        try {
            display = PlatformUI.createDisplay();
            Location instanceLoc = Platform.getInstanceLocation();
            URL defaultURL = instanceLoc.getURL();
            if (defaultURL == null) {
                String ret;
                boolean remember = PickWorkspaceDialog.isRememberWorkspace();
                String lastUsedWs = PickWorkspaceDialog.getLastSetWorkspaceDirectory();
                if (remember && (lastUsedWs == null || lastUsedWs.length() == 0)) {
                    remember = false;
                }
                if (remember && (ret = PickWorkspaceDialog.checkWorkspaceDirectory(Display.getDefault().getActiveShell(), lastUsedWs, false, false)) != null) {
                    remember = false;
                }
                if (!remember) {
                    PickWorkspaceDialog pwd = new PickWorkspaceDialog(false, null);
                    int pick = pwd.open();
                    if (pick == 1) {
                        if (pwd.getSelectedWorkspaceLocation() == null) {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)"The application can not start without a workspace root and will now exit.");
                            try {
                                PlatformUI.getWorkbench().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            System.exit(0);
                            Integer n = IApplication.EXIT_OK;
                            return n;
                        }
                    } else {
                        instanceLoc.set(new URL("file", null, pwd.getSelectedWorkspaceLocation()), false);
                        if (!instanceLoc.lock()) {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)"The selected workspace is already in use by another instance of the application. Please shut down all instances and try again.");
                            Integer n = IApplication.EXIT_OK;
                            return n;
                        }
                    }
                } else {
                    instanceLoc.set(new URL("file", null, lastUsedWs), false);
                    if (!instanceLoc.lock()) {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)"The selected workspace is already in use by another instance of the application. Please shut down all instances and try again.");
                        Integer n = IApplication.EXIT_OK;
                        return n;
                    }
                }
            } else {
                System.out.println("Set -data @noDefault program argument to use workspace chooser");
            }
            LoggingPlugin.getPlugin().startWorkspaceLogging();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    public void stop() {
        IWorkbench workbench;
        Location instanceLocation = Platform.getInstanceLocation();
        if (instanceLocation != null) {
            instanceLocation.release();
        }
        if ((workbench = PlatformUI.getWorkbench()) == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

