/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.rcp;

import it.jrc.osint.rcp.OSINTPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PickWorkspaceDialog
extends TitleAreaDialog {
    public static final String WS_IDENTIFIER = ".osint_workspace";
    private static final String _KeyWorkspaceRootDir = "wsRootDir";
    private static final String _KeyRememberWorkspace = "wsRemember";
    private static final String _KeyLastUsedWorkspaces = "wsLastUsedWorkspaces";
    private static Preferences _preferences = Preferences.userNodeForPackage(PickWorkspaceDialog.class);
    private static final String _StrMsg = "Your workspace is where your user data will be stored.";
    private static final String _StrInfo = "Please select a directory that will be the workspace root";
    private static final String _StrError = "You must set a directory";
    private Combo _workspacePathCombo;
    private List<String> _lastUsedWorkspaces;
    private Button _RememberWorkspaceButton;
    private static final String _SplitChar = "#";
    private static final int _MaxHistory = 20;
    private boolean _switchWorkspace;
    private String _selectedWorkspaceRootLocation;

    public PickWorkspaceDialog(boolean switchWorkspace, Image wizardImage) {
        super(Display.getDefault().getActiveShell());
        this._switchWorkspace = switchWorkspace;
        if (wizardImage != null) {
            this.setTitleImage(wizardImage);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this._switchWorkspace) {
            newShell.setText("Switch Workspace");
        } else {
            newShell.setText("Workspace Selection");
        }
    }

    public static boolean isRememberWorkspace() {
        return _preferences.getBoolean(_KeyRememberWorkspace, false);
    }

    public static String getLastSetWorkspaceDirectory() {
        return _preferences.get(_KeyWorkspaceRootDir, null);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Choose Workspace Directory");
        this.setMessage(_StrMsg);
        try {
            Composite inner = new Composite(parent, 0);
            GridLayout gl_inner = new GridLayout();
            gl_inner.numColumns = 2;
            inner.setLayout((Layout)gl_inner);
            GridData innerGridData = new GridData(4, 4, true, true);
            inner.setLayoutData((Object)innerGridData);
            CLabel label = new CLabel(inner, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            label.setText("Workspace Root Path");
            this._workspacePathCombo = new Combo(inner, 2048);
            GridData gd__workspacePathCombo = new GridData(4, 0x1000000, true, false, 1, 1);
            gd__workspacePathCombo.widthHint = 400;
            this._workspacePathCombo.setLayoutData((Object)gd__workspacePathCombo);
            String wsRoot = _preferences.get(_KeyWorkspaceRootDir, "");
            if (wsRoot == null || wsRoot.length() == 0) {
                wsRoot = this.getWorkspacePathSuggestion();
            }
            this._workspacePathCombo.setText(wsRoot == null ? "" : wsRoot);
            Button browse = new Button(inner, 8);
            browse.setText("Browse...");
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DirectoryDialog dd = new DirectoryDialog(PickWorkspaceDialog.this.getParentShell());
                    dd.setText("Select Workspace Root");
                    dd.setMessage(PickWorkspaceDialog._StrInfo);
                    dd.setFilterPath(PickWorkspaceDialog.this._workspacePathCombo.getText());
                    String pick = dd.open();
                    if (pick == null && PickWorkspaceDialog.this._workspacePathCombo.getText().length() == 0) {
                        PickWorkspaceDialog.this.setMessage(PickWorkspaceDialog._StrError, 3);
                    } else {
                        PickWorkspaceDialog.this.setMessage(PickWorkspaceDialog._StrMsg);
                        PickWorkspaceDialog.this._workspacePathCombo.setText(pick);
                    }
                }
            });
            this._RememberWorkspaceButton = new Button(inner, 32);
            this._RememberWorkspaceButton.setText("Remember workspace");
            this._RememberWorkspaceButton.setSelection(_preferences.getBoolean(_KeyRememberWorkspace, false));
            String lastUsed = _preferences.get(_KeyLastUsedWorkspaces, "");
            this._lastUsedWorkspaces = new ArrayList<String>();
            if (lastUsed != null) {
                String[] all;
                String[] stringArray = all = lastUsed.split(_SplitChar);
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    this._lastUsedWorkspaces.add(str);
                    ++n2;
                }
            }
            for (String last : this._lastUsedWorkspaces) {
                this._workspacePathCombo.add(last);
            }
            new Label(inner, 0);
            return inner;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public String getSelectedWorkspaceLocation() {
        return this._selectedWorkspaceRootLocation;
    }

    private String getWorkspacePathSuggestion() {
        StringBuffer buf = new StringBuffer();
        String uHome = System.getProperty("user.home");
        if (uHome == null) {
            uHome = "c:" + File.separator + "temp";
        }
        buf.append(uHome);
        buf.append(File.separator);
        buf.append("osint-workspace");
        return buf.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("Can not find source: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Cannot read: " + src.getAbsolutePath() + ". Check file permissions.");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Could not create direcotry: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                PickWorkspaceDialog.copyFiles(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException("Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath());
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
    }

    protected void okPressed() {
        int i;
        String str = this._workspacePathCombo.getText();
        if (str.length() == 0) {
            this.setMessage(_StrError, 3);
            return;
        }
        String ret = PickWorkspaceDialog.checkWorkspaceDirectory(this.getParentShell(), str, true, true);
        if (ret != null) {
            this.setMessage(ret, 3);
            return;
        }
        this._lastUsedWorkspaces.remove(str);
        if (!this._lastUsedWorkspaces.contains(str)) {
            this._lastUsedWorkspaces.add(0, str);
        }
        if (this._lastUsedWorkspaces.size() > 20) {
            ArrayList<String> remove = new ArrayList<String>();
            i = 20;
            while (i < this._lastUsedWorkspaces.size()) {
                remove.add(this._lastUsedWorkspaces.get(i));
                ++i;
            }
            this._lastUsedWorkspaces.removeAll(remove);
        }
        StringBuffer buf = new StringBuffer();
        i = 0;
        while (i < this._lastUsedWorkspaces.size()) {
            buf.append(this._lastUsedWorkspaces.get(i));
            if (i != this._lastUsedWorkspaces.size() - 1) {
                buf.append(_SplitChar);
            }
            ++i;
        }
        _preferences.putBoolean(_KeyRememberWorkspace, this._RememberWorkspaceButton.getSelection());
        _preferences.put(_KeyLastUsedWorkspaces, buf.toString());
        boolean ok = PickWorkspaceDialog.checkAndCreateWorkspaceRoot(str);
        if (!ok) {
            this.setMessage("The workspace could not be created, please check the error log");
            return;
        }
        this._selectedWorkspaceRootLocation = str;
        _preferences.put(_KeyWorkspaceRootDir, str);
        super.okPressed();
    }

    public static String checkWorkspaceDirectory(Shell parentShell, String workspaceLocation, boolean askCreate, boolean fromDialog) {
        File wsDot;
        File f = new File(workspaceLocation);
        if (!f.exists() && askCreate) {
            boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)"New Directory", (String)"The directory does not exist. Would you like to create it?");
            if (create) {
                try {
                    f.mkdirs();
                    wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                    wsDot.createNewFile();
                }
                catch (Exception err) {
                    return "Error creating directories, please check folder permissions";
                }
            }
            if (!f.exists()) {
                return "The selected directory does not exist";
            }
        }
        if (!f.canRead()) {
            return "The selected directory is not readable";
        }
        if (!f.isDirectory()) {
            return "The selected path is not a directory";
        }
        File wsTest = new File(workspaceLocation);
        if (fromDialog) {
            if (!wsTest.exists()) {
                boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)"New Workspace", (String)("The directory '" + wsTest.getAbsolutePath() + "' will be used as a new workspace folder. Your case projects will be created directly under the specified directory. \n\nWould you like to create a workspace in the selected location?"));
                if (create) {
                    try {
                        f.mkdirs();
                        File wsDot2 = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                        wsDot2.createNewFile();
                    }
                    catch (Exception err) {
                        return "Error creating directories, please check folder permissions";
                    }
                } else {
                    return "Please select a directory for your workspace";
                }
                if (!wsTest.exists()) {
                    return "The selected directory does not exist";
                }
                return null;
            }
        } else {
            wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
            if (!wsDot.exists()) {
                return "The selected directory is not a workspace directory";
            }
        }
        return null;
    }

    public static boolean checkAndCreateWorkspaceRoot(String wsRoot) {
        block3: {
            try {
                File fRoot = new File(wsRoot);
                if (fRoot.exists()) break block3;
                return false;
            }
            catch (Throwable t) {
                OSINTPlugin.getPlugin().getLog().log((IStatus)new Status(4, "it.jrc.osint.rcp", "Failed to check workspace root", t));
                return false;
            }
        }
        String versionFilePath = String.valueOf(wsRoot) + File.separator + WS_IDENTIFIER;
        Properties prop = new Properties();
        prop.setProperty("workspaceVersion", OSINTPlugin.getVersion());
        return PickWorkspaceDialog.writeVersionFile(versionFilePath, prop);
    }

    private static boolean writeVersionFile(String filePath, Properties properties) {
        FileOutputStream fileOut = null;
        OutputStreamWriter streamWriter = null;
        try {
            fileOut = new FileOutputStream(filePath);
            streamWriter = new OutputStreamWriter((OutputStream)fileOut, "utf-8");
            properties.store(streamWriter, "Workspace Version");
            streamWriter.flush();
            return true;
        }
        catch (Throwable t) {
            OSINTPlugin.getPlugin().getLog().log((IStatus)new Status(4, "it.jrc.osint.rcp", "Failed to write workspace version file", t));
        }
        finally {
            try {
                if (streamWriter != null) {
                    streamWriter.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }
}

