/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.grabber;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class GrabberServicePreferences {
    public static final String P_MAX_PARALLEL_THREADS = "maxParallelThreads";
    public static final String P_MINIMUM_RANDOM_DELAY_MS = "minRandomDelayMs";
    public static final String P_HTTP_TIMEOUT_MS = "httpTimeoutMs";
    private static final String P_INSTANCE_SCOPE_INITIALISED = "instanceScopeInitialised";
    private static final int DEFAULT_MAX_PARALLEL_THREADS = 20;
    private static final int DEFAULT_MINIMUM_RANDOM_DELAY_MS = 0;
    private static final int DEFAULT_HTTP_TIMEOUT_MS = 30000;
    private String pluginId;

    public GrabberServicePreferences(String pluginId) {
        this.pluginId = pluginId;
    }

    public void init() {
        if (!this.getInstanceScopePrefs().getBoolean(P_INSTANCE_SCOPE_INITIALISED, false)) {
            this.init(this.getInstanceScopePrefs());
        }
        this.init(DefaultScope.INSTANCE.getNode(this.pluginId));
    }

    public int getMaxParallelThreads() {
        return this.getInstanceScopePrefs().getInt(P_MAX_PARALLEL_THREADS, 20);
    }

    public int getMinimumRandomDelayMs() {
        return this.getInstanceScopePrefs().getInt(P_MINIMUM_RANDOM_DELAY_MS, 0);
    }

    public int getHttpTimeoutMs() {
        return this.getInstanceScopePrefs().getInt(P_HTTP_TIMEOUT_MS, 30000);
    }

    private void init(IEclipsePreferences pluginPrefs) {
        pluginPrefs.putBoolean(P_INSTANCE_SCOPE_INITIALISED, true);
        pluginPrefs.putInt(P_MAX_PARALLEL_THREADS, 20);
        pluginPrefs.putInt(P_MINIMUM_RANDOM_DELAY_MS, 0);
        pluginPrefs.putInt(P_HTTP_TIMEOUT_MS, 30000);
    }

    private IEclipsePreferences getInstanceScopePrefs() {
        return InstanceScope.INSTANCE.getNode(this.pluginId);
    }
}

