/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.Language;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Combo;

public class ComboViewers {
    public static ComboViewer createEntityTypeComboViewer(Combo list) {
        ComboViewer viewer = new ComboViewer(list);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        viewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        return viewer;
    }

    public static ComboViewer createLanguageComboViewer(Combo list) {
        ComboViewer viewer = new ComboViewer(list);
        viewer.setContentProvider((IContentProvider)new LanguageTypeContentProviderImpl());
        viewer.setLabelProvider((IBaseLabelProvider)new LanguageTypeLabelProviderImpl());
        return viewer;
    }

    private static class ContentProviderImpl
    extends StructuredContentProviderAdapter {
        private ContentProviderImpl() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof List) {
                List typesList = (List)input;
                return typesList.toArray(new EntityType[0]);
            }
            return super.getElements(input);
        }
    }

    private static class LabelProviderImpl
    extends LabelProviderAdapter {
        private LabelProviderImpl() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof EntityType) {
                EntityType et = (EntityType)element;
                return et.getName();
            }
            return element.toString();
        }
    }

    private static class LanguageTypeContentProviderImpl
    extends StructuredContentProviderAdapter {
        private LanguageTypeContentProviderImpl() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof List) {
                List typesList = (List)input;
                return typesList.toArray(new Language[0]);
            }
            return super.getElements(input);
        }
    }

    private static class LanguageTypeLabelProviderImpl
    extends LabelProviderAdapter {
        private LanguageTypeLabelProviderImpl() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof Language) {
                Language lt = (Language)element;
                return lt.getName();
            }
            return element.toString();
        }
    }
}

