/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.console.Console;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.NameVariantDatabase;
import it.jrc.osint.extract.NameVariantProfile;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.extract.ui.dialog.EditProfileController;
import it.jrc.osint.extract.ui.dialog.SearchProfileDialog;
import it.jrc.osint.extract.ui.dialog.SearchProfileModel;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationContext;
import it.jrc.osint.operations.OperationStatus;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.swt.widgets.Shell;

public class SearchProfileController {
    private static final Logger log = LogManager.getLogger((String)SearchProfileController.class.getName());
    private NameVariantDatabase nvdb;
    private Console console;
    private SearchProfileDialog view;
    private SearchProfileModel model;

    public SearchProfileController(NameVariantDatabase em, Console console) {
        this.nvdb = em;
        this.console = console;
        this.model = new SearchProfileModel();
    }

    public int openView(Shell parentShell) {
        if (this.view == null) {
            this.view = new SearchProfileDialog(parentShell, this);
        }
        return this.view.open();
    }

    protected SearchProfileDialog getView() {
        return this.view;
    }

    protected SearchProfileModel getModel() {
        return this.model;
    }

    synchronized void performSearch() {
        this.view.disableSearchButton();
        this.view.setVariantsTableInput("Loading name variants...");
        this.view.setNameVariantProfileTableInput(new Object[0]);
        this.view.disableEditButton();
        this.view.disableDeleteButton();
        this.view.disableOkButton();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                NameVariantDatabase em = ExtractUIPlugin.getNameVariantDatabase();
                List foundNameVariants = em.findNameVariantsByPattern(SearchProfileController.this.model.getSearchPattern());
                SearchProfileController.this.model.setNameVariants(foundNameVariants);
                SearchProfileController.this.view.setVariantsTableInput(foundNameVariants);
                if (foundNameVariants.isEmpty()) {
                    SearchProfileController.this.view.showEmptyResultDialog();
                }
                SearchProfileController.this.view.enableSearchButton();
            }
        });
    }

    void selectNameVariant(NameVariant selectedVariant) {
        this.model.setSelectedNameVariant(selectedVariant);
        long profileId = this.model.getSelectedNameVariant().getProfileId();
        NameVariantProfile nvp = this.nvdb.findNameVariantProfile(profileId);
        this.view.setNameVariantProfileTableInput(nvp);
        this.view.enableOkButton();
        this.view.enableEditButton();
        this.view.enableDeleteButton();
    }

    NameVariant getSelectedNameVariant() {
        return this.model.getSelectedNameVariant();
    }

    public void setSearchPattern(String pattern) {
        this.model.setSearchPattern(pattern);
    }

    public String getSearchPattern() {
        return this.model.getSearchPattern();
    }

    List<EntityType> getEntityTypes() {
        if (this.model.getEntityTypes() == null) {
            ExtractionService es = ExtractUIPlugin.getExtractionService();
            List types = es.getEntityTypes();
            this.model.setEntityTypes(types);
        }
        return this.model.getEntityTypes();
    }

    public void setFilterEntityType(EntityType entityType) {
        this.model.setFilterEntityType(entityType);
        this.view.applyEntityTypeFilter(entityType);
    }

    public EntityType getFilterEntityType() {
        return this.model.getFilterEntityType();
    }

    void deselectNameVariant() {
        this.view.disableDeleteButton();
        this.view.disableEditButton();
        this.view.disableOkButton();
    }

    void onViewCreation() {
        this.view.disableOkButton();
        this.view.disableDeleteButton();
        this.view.disableEditButton();
        this.view.setEntityTypeFilter(EntityType.NULL_TYPE);
    }

    void openEditExistingProfileDialog() {
        NameVariant selectedVariant = this.model.getSelectedNameVariant();
        NameVariantProfile nvp = this.nvdb.findNameVariantProfile(selectedVariant.getProfileId());
        OperationContext operationContext = this.nvdb.createOperationContext();
        EditProfileController editProfileController = new EditProfileController(this.nvdb);
        editProfileController.editExistingProfile(nvp, operationContext);
        Shell parentShell = this.view.getShell();
        int result = editProfileController.openView(parentShell);
        if (result == 0) {
            this.nvdb.executeOperations(operationContext);
            this.view.refreshVariantsTableViewer();
            this.view.refreshProfileTableViewer();
        }
    }

    void openEditNewProfileDialog() {
        OperationContext operationContext = this.nvdb.createOperationContext();
        EditProfileController editProfileController = new EditProfileController(this.nvdb);
        editProfileController.editNewProfile(operationContext);
        Shell parentShell = this.view.getShell();
        int result = editProfileController.openView(parentShell);
        if (result == 0) {
            this.nvdb.executeOperations(operationContext);
            this.view.refreshVariantsTableViewer();
            this.view.refreshProfileTableViewer();
            this.view.enableOkButton();
        }
    }

    void deleteProfile() {
        NameVariant nv = this.model.getSelectedNameVariant();
        NameVariantProfile profile = this.nvdb.findNameVariantProfile(nv.getProfileId());
        if (this.view.showConfirmationDialog("Do you want to delete profile " + profile.getName() + " and all its variants?")) {
            OperationStatus status = this.nvdb.deleteNameVariantProfile(profile);
            if (status.isOK()) {
                this.console.info("Deleted Name Variant Profile " + profile.getName() + " from name variants");
            } else {
                this.console.error("Failed to delete Name Variant Profile " + profile.getName() + " Cause: " + status.getException());
            }
        }
    }

    void onCancelDialog() {
    }
}

