/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.view;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import it.jrc.osint.extract.ui.view.TestRegexView;
import it.jrc.osint.extract.ui.view.TestRegexViewModel;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.ui.IMemento;

public class TestRegexViewController {
    private static final String MK_EXPRESSION = "regExpression";
    private static final String MK_INPUT_TEXT = "inputText";
    private static final String MK_REGEX_MODE = "regexMode";
    private TestRegexView view;
    private TestRegexViewModel model;

    public TestRegexViewController(TestRegexView view) {
        this.view = view;
        this.model = new TestRegexViewModel();
    }

    public void expressionEdited(String newExpression) {
        this.model.setExpression(newExpression);
    }

    public void inputTextEdited(String newText) {
        this.model.setInputText(newText);
    }

    public String getInputText() {
        return this.model.getInputText();
    }

    public String getExpression() {
        return this.model.getExpression();
    }

    public void matchExpression() {
        if (this.model.getRegexMode().equals((Object)TestRegexViewModel.RegexMode.BRICS)) {
            this.matchExpressionBricsRegex();
        } else {
            this.matchExpressionJavaRegex();
        }
    }

    public void matchExpressionJavaRegex() {
        if (this.model.getExpression() == null || "".equals(this.model.getExpression())) {
            this.view.showErrorMessage("No regular expression: Please enter a regular expression");
            return;
        }
        if (this.model.getInputText() == null || "".equals(this.model.getInputText())) {
            this.view.showErrorMessage("No text to match: Please enter a text to be matched");
            return;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.model.getExpression());
        }
        catch (PatternSyntaxException e) {
            this.view.showErrorMessage("Expression invalid: " + e.getDescription());
            return;
        }
        Matcher matcher = pattern.matcher(this.getInputText());
        StringBuffer matchResult = new StringBuffer();
        while (matcher.find()) {
            MatchResult mr = matcher.toMatchResult();
            this.appendMatchResult(matchResult, mr);
        }
        this.view.showMatchResult(matchResult.toString());
    }

    public void matchExpressionBricsRegex() {
        if (this.model.getExpression() == null || "".equals(this.model.getExpression())) {
            this.view.showErrorMessage("No regular expression: Please enter a regular expression");
            return;
        }
        if (this.model.getInputText() == null || "".equals(this.model.getInputText())) {
            this.view.showErrorMessage("No text to match: Please enter a text to be matched");
            return;
        }
        Automaton a = null;
        try {
            RegExp r = new RegExp(this.model.getExpression());
            a = r.toAutomaton();
        }
        catch (Throwable t) {
            this.view.showErrorMessage("Failed to compile expression: " + t.getMessage());
            return;
        }
        RunAutomaton ram = new RunAutomaton(a);
        AutomatonMatcher am = ram.newMatcher((CharSequence)this.model.getInputText());
        StringBuffer matchResult = new StringBuffer();
        while (am.find()) {
            MatchResult mr = am.toMatchResult();
            this.appendMatchResult(matchResult, mr);
        }
        this.view.showMatchResult(matchResult.toString());
    }

    private void appendMatchResult(StringBuffer foundMatches, MatchResult result) {
        int matchStart = result.start();
        int matchEnd = result.end();
        String foundMatch = this.model.getInputText().substring(matchStart, matchEnd);
        foundMatches.append(foundMatch);
        foundMatches.append("\n");
    }

    public void onPartOpened() {
        this.refreshView();
    }

    private void refreshView() {
        this.view.performRefresh();
    }

    public void init(IMemento memento) {
        String regexMode;
        String inputText;
        if (memento == null) {
            return;
        }
        String expression = memento.getString(MK_EXPRESSION);
        if (expression != null) {
            this.model.setExpression(expression);
        }
        if ((inputText = memento.getString(MK_INPUT_TEXT)) != null) {
            this.model.setInputText(inputText);
        }
        if ((regexMode = memento.getString(MK_REGEX_MODE)) != null) {
            this.model.setRegexMode(TestRegexViewModel.RegexMode.valueOf(regexMode));
        }
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.model.getExpression() != null) {
            memento.putString(MK_EXPRESSION, this.model.getExpression());
        } else {
            memento.putString(MK_EXPRESSION, null);
        }
        if (this.model.getInputText() != null) {
            memento.putString(MK_INPUT_TEXT, this.model.getInputText());
        } else {
            memento.putString(MK_INPUT_TEXT, null);
        }
        memento.putString(MK_REGEX_MODE, this.model.getRegexMode().name());
    }

    public void onPartClosed() {
    }

    public void selectBricsRegexMode() {
        this.model.setRegexMode(TestRegexViewModel.RegexMode.BRICS);
    }

    public void selectJavaRegexMode() {
        this.model.setRegexMode(TestRegexViewModel.RegexMode.JAVA);
    }

    public TestRegexViewModel.RegexMode getRegexMode() {
        return this.model.getRegexMode();
    }
}

