/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.wizard;

import it.jrc.osint.console.OSINTConsolePlugin;
import it.jrc.osint.extract.ImportProgressListener;
import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageController;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class NameVariantDatabaseImportWizard
extends Wizard
implements IImportWizard {
    private static final Logger log = LogManager.getLogger((String)NameVariantDatabaseImportWizard.class.getName());
    private IStructuredSelection selection;
    private SelectFileWizardPageController selectFileController;

    public void addPages() {
        super.addPages();
        this.selectFileController = new SelectFileWizardPageController();
        this.selectFileController.setPageTitle("Select file for import");
        this.selectFileController.setPageDescription("Select file to import database from");
        this.addPage(this.selectFileController.getView());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        if (this.selectFileController.hasFilePath()) {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)new ImportDatabaseRunnable(this.selectFileController.getFilePath()));
            }
            catch (Throwable t) {
                log.error("Failed to execute runnable", t);
            }
            return true;
        }
        return false;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    String getFilePath() {
        return this.selectFileController.getFilePath();
    }

    private class ImportDatabaseRunnable
    implements IRunnableWithProgress,
    ImportProgressListener {
        private String importPath;
        private IProgressMonitor monitor;
        private int reportedProgress = 0;

        public ImportDatabaseRunnable(String importPath) {
            this.importPath = importPath;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            try {
                this.monitor.beginTask("Importing data", 100);
                ExtractUIPlugin.getExtractionService().importDatabase(this.importPath, (ImportProgressListener)this);
            }
            finally {
                this.monitor.done();
            }
        }

        public void statusMessage(String aMessage) {
            if (aMessage != null) {
                OSINTConsolePlugin.getConsole().info(aMessage);
            }
        }

        public void monitorProgress(Double completionPercentage) {
            if (this.monitor == null || completionPercentage == null) {
                return;
            }
            int worked = 1;
            try {
                double totalItemsWorked = 100.0 * completionPercentage;
                worked = new Double(totalItemsWorked).intValue() - this.reportedProgress;
                this.reportedProgress += worked;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.monitor.worked(worked);
        }

        public void finished(OperationStatus status) {
        }
    }
}

