/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.wizard;

import it.jrc.osint.console.OSINTConsolePlugin;
import it.jrc.osint.extract.ImportProgressListener;
import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.extract.ui.wizard.NameVariantDatabaseImportWizard;
import it.jrc.osint.extract.ui.wizard._ProgressStatusWizardPage;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.ui.wizard.WizardPageController;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class _ProgressStatusWizardPageController
extends WizardPageController {
    private static final Logger log = LogManager.getLogger((String)_ProgressStatusWizardPageController.class.getName());
    private _ProgressStatusWizardPage view;
    private boolean importFinished;
    private NameVariantDatabaseImportWizard wizard;

    public _ProgressStatusWizardPageController(NameVariantDatabaseImportWizard wizard) {
        this.wizard = wizard;
    }

    public _ProgressStatusWizardPage getView() {
        if (this.view == null) {
            this.view = new _ProgressStatusWizardPage("Importing data", this);
        }
        return this.view;
    }

    boolean importFinished() {
        return this.importFinished;
    }

    void onVisible() {
        this.view.submit(new ImportDatabaseRunnable(this.wizard.getFilePath()));
    }

    private class ImportDatabaseRunnable
    implements IRunnableWithProgress,
    ImportProgressListener {
        private String importPath;
        private IProgressMonitor monitor;
        private int reportedProgress = 0;

        public ImportDatabaseRunnable(String importPath) {
            this.importPath = importPath;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            try {
                this.monitor.beginTask("Importing data", 100);
                ExtractUIPlugin.getExtractionService().importDatabase(this.importPath, (ImportProgressListener)this);
            }
            finally {
                this.monitor.done();
            }
        }

        public void statusMessage(String aMessage) {
            OSINTConsolePlugin.getConsole().info(aMessage);
        }

        public void monitorProgress(Double completionPercentage) {
            if (this.monitor == null || completionPercentage == null) {
                return;
            }
            int worked = 1;
            try {
                double totalItemsWorked = 100.0 * completionPercentage;
                worked = new Double(totalItemsWorked).intValue() - this.reportedProgress;
                this.reportedProgress += worked;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.monitor.worked(worked);
        }

        public void finished(OperationStatus status) {
            _ProgressStatusWizardPageController.this.importFinished = true;
            _ProgressStatusWizardPageController.this.getView().updateButtons();
        }
    }
}

