/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui;

import it.jrc.osint.analysis.AnalysisPlugin;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.ui.editors.ColorManager;
import it.jrc.osint.analysis.ui.internal.AnalysisUIService;
import it.jrc.osint.extract.ExtractPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.ui.TextStyleRegistry;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AnalysisUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.jrc.osint.analysis.ui";
    public static final String DOCUMENT_IMAGE = "document";
    public static final String DEFAULT_TYPE_IMAGE = "generic-type";
    public static final String HTML_DOCUMENT_IMAGE = "html_document";
    public static final String TXT_DOCUMENT_IMAGE = "txt_document";
    public static final String PDF_DOCUMENT_IMAGE = "pdf_document";
    public static final String FOLDER_IMAGE = "folder";
    public static final String RED_COLOR = "red";
    public static final String BLACK_COLOR = "black";
    private static AnalysisUIPlugin plugin;
    private AnalysisUIService analysisUIService;
    private TextStyleRegistry textStyleRegistry;
    private ColorRegistry colorRegistry;
    private ColorManager colorManager;
    private EventBroker eventBroker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.eventBroker = new EventBroker(context);
        this.analysisUIService = new AnalysisUIService(this.eventBroker);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.analysisUIService != null) {
            this.analysisUIService.stop();
        }
        if (this.textStyleRegistry != null) {
            this.textStyleRegistry.dispose();
        }
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
        plugin = null;
        super.stop(context);
    }

    private void initializeTextStyleRegistry() {
        this.textStyleRegistry = new TextStyleRegistry();
        this.textStyleRegistry.register("p", this.getColor("p"));
        this.textStyleRegistry.register("o", this.getColor("o"));
        this.textStyleRegistry.register("t", this.getColor("t"));
        this.textStyleRegistry.register("ur", this.getColor("ur"));
        this.textStyleRegistry.register("dt", this.getColor("dt"));
        this.textStyleRegistry.register("cc", this.getColor("cc"));
        this.textStyleRegistry.register("pn", this.getColor("pn"));
        this.textStyleRegistry.register("em", this.getColor("em"));
        this.textStyleRegistry.register("zc", this.getColor("zc"));
        this.textStyleRegistry.register("pi", this.getColor("pi"));
    }

    public TextStyleRegistry getTextStyleRegistry() {
        if (this.textStyleRegistry == null) {
            this.initializeTextStyleRegistry();
        }
        return this.textStyleRegistry;
    }

    public Image getImageForEntityTypeId(String typeId) {
        Image img = this.getImageRegistry().get(typeId);
        if (img == null) {
            return AnalysisUIPlugin.getPlugin().getImageRegistry().get(DEFAULT_TYPE_IMAGE);
        }
        return img;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("p", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/user.gif"));
        reg.put("o", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/chart_organisation.gif"));
        reg.put("t", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/house.gif"));
        reg.put("ur", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/link.gif"));
        reg.put("dt", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/calendar.gif"));
        reg.put("cc", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/creditcards.gif"));
        reg.put("pn", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/telephone.gif"));
        reg.put("em", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/email.gif"));
        reg.put("zc", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/house_link.gif"));
        reg.put("pi", AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/vcard.gif"));
        reg.put(DOCUMENT_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/page_white_text.gif"));
        reg.put(DEFAULT_TYPE_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/tag.gif"));
        reg.put(HTML_DOCUMENT_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/html.gif"));
        reg.put(TXT_DOCUMENT_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/page_white_text.gif"));
        reg.put(PDF_DOCUMENT_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/page_white_acrobat.gif"));
        reg.put(FOLDER_IMAGE, AnalysisUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/prj_obj.gif"));
    }

    private void initializeColorRegistry(ColorRegistry reg) {
        reg.put(RED_COLOR, new RGB(255, 0, 0));
        reg.put(BLACK_COLOR, new RGB(0, 0, 0));
        reg.put("p", new RGB(0, 57, 230));
        reg.put("o", new RGB(57, 0, 230));
        reg.put("t", new RGB(172, 0, 230));
        reg.put("ur", new RGB(230, 0, 172));
        reg.put("dt", new RGB(0, 172, 230));
        reg.put("cc", new RGB(36, 91, 255));
        reg.put("pn", new RGB(92, 136, 255));
        reg.put("em", new RGB(230, 0, 57));
        reg.put("zc", new RGB(0, 230, 57));
        reg.put("pi", new RGB(57, 230, 0));
    }

    private ColorRegistry createColorRegistry() {
        if (Display.getCurrent() != null) {
            return new ColorRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    private ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.colorRegistry = this.createColorRegistry();
            this.initializeColorRegistry(this.colorRegistry);
        }
        return this.colorRegistry;
    }

    public Color getColor(String symbolicName) {
        Color result = this.getColorRegistry().get(symbolicName);
        if (result == null) {
            result = this.getColorRegistry().get(BLACK_COLOR);
        }
        return result;
    }

    public synchronized ISharedTextColors getSharedTextColors() {
        if (this.colorManager == null) {
            this.colorManager = new ColorManager();
        }
        return this.colorManager;
    }

    public static AnalysisUIPlugin getPlugin() {
        return plugin;
    }

    public static EventBroker getEventBroker() {
        return AnalysisUIPlugin.getPlugin().eventBroker;
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    public static AnalysisService getAnalysisService() {
        return AnalysisPlugin.getAnalysisService();
    }

    public static ExtractionService getExtractionService() {
        return ExtractPlugin.getExtractionService();
    }
}

