/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.EntityContainer;
import it.jrc.osint.analysis.EntityContainerChangeListener;
import it.jrc.osint.analysis.ui.AnalysisUIEvent;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.editors.DocumentHTMLViewer;
import it.jrc.osint.analysis.ui.editors.DocumentOnlineViewer;
import it.jrc.osint.analysis.ui.editors.DocumentTextViewer;
import it.jrc.osint.analysis.ui.editors.DocumentViewerEditorModel;
import it.jrc.osint.analysis.ui.editors.DocumentViewerOutlinePage;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotation;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationFilter;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.text.TextExtractionServiceEvent;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.ui.PartListener2Adapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DocumentViewerEditor
extends MultiPageEditorPart
implements ISelectionProvider {
    private static final Logger log = LogManager.getLogger((String)DocumentViewerEditor.class.getName());
    public static final String ID_PREFIX = "it.jrc.osint.ui.editors.DocumentViewerEditor";
    private DocumentTextViewer textViewer;
    private DocumentHTMLViewer htmlViewer;
    private DocumentOnlineViewer onlineViewer;
    private DocumentViewerOutlinePage outlinePage;
    private SelectedEntitiesFilter selectedEntitiesFilter = new SelectedEntitiesFilter();
    private DocumentViewerEditorModel model;
    private ICommandService cmdService;
    private boolean visible;
    private ResourceId fileId;
    private EntityContainer entityContainerAdapter;
    private IPartListener2 partListener = new PartListenerImpl();
    private ISelectionListener navigatorSelectionListener = new NavigatorSelectionListener();
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private boolean underlyingFileDeleted;

    protected void createPages() {
        if (this.model.hasDocument()) {
            this.createTextViewerPage();
            this.textViewer.setModel(this.model);
        }
        if (this.model.hasHTMLSource()) {
            this.createHTMLViewerPage();
            this.htmlViewer.setModel(this.model);
        }
        this.createOnlineViewerPage();
        this.onlineViewer.setModel(this.model);
        this.updateTitle();
    }

    private void createTextViewerPage() {
        this.textViewer = new DocumentTextViewer(this.getContainer(), 0);
        int index = this.addPage((Control)this.textViewer);
        this.setPageText(index, "Text");
    }

    private void createHTMLViewerPage() {
        this.htmlViewer = new DocumentHTMLViewer(this.getContainer(), 0);
        int index = this.addPage((Control)this.htmlViewer);
        this.setPageText(index, "HTML");
    }

    private void createOnlineViewerPage() {
        this.onlineViewer = new DocumentOnlineViewer(this.getContainer(), 0);
        int index = this.addPage((Control)this.onlineViewer);
        this.setPageText(index, "Online");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IFileEditorInput fileInput = (IFileEditorInput)input;
        IFile aFile = fileInput.getFile();
        this.loadDocument(aFile);
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                DocumentViewerEditor.this.fireDirtyPropertyChanged();
            }
        });
        this.getSite().getPage().addPartListener(this.partListener);
        this.cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
        ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
        selectionService.addPostSelectionListener(this.navigatorSelectionListener);
        AnalysisUIPlugin.getEventBroker().register(new String[]{"osint/workspace/metaDataChanged", "osint/workspace/resourceDeleted", "osint/workspace/resourceMoved", "osint/analysis/ui/showEntityMarkup", "osint/analysis/ui/resetEntityMarkup", "osint/textExtraction/extractionSuccess"}, this.topicEventListener);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void removeListeners() {
        ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
        if (selectionService != null) {
            selectionService.removePostSelectionListener(this.navigatorSelectionListener);
        }
        AnalysisUIPlugin.getEventBroker().unregister(this.topicEventListener);
        this.getSite().getPage().removePartListener(this.partListener);
    }

    IFile getFile() {
        return this.getWorkspaceService().getFile(this.fileId);
    }

    private void loadDocument(IFile aFile) {
        if (aFile == null) {
            return;
        }
        this.fileId = this.getWorkspaceService().getId(aFile.getFullPath());
        boolean hasMetaData = this.getWorkspaceService().containsDocument(this.fileId);
        if (hasMetaData) {
            if (this.model == null) {
                this.model = new DocumentViewerEditorModel(this.fileId);
            } else {
                this.model.setResourceId(this.fileId);
            }
        } else {
            String fileLocation = aFile.getLocation().toString();
            this.model = new DocumentViewerEditorModel("file://" + fileLocation);
        }
        this.updateTitle();
    }

    public void dispose() {
        super.dispose();
    }

    private void updateTitle() {
        DocumentMetaItem metaItem;
        IEditorInput input = this.getEditorInput();
        String title = null;
        if (this.model.hasDocument() && (metaItem = this.model.loadDocumentMetaItem(this.model.getResourceId())) != null) {
            title = metaItem.getTitle();
        }
        if (title == null || "".equals(title) || "null".equals(title)) {
            title = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile().getName() : "<Unknown Title>";
        }
        this.setPartName(title);
        this.setTitleToolTip(input.getToolTipText());
    }

    private void fireDirtyPropertyChanged() {
        Display display = this.getSite().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                DocumentViewerEditor.this.firePropertyChange(257);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (adapter.equals(EntityContainer.class)) {
            if (!this.model.hasDocument()) {
                return null;
            }
            return this.getEntityContainer();
        }
        if (IContentOutlinePage.class.equals((Object)adapter) && this.outlinePage == null) {
            this.outlinePage = new DocumentViewerOutlinePage(this.getEntityContainer());
            return this.outlinePage;
        }
        return null;
    }

    private EntityContainer getEntityContainer() {
        if (this.entityContainerAdapter == null) {
            this.entityContainerAdapter = new EntityContainerAdapter();
        }
        return this.entityContainerAdapter;
    }

    public DocumentViewerEditorModel getEditorModel() {
        return this.model;
    }

    private WorkspaceService getWorkspaceService() {
        return AnalysisUIPlugin.getWorkspaceService();
    }

    private boolean isVisible() {
        return this.visible;
    }

    private boolean reuseEditor() {
        Command cmd = this.cmdService.getCommand("osint.analysis.command.ToggleReuseDocumentViewer");
        State toggleState = cmd.getState("org.eclipse.ui.commands.toggleState");
        Boolean stateValue = (Boolean)toggleState.getValue();
        return stateValue;
    }

    private IContentType getContentType(IFile aFile) {
        IContentType contentType;
        IContentDescription contentDescription;
        block5: {
            if (aFile == null || !aFile.exists()) {
                return null;
            }
            try {
                contentDescription = aFile.getContentDescription();
                if (contentDescription != null) break block5;
                log.debug("Content description of file " + aFile.getName() + " is null, try to retrieve from IContentTypeManager");
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(aFile.getContents(), aFile.getName(), IContentDescription.ALL);
                if (contentDescription == null) {
                    log.debug("Failed to retrieve contentDescription from IContentTypeManager");
                }
                if ((contentType = Platform.getContentTypeManager().findContentTypeFor(aFile.getContents(), aFile.getName())) != null) break block5;
                log.debug("Failed to find content type for file " + aFile.getName());
                return null;
            }
            catch (Throwable t) {
                log.error("Failed to get content type for file " + aFile.getName(), t);
                return null;
            }
        }
        contentType = contentDescription.getContentType();
        return contentType;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        if (this.model.getResourceId() == null) {
            return StructuredSelection.EMPTY;
        }
        StructuredSelection sel = new StructuredSelection((Object)this.model.getResourceId());
        return sel;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    private class EntityContainerAdapter
    implements EntityContainer,
    PropertyChangeListener {
        private Set<EntityContainerChangeListener> changeListenerSet = new HashSet<EntityContainerChangeListener>();

        private EntityContainerAdapter() {
        }

        public ResourceId getProjectId() {
            CaseProject cp;
            ResourceId projectId = ResourceId.NULL_ID;
            ResourceId docId = DocumentViewerEditor.this.getEditorModel().getResourceId();
            if (DocumentViewerEditor.this.getWorkspaceService().containsDocument(docId) && (cp = AnalysisUIPlugin.getWorkspaceService().getCaseProjectByDocumentId(docId)) != null) {
                projectId = cp.getId();
            }
            return projectId;
        }

        public Set<Entity> getEntities() {
            AnalysisDatamodel adm;
            CaseProject cp;
            Set entitySet = Collections.emptySet();
            if (DocumentViewerEditor.this.getEditorModel() == null) {
                return Collections.emptySet();
            }
            ResourceId docId = DocumentViewerEditor.this.getEditorModel().getResourceId();
            if (DocumentViewerEditor.this.getWorkspaceService().containsDocument(docId) && (cp = AnalysisUIPlugin.getWorkspaceService().getCaseProjectByDocumentId(docId)) != null && !(adm = AnalysisUIPlugin.getAnalysisService().getAnalysisDatamodel(cp.getId(), false)).isNull()) {
                entitySet = adm.getRelatedEntities(docId);
            }
            return entitySet;
        }

        public void addChangeListener(EntityContainerChangeListener listener) {
            this.changeListenerSet.add(listener);
            if (this.changeListenerSet.size() >= 1 && DocumentViewerEditor.this.getEditorModel() != null) {
                DocumentViewerEditor.this.getEditorModel().addPropertyChangeListener(this);
            }
        }

        public void removeChangeListener(EntityContainerChangeListener listener) {
            this.changeListenerSet.remove(listener);
            if (this.changeListenerSet.size() == 0 && DocumentViewerEditor.this.getEditorModel() != null) {
                DocumentViewerEditor.this.getEditorModel().removePropertyChangedListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dirty")) {
                for (EntityContainerChangeListener listener : this.changeListenerSet) {
                    listener.entitiesChanged();
                }
            }
        }
    }

    private class NavigatorSelectionListener
    implements ISelectionListener {
        private NavigatorSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof ProjectExplorer && DocumentViewerEditor.this.isVisible() && DocumentViewerEditor.this.reuseEditor()) {
                this.onSelection(selection);
            }
        }

        private void onSelection(ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object selectedObj = structuredSelection.getFirstElement();
            if (selectedObj == null) {
                return;
            }
            if (selectedObj instanceof IFile) {
                IFile selectedFile = (IFile)selectedObj;
                IContentType contentType = DocumentViewerEditor.this.getContentType(selectedFile);
                if (contentType == null) {
                    return;
                }
                IEditorRegistry editorRegistry = DocumentViewerEditor.this.getSite().getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                if (editorRegistry == null) {
                    return;
                }
                IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor(selectedFile.getName(), contentType);
                if (editorDescriptor == null) {
                    return;
                }
                String editorId = DocumentViewerEditor.this.getSite().getId();
                if (editorDescriptor.getId().equals(editorId)) {
                    DocumentViewerEditor.this.loadDocument((IFile)selectedObj);
                }
            }
        }
    }

    private class PartListenerImpl
    extends PartListener2Adapter {
        private PartListenerImpl() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == null) {
                return;
            }
            if (part != DocumentViewerEditor.this) {
                return;
            }
            if (DocumentViewerEditor.this.underlyingFileDeleted) {
                DocumentViewerEditor.this.getSite().getShell().getDisplay().asyncExec((Runnable)new LoggingRunnable(log){

                    public void runWithLogging() {
                        DocumentViewerEditor.this.getSite().getPage().closeEditor((IEditorPart)DocumentViewerEditor.this, false);
                    }
                });
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof DocumentViewerEditor && part == DocumentViewerEditor.this) {
                log.debug("DocumentViewerEditor hidden: " + DocumentViewerEditor.this.getTitle());
                DocumentViewerEditor.this.visible = false;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof DocumentViewerEditor && part == DocumentViewerEditor.this) {
                log.debug("DocumentViewerEditor visible: " + DocumentViewerEditor.this.getTitle());
                DocumentViewerEditor.this.visible = true;
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (DocumentViewerEditor.this == part) {
                DocumentViewerEditor.this.removeListeners();
            }
        }
    }

    private class SelectedEntitiesFilter
    implements EntityTextAnnotationFilter {
        private Set<Entity> showEntities = new HashSet<Entity>();

        private SelectedEntitiesFilter() {
        }

        public void showMarkup(Set<Entity> entities) {
            this.showEntities.addAll(entities);
        }

        public void clear() {
            this.showEntities.clear();
        }

        @Override
        public boolean filterOut(EntityTextAnnotation annotation) {
            Entity anEntity = annotation.getEntity();
            return !this.showEntities.contains(anEntity);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            TextExtractionServiceEvent teEvent;
            WorkspaceServiceEvent wsEvent;
            if ("osint/workspace/resourceDeleted".equals(event.getTopic()) && (wsEvent = (WorkspaceServiceEvent)event).getResourceIds().contains(DocumentViewerEditor.this.fileId)) {
                if (DocumentViewerEditor.this.isDirty()) {
                    DocumentViewerEditor.this.underlyingFileDeleted = true;
                } else {
                    DocumentViewerEditor.this.getSite().getShell().getDisplay().asyncExec((Runnable)new LoggingRunnable(log){

                        public void runWithLogging() {
                            DocumentViewerEditor.this.getSite().getPage().closeEditor((IEditorPart)DocumentViewerEditor.this, false);
                        }
                    });
                }
            }
            if ("osint/textExtraction/extractionSuccess".equals(event.getTopic()) && (teEvent = (TextExtractionServiceEvent)event).getResourceIds().contains(DocumentViewerEditor.this.fileId)) {
                DocumentViewerEditor.this.model.setResourceId(DocumentViewerEditor.this.fileId);
            }
            if ("osint/workspace/metaDataChanged".equals(event.getTopic()) && (wsEvent = (WorkspaceServiceEvent)event).getResourceIds().contains(DocumentViewerEditor.this.fileId)) {
                DocumentViewerEditor.this.model.setResourceId(DocumentViewerEditor.this.fileId);
            }
            if ("osint/workspace/resourceMoved".equals(event.getTopic()) && (wsEvent = (WorkspaceServiceEvent)event).getResourceIds().contains(DocumentViewerEditor.this.fileId)) {
                IFile movedFile = AnalysisUIPlugin.getWorkspaceService().getFile(DocumentViewerEditor.this.fileId);
                FileEditorInput newInputResource = new FileEditorInput(movedFile);
                DocumentViewerEditor.this.setInput((IEditorInput)newInputResource);
                DocumentViewerEditor.this.updateTitle();
            }
            if ("osint/analysis/ui/showEntityMarkup".equals(event.getTopic()) && DocumentViewerEditor.this.isVisible()) {
                AnalysisUIEvent auEvent = (AnalysisUIEvent)event;
                Set<Entity> entities = auEvent.getEntities();
                DocumentViewerEditor.this.selectedEntitiesFilter.showMarkup(entities);
                DocumentViewerEditor.this.textViewer.addFilter(DocumentViewerEditor.this.selectedEntitiesFilter);
                DocumentViewerEditor.this.model.setResourceId(DocumentViewerEditor.this.fileId);
            }
            if ("osint/analysis/ui/resetEntityMarkup".equals(event.getTopic()) && DocumentViewerEditor.this.isVisible()) {
                DocumentViewerEditor.this.selectedEntitiesFilter.clear();
                DocumentViewerEditor.this.textViewer.clearFilter();
                DocumentViewerEditor.this.model.setResourceId(DocumentViewerEditor.this.fileId);
            }
        }
    }
}

